/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.sso.idp.IdentityStoreInboundProvisioningUserRepository;
import com.pingidentity.admin.api.model.sso.idp.InboundProvisioningUserRepository;
import com.pingidentity.admin.api.model.sso.idp.LdapInboundProvisioningUserRepository;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.LdapNameValidator;
import com.pingidentity.admin.api.validator.LdapSearchFilterValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.IdentityStoreProvisionerInstance;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.IdentityStoreProvisionerManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class UserRepositoryValidator {
    private UserRepositoryValidator() {
    }

    public static Validator getInstance(InboundProvisioningUserRepository userRepository, Collection<String> availableUserVars, Collection<String> availableGroupVars, boolean isGroupSupport, ValidatorContext context) {
        switch (userRepository.getType()) {
            case LDAP: {
                LdapInboundProvisioningUserRepository ldapInboundProvisioningUserRepository = (LdapInboundProvisioningUserRepository)userRepository;
                return new LdapInboundProvisioningUserRepositoryValidator(ldapInboundProvisioningUserRepository, availableUserVars, availableGroupVars, isGroupSupport, context);
            }
            case IDENTITY_STORE: {
                IdentityStoreInboundProvisioningUserRepository identityStoreInboundProvisioningUserRepository = (IdentityStoreInboundProvisioningUserRepository)userRepository;
                return new IdentityStoreInboundProvisioningUserRepositoryValidator(identityStoreInboundProvisioningUserRepository);
            }
        }
        return null;
    }

    private static class IdentityStoreInboundProvisioningUserRepositoryValidator
    extends CompositeValidator {
        private final IdentityStoreInboundProvisioningUserRepository identityStoreInboundProvisioningUserRepository;
        private final IdentityStoreProvisionerManager ispManager = MgmtFactory.getIdentityStoreProvisionerManager();

        private IdentityStoreInboundProvisioningUserRepositoryValidator(IdentityStoreInboundProvisioningUserRepository identityStoreInboundProvisioningUserRepository) {
            this.identityStoreInboundProvisioningUserRepository = identityStoreInboundProvisioningUserRepository;
            this.addValidator((Validator)new ResourceIdValidator(identityStoreInboundProvisioningUserRepository.getIdentityStoreProvisionerRef(), "Identity Store Plugin Descriptor Reference ID", ConnectionPaths.InboundProvisionPaths.getIdentityStorePluginDescriptorRef()));
        }

        @Override
        public boolean validate() {
            boolean isValid = super.validate();
            if (isValid) {
                String pluginId = this.identityStoreInboundProvisioningUserRepository.getIdentityStoreProvisionerRef().getId();
                IdentityStoreProvisionerInstance pluginInstance = (IdentityStoreProvisionerInstance)this.ispManager.getInstance(pluginId);
                String pluginInstanceRefPath = ConnectionPaths.InboundProvisionPaths.getIdentityStorePluginDescriptorRef();
                if (pluginInstance == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.identity_store_provisioner_not_found, pluginInstanceRefPath, new Object[]{pluginId}));
                }
            }
            return isValid;
        }
    }

    private static class LdapInboundProvisioningUserRepositoryValidator
    extends CompositeValidator {
        private final LdapInboundProvisioningUserRepository ldapInboundProvisioningUserRepository;
        private final Collection<String> availableUserVars;
        private final Collection<String> availableGroupVars;
        private final boolean isGroupSupport;
        private final ValidatorContext context;
        private final DataSourceManager dsManager = MgmtFactory.getDataSourceManager();

        private LdapInboundProvisioningUserRepositoryValidator(LdapInboundProvisioningUserRepository ldapInboundProvisioningUserRepository, Collection<String> availableUserVars, Collection<String> availableGroupVars, boolean isGroupSupport, ValidatorContext context) {
            this.ldapInboundProvisioningUserRepository = ldapInboundProvisioningUserRepository;
            this.availableUserVars = availableUserVars;
            this.availableGroupVars = availableGroupVars;
            this.isGroupSupport = isGroupSupport;
            this.context = context;
            this.addValidator((Validator)new ResourceIdValidator(ldapInboundProvisioningUserRepository.getDataStoreRef(), "Active Directory Data Store Reference ID", ConnectionPaths.InboundProvisionPaths.getActiveDirectoryDataStoreRef()));
        }

        @Override
        public boolean validate() {
            boolean isValid = super.validate();
            if (isValid) {
                String dataStoreId = this.ldapInboundProvisioningUserRepository.getDataStoreRef().getId();
                LdapDataSource ldapDataSource = this.dsManager.getLdapDataSource(dataStoreId);
                String dataStoreRefPath = ConnectionPaths.InboundProvisionPaths.getActiveDirectoryDataStoreRef();
                if (ldapDataSource == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.data_store_not_found, dataStoreRefPath, new Object[]{dataStoreId}));
                    isValid = false;
                } else {
                    boolean isSupported = ldapDataSource.isActiveDirectoryType();
                    LdapInfo.LdapType ldapType = ldapDataSource.getLdapType();
                    if (!isSupported) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_provisioning_user_repository_unsupported_ldap_data_store, dataStoreRefPath, new Object[]{ldapType}));
                        isValid = false;
                    }
                    if (!ldapDataSource.getUseSSL() && !ldapDataSource.getUseStartTLS()) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_provisioning_user_repository_ssl_or_start_tls_required, dataStoreRefPath, new Object[]{ldapType}));
                        isValid = false;
                    }
                    if (isValid && !this.isBypassExternalValidation()) {
                        try {
                            ldapDataSource.testConnection();
                        }
                        catch (Exception e) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_provisioning_user_repository_data_store_unavailable, dataStoreRefPath, new Object[]{ldapType}));
                            isValid = false;
                        }
                    }
                }
            }
            if (isValid && StringUtils.isNotBlank((String)this.ldapInboundProvisioningUserRepository.getBaseDn())) {
                LdapNameValidator baseDnValidator = new LdapNameValidator(this.ldapInboundProvisioningUserRepository.getBaseDn(), this.getSubstitutionVars(), ApiMessageKey.ldap_attribute_source_base_dn_malformed, ApiMessageKey.ldap_attribute_source_base_dn_var_not_found, ConnectionPaths.InboundProvisionPaths.getActiveDirectoryBaseDn());
                isValid = this.runValidator((Validator)baseDnValidator);
            }
            if (isValid) {
                LdapSearchFilterValidator uniqueUserIdFilterValidator = new LdapSearchFilterValidator(this.ldapInboundProvisioningUserRepository.getUniqueUserIdFilter(), this.availableUserVars, "SCIM User Request", ApiMessageKey.ldap_attribute_source_search_filter_required, ApiMessageKey.ldap_attribute_source_search_filter_var_not_found, ConnectionPaths.InboundProvisionPaths.getActiveDirectoryUniqueUserIdFilter(), "ONELEVEL_SCOPE", this.isBypassExternalValidation());
                isValid = this.runValidator((Validator)uniqueUserIdFilterValidator);
            }
            if (this.isGroupSupport && isValid) {
                LdapSearchFilterValidator uniqueGroupIdFilterValidator = new LdapSearchFilterValidator(this.ldapInboundProvisioningUserRepository.getUniqueGroupIdFilter(), this.availableGroupVars, "SCIM Group Request", ApiMessageKey.ldap_attribute_source_search_filter_required, ApiMessageKey.ldap_attribute_source_search_filter_var_not_found, ConnectionPaths.InboundProvisionPaths.getActiveDirectoryUniqueGroupIdFilter(), "ONELEVEL_SCOPE", this.isBypassExternalValidation());
                isValid = this.runValidator((Validator)uniqueGroupIdFilterValidator);
            }
            return isValid;
        }

        private Collection<String> getSubstitutionVars() {
            if (this.isGroupSupport) {
                return this.availableGroupVars;
            }
            return this.availableUserVars;
        }

        private boolean runValidator(Validator validator) {
            boolean result = validator.validate();
            if (!result) {
                this.appendErrors(validator.getErrors());
            }
            return result;
        }

        private boolean isBypassExternalValidation() {
            return this.context != null && this.context.isBypassExternalValidation();
        }
    }
}

