/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.simple.ListContainsValidator;
import com.pingidentity.admin.api.validator.simple.ListSizeValidator;
import com.pingidentity.pf.admin.rest.translator.internal.model.ShortcutIds;
import com.pingidentity.pf.admin.rest.translator.internal.model.UserPreferences;
import com.pingidentity.pf.common.api.validator.Validator;

public class UserShortcutsValidator
extends CompositeValidator {
    private static final ApiMessageKey INVALID_UI_SHORTCUT = ApiMessageKey.ui_invalid_shortcut_value;
    private static final ApiMessageKey INVALID_UI_SHORTCUT_LIST_SIZE = ApiMessageKey.ui_invalid_shortcut_list_size;

    public UserShortcutsValidator(UserPreferences userPreferences, ShortcutIds validShortcuts) {
        this.addValidator((Validator)new NotNullValidator(userPreferences.getShortcuts(), "shortcut IDs", "shortcuts"));
        for (String shortcutId : userPreferences.getShortcuts().getItems()) {
            this.addValidator((Validator)new ListContainsValidator<String>(validShortcuts.getItems(), shortcutId, INVALID_UI_SHORTCUT, shortcutId));
        }
        this.addValidator((Validator)new ListSizeValidator(userPreferences.getShortcuts().getItems(), 10, 1, INVALID_UI_SHORTCUT_LIST_SIZE));
    }
}

