/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.fieldpaths.CredentialsPath;
import com.pingidentity.admin.api.validator.AbstractCertValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;

public class VerificationCertValidator
extends AbstractCertValidator {
    private final boolean isUpdate;
    private final List<ConnectionCert> certs;
    protected final ConnectionBase existingConn;
    private ConnectionCerts domainCerts;
    private final boolean fullValidationPath;

    public VerificationCertValidator(boolean isUpdate, ConnectionBase existingConn, List<ConnectionCert> certs, boolean fullValidationPath) {
        this.isUpdate = isUpdate;
        this.existingConn = existingConn;
        this.certs = certs;
        this.fullValidationPath = fullValidationPath;
    }

    public boolean validate() {
        int initialNumErrors = this.getErrors().size();
        if (this.certs != null && !this.certs.isEmpty()) {
            Cert primaryVerificationCert = null;
            Cert secondaryVerificationCert = null;
            Integer secondaryCertIndex = null;
            ArrayList<Cert> activeVerificationCerts = new ArrayList<Cert>();
            HashSet<Cert> inactiveVerificationCerts = new HashSet<Cert>();
            HashMap<String, Integer> validCertFingerPrintMap = new HashMap<String, Integer>();
            HashMap<String, Integer> validCertDisplayNameMap = new HashMap<String, Integer>();
            ArrayList<String> certAliases = new ArrayList<String>();
            for (int i = 0; i < this.certs.size(); ++i) {
                String id;
                String string = id = this.certs.get(i).getX509File() == null ? null : this.certs.get(i).getX509File().getId();
                if (id != null) {
                    IdValidator idValidator = new IdValidator(id, true, true, 0, 33, CredentialsPath.getConnectionCertX509Id(i, true));
                    idValidator.validate();
                    this.appendErrors(idValidator.getErrors());
                    certAliases.add(id);
                }
                if (this.certs.get(i).isActiveVerificationCert() == null) {
                    if (Boolean.TRUE.equals(this.certs.get(i).isPrimaryVerificationCert()) || Boolean.TRUE.equals(this.certs.get(i).isSecondaryVerificationCert())) {
                        this.certs.get(i).setActiveVerificationCert(Boolean.TRUE);
                    } else {
                        this.certs.get(i).setActiveVerificationCert(Boolean.FALSE);
                    }
                }
                String credentialFieldPath = CredentialsPath.getConnectionCertX509FileData(i, this.fullValidationPath);
                Cert cert = this.validateCert(this.certs.get(i), credentialFieldPath, "Verification Certificate", false);
                if (cert == null) continue;
                cert.setId(id);
                Integer previousCertIndex = (Integer)validCertFingerPrintMap.get(cert.getFingerPrint(HashAlgorithm.SHA256));
                if (previousCertIndex == null) {
                    previousCertIndex = (Integer)validCertDisplayNameMap.get(cert.getDescriptionForDisplay(35));
                }
                if (previousCertIndex != null) {
                    if (this.fullValidationPath) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.connection_cert_duplicate_cert, this.getCertPath(i), new Object[]{previousCertIndex}));
                        continue;
                    }
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.connection_cert_duplicate_entry, null));
                    continue;
                }
                validCertFingerPrintMap.put(cert.getFingerPrint(HashAlgorithm.SHA256), i);
                validCertDisplayNameMap.put(cert.getDescriptionForDisplay(35), i);
                if (Boolean.TRUE.equals(this.certs.get(i).isPrimaryVerificationCert()) && Boolean.TRUE.equals(this.certs.get(i).isSecondaryVerificationCert())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.primary_and_secondary_verification_cert_same, this.getCertPath(i)));
                }
                if (Boolean.TRUE.equals(this.certs.get(i).isPrimaryVerificationCert()) && Boolean.FALSE.equals(this.certs.get(i).isActiveVerificationCert())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.primary_certificate_must_be_active, this.getCertPath(i)));
                }
                if (Boolean.TRUE.equals(this.certs.get(i).isSecondaryVerificationCert()) && Boolean.FALSE.equals(this.certs.get(i).isActiveVerificationCert())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.secondary_certificate_must_be_active, this.getCertPath(i)));
                }
                if (Boolean.TRUE.equals(this.certs.get(i).isPrimaryVerificationCert())) {
                    if (primaryVerificationCert != null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.multiple_primary_verification_certs, this.getCertPath(i)));
                        continue;
                    }
                    primaryVerificationCert = cert;
                    continue;
                }
                if (Boolean.TRUE.equals(this.certs.get(i).isSecondaryVerificationCert())) {
                    if (secondaryVerificationCert != null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.multiple_secondary_verification_certs, this.getCertPath(i)));
                        continue;
                    }
                    secondaryVerificationCert = cert;
                    secondaryCertIndex = i;
                    continue;
                }
                if (Boolean.TRUE.equals(this.certs.get(i).isActiveVerificationCert())) {
                    activeVerificationCerts.add(cert);
                    continue;
                }
                inactiveVerificationCerts.add(cert);
            }
            if (certAliases.size() > 1) {
                this.validateUniqueCertAliases(certAliases);
            }
            if (primaryVerificationCert != null) {
                activeVerificationCerts.add(0, primaryVerificationCert);
                if (secondaryVerificationCert != null) {
                    activeVerificationCerts.add(1, secondaryVerificationCert);
                }
            }
            if (primaryVerificationCert == null && secondaryVerificationCert != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.secondary_certificate_without_primary, this.getCertPath(secondaryCertIndex)));
            }
            this.domainCerts = new ConnectionCerts();
            this.domainCerts.setVerificationCerts(activeVerificationCerts, inactiveVerificationCerts);
        }
        return this.getErrors().size() == initialNumErrors;
    }

    public ConnectionCerts getDomainCerts() {
        return this.domainCerts;
    }

    protected ConnectionCerts getVerificationCerts() {
        return this.existingConn.getDsigVerificationCerts();
    }

    protected String getPrimaryCertPath(int certIndex) {
        return CredentialsPath.getConnectionCertPrimaryVerificationCert(certIndex, this.fullValidationPath);
    }

    protected String getCertPath(int certIndex) {
        return CredentialsPath.getConnectionCert(certIndex, this.fullValidationPath);
    }

    protected String getCertsPath() {
        return CredentialsPath.getConnectionCerts(true);
    }

    private void validateUniqueCertAliases(List<String> certAliases) {
        UniqueEntriesValidator.UniqueKeyGetter<String> CertAliasesUniqueKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<String>(){

            @Override
            public String getKey(String object) {
                return object;
            }
        };
        UniqueEntriesValidator<String> uniqueEntriesValidator = new UniqueEntriesValidator<String>(CertAliasesUniqueKeyGetter, certAliases, this.getCertsPath(), ApiMessageKey.connection_certs_duplicate_id);
        uniqueEntriesValidator.validate();
        this.appendErrors(uniqueEntriesValidator.getErrors());
    }
}

