/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.VirtualHostNameSettings;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ListNoNullEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.sourceid.common.ValidationUtil;

public class VirtualHostNameSettingsValidator
extends CompositeValidator {
    public static final String VIRTUAL_HOST_NAMES_PATH = "virtualHostNames";
    private String customFieldPath;
    VirtualHostNameSettings settings = new VirtualHostNameSettings();

    public VirtualHostNameSettingsValidator(@NonNull List<String> virtualHostNames, String fieldPath) {
        this.settings.setVirtualHostNames(virtualHostNames);
        this.customFieldPath = fieldPath;
        ListNoNullEntriesValidator<String> validator = new ListNoNullEntriesValidator<String>(this.settings.getVirtualHostNames(), fieldPath);
        this.addValidator((Validator)validator);
    }

    public VirtualHostNameSettingsValidator(@NonNull VirtualHostNameSettings settings) {
        this.settings.setVirtualHostNames(new ArrayList<String>(settings.getVirtualHostNames()));
        ListNoNullEntriesValidator<String> validator = new ListNoNullEntriesValidator<String>(this.settings.getVirtualHostNames(), VIRTUAL_HOST_NAMES_PATH);
        this.addValidator((Validator)validator);
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.hasErrors()) {
            return false;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < this.settings.getVirtualHostNames().size(); ++i) {
            String vhn = this.settings.getVirtualHostNames().get(i);
            if (!ValidationUtil.isHostnameValid((String)vhn)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.virtual_hostname_format_invalid, (String)(this.customFieldPath != null ? this.customFieldPath : "virtualHostNames[" + i + "]"), new Object[]{vhn}));
                continue;
            }
            if (set.add(vhn)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_entry, (String)(this.customFieldPath != null ? this.customFieldPath : "virtualHostNames[" + i + "]"), new Object[]{"virtual host names list", vhn}));
        }
        return !this.hasErrors();
    }
}

