/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml1x.profiles.ap.CreateResponse;
import org.sourceid.wstrust.model.Saml11O365SecurityToken;
import org.sourceid.wstrust.model.Saml11SecurityToken;
import org.sourceid.wstrust.model.Saml20SecurityToken;

public class WsTrustAttributeNameSpaceValidator
extends AbstractValidator {
    private Set<String> validFormats = new HashSet<String>();
    private String nameFormat;
    private String samlTokenType;
    private int index;
    private ConfigStore createResponseConfig = ConfigStoreFarm.getConfig(CreateResponse.class);
    private String saml11DefaultNamespace = this.createResponseConfig.getStringValue("ns", "ns:unspecified");

    public WsTrustAttributeNameSpaceValidator(String nameFormat, String samlTokenType, int index) {
        this.nameFormat = nameFormat;
        this.samlTokenType = samlTokenType;
        this.index = index;
        this.populateValidNameFormatSet(this.validFormats);
    }

    public boolean validate() {
        if (this.validFormats.contains(this.nameFormat)) {
            if (this.validateUnspecifiedNamespace()) {
                return true;
            }
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_contract_name_space_mismatch, ConnectionPaths.WsTrustPaths.getAttributeContractExtended(this.index), new Object[]{this.samlTokenType, this.nameFormat}));
        } else if (StringUtils.isBlank((String)this.nameFormat)) {
            if (this.samlTokenType.equals(Saml20SecurityToken.TYPE)) {
                return true;
            }
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.extended_attribute_contract_name_space_required, ConnectionPaths.WsTrustPaths.getAttributeContractExtended(this.index)));
        } else {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_contract_invalid_name_space, ConnectionPaths.WsTrustPaths.getAttributeContractExtended(this.index)));
        }
        return false;
    }

    private void populateValidNameFormatSet(Set<String> validFormats) {
        validFormats.add(this.saml11DefaultNamespace);
        validFormats.add("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        validFormats.add("http://schemas.xmlsoap.org/claims");
        ConfigStore customNameFormatConfigStore = ConfigStoreFarm.getConfig((String)"custom-name-formats");
        Map customAttributeNameFormats = customNameFormatConfigStore.getMapValue("sts-attribute-namespaces", Collections.EMPTY_MAP);
        for (Object value : customAttributeNameFormats.values()) {
            validFormats.add((String)value);
        }
    }

    private boolean validateUnspecifiedNamespace() {
        boolean isSaml20Token = this.samlTokenType.equals(Saml20SecurityToken.TYPE);
        boolean isSaml11Token = this.samlTokenType.equals(Saml11SecurityToken.TYPE);
        boolean isSaml11O365Token = this.samlTokenType.equals(Saml11O365SecurityToken.TYPE);
        if (!isSaml20Token && this.nameFormat.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified")) {
            return false;
        }
        return isSaml11Token || isSaml11O365Token || !this.nameFormat.equals(this.saml11DefaultNamespace);
    }
}

