/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.HashSet;
import java.util.List;

public class WsTrustRestrictedVirtualServerIdsValidator
extends AbstractValidator {
    private final List<String> connectionVirtualServerIds;
    private final List<String> restrictedVirtualServerIds;
    private final int mappingIndex;

    public WsTrustRestrictedVirtualServerIdsValidator(List<String> connectionVirtualServerIds, List<String> restrictedVirtualServerIds, int mappingIndex) {
        this.connectionVirtualServerIds = connectionVirtualServerIds;
        this.restrictedVirtualServerIds = restrictedVirtualServerIds;
        this.mappingIndex = mappingIndex;
    }

    public boolean validate() {
        if (this.connectionVirtualServerIds != null && !this.connectionVirtualServerIds.isEmpty()) {
            HashSet<String> uniqueVsids = new HashSet<String>();
            HashSet<String> vsids = new HashSet<String>(this.connectionVirtualServerIds);
            int vsidIndex = 0;
            for (String id : this.restrictedVirtualServerIds) {
                ValidationError error;
                if (!vsids.contains(id)) {
                    error = ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_server_id_invalid, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappingsVsid(this.mappingIndex, vsidIndex));
                    this.appendError(error);
                } else if (!uniqueVsids.add(id)) {
                    error = ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_entry, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappingsVsid(this.mappingIndex, vsidIndex), new Object[]{"Restricted Virtual Server ID", id});
                    this.appendError(error);
                }
                ++vsidIndex;
            }
        } else if (this.restrictedVirtualServerIds != null && !this.restrictedVirtualServerIds.isEmpty()) {
            ValidationError error = ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_server_id_not_allowed, ConnectionPaths.WsTrustPaths.getTokenGeneratorMappingsVsid(this.mappingIndex, 0));
            this.appendError(error);
        }
        return !this.hasErrors();
    }
}

