/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.localidentity;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import org.sourceid.saml20.domain.LdapDataSource;

public class LdapObjectClassValidator
extends CompositeValidator {
    private final String objectClass;
    private final LdapDataSource dataSource;
    private final ApiMessageKey invalidObjectClassKey;
    private final String fieldPath;

    public LdapObjectClassValidator(String objectClass, LdapDataSource dataSource, ApiMessageKey invalidObjectClassKey, String fieldPath) {
        this.objectClass = objectClass;
        this.dataSource = dataSource;
        this.invalidObjectClassKey = invalidObjectClassKey;
        this.fieldPath = fieldPath;
    }

    @Override
    public boolean validate() {
        List objectClasses;
        boolean isValid = super.validate();
        if (isValid && ((objectClasses = this.dataSource.getStructuralObjectClasses()) == null || !objectClasses.contains(this.objectClass))) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.invalidObjectClassKey, this.fieldPath, new Object[]{this.objectClass}));
            isValid = false;
        }
        return isValid;
    }

    public static LdapObjectClassValidator getInstance(String objectClass, LdapDataSource dataSource, String fieldPath, boolean required) {
        ApiMessageKey message = ApiMessageKey.local_identity_profile_data_store_object_class_invalid;
        LdapObjectClassValidator validator = new LdapObjectClassValidator(objectClass, dataSource, message, fieldPath);
        if (required) {
            validator.addValidator((Validator)new NotBlankValidator(objectClass, "Object Class", fieldPath));
        }
        return validator;
    }
}

