/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.AuthorizationDetailTypesPaths;
import com.pingidentity.admin.api.model.oauth.AuthorizationDetailType;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.DuplicateValidator;
import com.pingidentity.admin.api.validator.simple.IsNotDefaultValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailProcessorDescriptor;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.authorizationdetails.AuthorizationDetailTypesManager;
import org.sourceid.saml20.domain.AuthorizationDetailProcessorInstance;
import org.sourceid.saml20.domain.mgmt.AuthorizationDetailProcessorsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthorizationDetailTypeValidator
extends CompositeValidator {
    private static final int TYPE_MAX_LENGTH = 256;
    private static final String ID_FRIENDLY_FIELD_NAME = "ID";
    private static final String AUTHORIZATION_DETAIL_TYPE_FRIENDLY_NAME = "Authorization Detail Type";
    private final AuthorizationDetailType authorizationDetailType;

    public AuthorizationDetailTypeValidator(AuthorizationDetailType authorizationDetailType, String existingType, ValidatorContext context) {
        this.authorizationDetailType = authorizationDetailType;
        boolean isCreate = !context.isUpdateRequest();
        AuthorizationDetailTypesManager manager = MgmtFactory.getAuthorizationDetailTypesManager();
        String id = authorizationDetailType.getId();
        IdValidator idValidator = new IdValidator(id, true, false, 0, 33, AuthorizationDetailTypesPaths.getId());
        idValidator.setBlankIdMessageKey(ApiMessageKey.field_blank);
        idValidator.setBlankIdMessageParams(ID_FRIENDLY_FIELD_NAME);
        this.addValidator((Validator)idValidator);
        this.addValidator((Validator)new IsNotDefaultValidator(id, ID_FRIENDLY_FIELD_NAME, AuthorizationDetailTypesPaths.getId()));
        if (isCreate) {
            this.addValidator((Validator)new DuplicateValidator<String>(id, AuthorizationDetailTypesPaths.getId(), ApiMessageKey.oauth_authorization_detail_id_exists, manager.getIds()));
        }
        this.addValidator((Validator)new NotBlankValidator(authorizationDetailType.getType(), AUTHORIZATION_DETAIL_TYPE_FRIENDLY_NAME, AuthorizationDetailTypesPaths.getType()));
        if (isCreate || existingType != null && !existingType.equals(authorizationDetailType.getType())) {
            this.addValidator((Validator)new DuplicateValidator<String>(authorizationDetailType.getType(), AuthorizationDetailTypesPaths.getType(), ApiMessageKey.oauth_authorization_detail_type_exists, manager.getTypes()));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateAuthorizationDetailTypeType();
        this.validateAuthorizationDetailProcessor();
        return !this.hasErrors();
    }

    private void validateAuthorizationDetailTypeType() {
        if (StringUtils.isNotBlank((String)this.authorizationDetailType.getType()) && this.authorizationDetailType.getType().length() > 256) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_authorization_detail_type_length_too_long, AuthorizationDetailTypesPaths.getType(), new Object[]{256}));
        }
    }

    private void validateAuthorizationDetailProcessor() {
        if (this.authorizationDetailType.getAuthorizationDetailProcessorRef() == null || StringUtils.isBlank((String)this.authorizationDetailType.getAuthorizationDetailProcessorRef().getId())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_authorization_detail_type_processor_required, AuthorizationDetailTypesPaths.getAuthorizationDetailProcessorRef()));
        } else {
            AuthorizationDetailProcessorsManager authorizationDetailProcessorsManager = MgmtFactory.getAuthorizationDetailProcessorsPluginManager();
            AuthorizationDetailProcessorInstance instance = (AuthorizationDetailProcessorInstance)authorizationDetailProcessorsManager.getInstance(this.authorizationDetailType.getAuthorizationDetailProcessorRef().getId());
            if (instance == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_authorization_detail_type_processor_not_found, AuthorizationDetailTypesPaths.getAuthorizationDetailProcessorRef(), new Object[]{this.authorizationDetailType.getAuthorizationDetailProcessorRef().getId()}));
            } else {
                AuthorizationDetailProcessorDescriptor descriptor = (AuthorizationDetailProcessorDescriptor)instance.getDescriptor();
                if (!this.isTypeSupportedByPlugin(this.authorizationDetailType.getType(), descriptor.getSupportedAuthorizationDetailTypes())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_authorization_detail_type_processor_does_not_support_configured_type, AuthorizationDetailTypesPaths.getType()));
                }
            }
        }
    }

    private boolean isTypeSupportedByPlugin(String authorizationDetailType, Set<String> pluginSupportedTypes) {
        if (pluginSupportedTypes.contains("ALL_AUTHORIZATION_DETAIL_TYPES") && pluginSupportedTypes.size() == 1) {
            return true;
        }
        return pluginSupportedTypes.contains(authorizationDetailType);
    }
}

