/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.IssuerPaths;
import com.pingidentity.admin.api.model.oauth.Issuer;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.DuplicateValidator;
import com.pingidentity.admin.api.validator.simple.HostnameValidator;
import com.pingidentity.admin.api.validator.simple.IsNotDefaultValidator;
import com.pingidentity.admin.api.validator.simple.RelativePathValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.issuer.OAuthIssuerManager;
import org.sourceid.oauth20.issuer.domain.OAuthIssuer;

public class OAuthIssuerValidator
extends CompositeValidator {
    private static final String ID_FRIENDLY_FIELD_NAME = "ID";
    private static final String ID_PATH = IssuerPaths.getId();
    private static final String NAME_FRIENDLY_NAME = "Name";
    private static final String NAME_PATH = IssuerPaths.getName();
    private static final String HOST_FRIENDLY_NAME = "Host";
    private static final String HOST_PATH = IssuerPaths.getHost();
    private static final String PATH_FRIENDLY_NAME = "Path";
    private static final String PATH_PATH = IssuerPaths.getPath();

    public OAuthIssuerValidator(Issuer issuer, Issuer existingIssuer, OAuthIssuerManager manager, ValidatorContext context) {
        boolean isCreate = !context.isUpdateRequest();
        String id = issuer.getId();
        IdValidator idValidator = new IdValidator(id, true, false, 0, 33, ID_PATH);
        idValidator.setBlankIdMessageKey(ApiMessageKey.field_blank);
        idValidator.setBlankIdMessageParams(ID_FRIENDLY_FIELD_NAME);
        this.addValidator((Validator)idValidator);
        this.addValidator((Validator)new IsNotDefaultValidator(id, ID_FRIENDLY_FIELD_NAME, ID_PATH));
        if (isCreate) {
            this.addValidator((Validator)new DuplicateValidator<String>(id, ID_PATH, ApiMessageKey.oauth_issuer_id_exists, manager.getIds()));
        }
        String name = issuer.getName();
        this.addValidator((Validator)new NotBlankValidator(name, NAME_FRIENDLY_NAME, NAME_PATH));
        Set existingNames = manager.getAll().stream().map(OAuthIssuer::getName).collect(Collectors.toSet());
        if (existingIssuer != null && issuer.getName() != null && issuer.getName().equals(existingIssuer.getName())) {
            existingNames.remove(issuer.getName());
        }
        this.addValidator((Validator)new DuplicateValidator<String>(name, NAME_PATH, ApiMessageKey.oauth_issuer_name_exists, existingNames));
        this.addValidator((Validator)new NotBlankValidator(issuer.getHost(), HOST_FRIENDLY_NAME, HOST_PATH));
        this.addValidator(new HostnameValidator.Builder(issuer.getHost(), HOST_PATH).build());
        this.addValidator(new RelativePathValidator.Builder(issuer.getPath(), PATH_FRIENDLY_NAME, PATH_PATH).setNotEndForwardSlash().setApiMessageKey(ApiMessageKey.oauth_issuer_invalid_path).validatePathCharacters().build());
        this.addValidator((Validator)new BaseUrlAndPathUniquenessValidator(issuer, existingIssuer, manager.getAll()));
    }

    static class BaseUrlAndPathUniquenessValidator
    extends AbstractValidator {
        private final Issuer issuer;
        private final Set<String> existingIssuers;

        BaseUrlAndPathUniquenessValidator(Issuer issuer, Issuer existingIssuer, Collection<OAuthIssuer> storedIssuers) {
            this.issuer = issuer;
            Set issuers = storedIssuers.stream().map(iss -> iss.getHost() + iss.getPath()).collect(Collectors.toSet());
            if (existingIssuer != null) {
                String issuerValue = this.getIssuerValue(issuer);
                String existingIssuerValue = this.getIssuerValue(existingIssuer);
                if (issuerValue != null && issuerValue.equals(existingIssuerValue)) {
                    issuers.remove(issuerValue);
                }
            }
            this.existingIssuers = issuers;
        }

        public boolean validate() {
            if (!this.existingIssuers.contains(this.getIssuerValue(this.issuer))) {
                return true;
            }
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_issuer_unique_host_and_path, null));
            return false;
        }

        private String getIssuerValue(Issuer issuer) {
            if (StringUtils.isBlank((String)issuer.getHost())) {
                return null;
            }
            if (StringUtils.isBlank((String)issuer.getPath())) {
                return issuer.getHost();
            }
            return issuer.getHost() + issuer.getPath();
        }
    }
}

