/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeGeneratorGroupPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ListNotEmptyValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.ListContainsValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class GeneratorGroupTokenTypeValidator
extends CompositeValidator {
    private static final String DEFAULT_TOKEN_TYPE_PATH = TokenExchangeGeneratorGroupPaths.getMappingsPath();
    private static final String TOKEN_TYPE_MAPPINGS_PATH = TokenExchangeGeneratorGroupPaths.getMappingsPath();
    private static final ApiMessageKey ONE_MAPPING_REQUIRED = ApiMessageKey.token_exchange_generator_group_one_mapping_required;
    private static final ApiMessageKey INVALID_DEFAULT_TOKEN_TYPE = ApiMessageKey.token_exchange_generator_group_invalid_default_token_type;
    private static final ApiMessageKey TOKEN_GENERATOR_NOT_FOUND = ApiMessageKey.token_generator_not_found;

    public GeneratorGroupTokenTypeValidator(TokenGeneratorManager tokenGeneratorManager, String defaultTokenType, List<TokenTypeTokenGeneratorPair> pairs) {
        this.addValidator((Validator)new ListNotEmptyValidator(pairs, ONE_MAPPING_REQUIRED, TOKEN_TYPE_MAPPINGS_PATH));
        if (!pairs.isEmpty()) {
            NotNullValidator defaultTokenTypeRequiredValidator = new NotNullValidator(defaultTokenType, "Default token type", DEFAULT_TOKEN_TYPE_PATH);
            defaultTokenTypeRequiredValidator.setMessageKey(ApiMessageKey.token_exchange_generator_group_token_type_mapping_default_required);
            this.addValidator((Validator)defaultTokenTypeRequiredValidator);
            List<String> tokenTypes = pairs.stream().map(TokenTypeTokenGeneratorPair::getTokenType).collect(Collectors.toList());
            if (StringUtils.isNotBlank((String)defaultTokenType)) {
                this.addValidator((Validator)new ListContainsValidator<String>(tokenTypes, defaultTokenType, INVALID_DEFAULT_TOKEN_TYPE, defaultTokenType));
            }
            this.addValidator((Validator)new TokenTypeDuplicateValidator(tokenTypes));
            this.addValidator((Validator)new TokenTypePairDuplicateValidator(pairs));
            int index = 1;
            for (TokenTypeTokenGeneratorPair pair : pairs) {
                this.addValidator((Validator)new NotNullValidator(pair.getTokenType(), "Token type", GeneratorGroupTokenTypeValidator.getTokenTypePath(index)));
                this.addValidator((Validator)new NotNullValidator(pair.getTokenGeneratorId(), "Token Generator", GeneratorGroupTokenTypeValidator.getTokenGeneratorPath(index)));
                this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)tokenGeneratorManager, pair.getTokenGeneratorId(), GeneratorGroupTokenTypeValidator.getTokenGeneratorPath(index), TOKEN_GENERATOR_NOT_FOUND, false));
                ++index;
            }
        }
    }

    private static String getPairPath(int i) {
        return TokenExchangeGeneratorGroupPaths.getMappingPath(i);
    }

    private static String getTokenGeneratorPath(int i) {
        return GeneratorGroupTokenTypeValidator.getPairPath(i) + "tokenGenerator";
    }

    private static String getTokenTypePath(int i) {
        return GeneratorGroupTokenTypeValidator.getPairPath(i) + "tokenType";
    }

    private static class TokenTypeDuplicateValidator
    extends AbstractValidator {
        private static final ApiMessageKey DUPLICATE_MESSAGE_KEY = ApiMessageKey.token_exchange_generator_group_token_type_duplicate;
        private final List<String> pairs;
        private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

        private TokenTypeDuplicateValidator(List<String> pairs) {
            this.pairs = pairs;
        }

        public boolean validate() {
            ArrayList<String> visitedPairs = new ArrayList<String>(this.pairs.size());
            int index = 0;
            for (String type : this.pairs) {
                String path = GeneratorGroupTokenTypeValidator.getPairPath(index++);
                if (visitedPairs.contains(type)) {
                    this.appendError(this.errorFactory.create(DUPLICATE_MESSAGE_KEY, path));
                }
                visitedPairs.add(type);
            }
            return !this.hasErrors();
        }
    }

    private static class TokenTypePairDuplicateValidator
    extends AbstractValidator {
        private static final ApiMessageKey DUPLICATE_MESSAGE_KEY = ApiMessageKey.token_exchange_generator_group_token_type_pair_duplicate;
        private final List<TokenTypeTokenGeneratorPair> pairs;
        private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

        private TokenTypePairDuplicateValidator(List<TokenTypeTokenGeneratorPair> pairs) {
            this.pairs = pairs;
        }

        public boolean validate() {
            ArrayList<TokenTypeTokenGeneratorPair> visitedPairs = new ArrayList<TokenTypeTokenGeneratorPair>(this.pairs.size());
            int index = 0;
            for (TokenTypeTokenGeneratorPair pair : this.pairs) {
                String path = GeneratorGroupTokenTypeValidator.getPairPath(index++);
                if (visitedPairs.contains(pair)) {
                    this.appendError(this.errorFactory.create(DUPLICATE_MESSAGE_KEY, path));
                }
                visitedPairs.add(pair);
            }
            return !this.hasErrors();
        }
    }

    public static class TokenTypeTokenGeneratorPair {
        private final String tokenType;
        private final String tokenGeneratorId;

        public TokenTypeTokenGeneratorPair(String tokenType, String tokenGeneratorId) {
            this.tokenType = tokenType;
            this.tokenGeneratorId = tokenGeneratorId;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getTokenGeneratorId() {
            return this.tokenGeneratorId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenTypeTokenGeneratorPair that = (TokenTypeTokenGeneratorPair)o;
            return Objects.equals(this.tokenType, that.tokenType) && Objects.equals(this.tokenGeneratorId, that.tokenGeneratorId);
        }

        public int hashCode() {
            return Objects.hash(this.tokenType, this.tokenGeneratorId);
        }
    }
}

