/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeProcessorPolicyPaths;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorAttribute;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorMapping;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorPolicy;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TokenSourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorAttributeContract;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class ProcessorMappingTokenTypeValidator
extends BaseAttributeDataSourceValidator {
    private static final ApiMessageKey TOKEN_PROCESSOR_NOT_FOUND = ApiMessageKey.token_processor_not_found;
    private static final String SUBJECT_TOKEN_TYPE_NAME = "Subject Token Type";
    private static final String SUBJECT_TOKEN_PROCESSOR_NAME = "Subject Token Processor";
    private static final String ACTOR_TOKEN_TYPE_NAME = "Actor Token Type";
    private static final String ACTOR_TOKEN_PROCESSOR_NAME = "Actor Token Processor";

    public ProcessorMappingTokenTypeValidator(ValidatorContext context, TokenProcessorManager tokenProcessorManager, TokenExchangeProcessorMapping mapping, TokenExchangeProcessorPolicy policy, int index) {
        super(context);
        this.addValidator((Validator)new NotBlankValidator(mapping.getSubjectTokenType(), SUBJECT_TOKEN_TYPE_NAME, TokenExchangeProcessorPolicyPaths.getSubjectTokenType(index)));
        String subjectTokenProcessorPath = TokenExchangeProcessorPolicyPaths.getSubjectTokenProcessor(index);
        if (mapping.getSubjectTokenProcessor() != null) {
            this.addValidator((Validator)new NotBlankValidator(mapping.getSubjectTokenProcessor().getId(), SUBJECT_TOKEN_PROCESSOR_NAME, subjectTokenProcessorPath));
            String subjectTokenProcessorId = mapping.getSubjectTokenProcessor().getId();
            if (StringUtils.isNotBlank((String)subjectTokenProcessorId)) {
                PluginExistsValidator pluginExistsValidator = new PluginExistsValidator((PluginManager<?, ?>)tokenProcessorManager, subjectTokenProcessorId, subjectTokenProcessorPath, TOKEN_PROCESSOR_NOT_FOUND, true);
                this.addValidator((Validator)pluginExistsValidator);
            }
        } else {
            this.addValidator((Validator)new NotNullValidator(mapping.getSubjectTokenProcessor(), SUBJECT_TOKEN_PROCESSOR_NAME, subjectTokenProcessorPath));
        }
        if (this.validateActorToken(mapping, policy)) {
            this.addValidator((Validator)new NotBlankValidator(mapping.getActorTokenType(), ACTOR_TOKEN_TYPE_NAME, TokenExchangeProcessorPolicyPaths.getActorTokenType(index)));
            String actorTokenProcessorPath = TokenExchangeProcessorPolicyPaths.getActorTokenProcessor(index);
            if (mapping.getActorTokenProcessor() != null) {
                String actorTokenProcessorId = mapping.getActorTokenProcessor().getId();
                this.addValidator((Validator)new NotBlankValidator(actorTokenProcessorId, ACTOR_TOKEN_PROCESSOR_NAME, actorTokenProcessorPath));
                if (StringUtils.isNotBlank((String)actorTokenProcessorId)) {
                    PluginExistsValidator pluginExistsValidator = new PluginExistsValidator((PluginManager<?, ?>)tokenProcessorManager, actorTokenProcessorId, actorTokenProcessorPath, TOKEN_PROCESSOR_NOT_FOUND, true);
                    this.addValidator((Validator)pluginExistsValidator);
                }
            } else {
                this.addValidator((Validator)new NotNullValidator(mapping.getActorTokenProcessor(), ACTOR_TOKEN_PROCESSOR_NAME, actorTokenProcessorPath));
            }
        }
        Set<String> allAttributeNames = this.getAllAttributeNames(policy);
        String token_processor = "Token Processor";
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        this.addTokenSources(validSources, mapping, tokenProcessorManager);
        this.mapDataStoreTypesToDsValidators(mapping, validSources);
        Set<String> coreSourceSubstitutionVars = this.coreSourceSubstitutionVars(mapping, tokenProcessorManager);
        this.addValidator((Validator)new AttributeMappingValidator(mapping, allAttributeNames, coreSourceSubstitutionVars, token_processor, validSources, TokenExchangeProcessorPolicyPaths.getProcessMappingBase(index), this.getContext()));
    }

    private Set<String> coreSourceSubstitutionVars(TokenExchangeProcessorMapping mapping, TokenProcessorManager tokenProcessorManager) {
        String actorTokenProcessorId;
        TokenProcessorInstance actorInstance;
        TokenSourceTypeValidatorBuilder builder;
        String subjectTokenProcessorId;
        TokenProcessorInstance subjectInstance;
        HashSet<String> result = new HashSet<String>();
        if (mapping.getSubjectTokenProcessor() != null && (subjectInstance = (TokenProcessorInstance)tokenProcessorManager.getInstance(subjectTokenProcessorId = mapping.getSubjectTokenProcessor().getId())) != null && subjectInstance.getAttributeContract() != null) {
            Set subjectTokenSrcNames = subjectInstance.getAttributeContract().getAllAttributeNames();
            builder = new TokenSourceTypeValidatorBuilder(subjectTokenSrcNames, "subjecttoken.").setExpectedSourceType(SourceType.SUBJECT_TOKEN);
            result.addAll(builder.getExposedSubstitutionVariables());
        }
        if (mapping.getActorTokenProcessor() != null && StringUtils.isNotBlank((String)mapping.getActorTokenType()) && (actorInstance = (TokenProcessorInstance)tokenProcessorManager.getInstance(actorTokenProcessorId = mapping.getActorTokenProcessor().getId())) != null && actorInstance.getAttributeContract() != null) {
            Set actorTokenSrcNames = actorInstance.getAttributeContract().getAllAttributeNames();
            builder = new TokenSourceTypeValidatorBuilder(actorTokenSrcNames, "actortoken.").setExpectedSourceType(SourceType.ACTOR_TOKEN);
            result.addAll(builder.getExposedSubstitutionVariables());
        }
        return result;
    }

    private boolean validateActorToken(TokenExchangeProcessorMapping mapping, TokenExchangeProcessorPolicy policy) {
        return policy.isActorTokenRequired() || StringUtils.isNotBlank((String)mapping.getActorTokenType()) || mapping.getActorTokenProcessor() != null && StringUtils.isNotBlank((String)mapping.getActorTokenProcessor().getId());
    }

    private void addTokenSources(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources, TokenExchangeProcessorMapping mapping, TokenProcessorManager tokenProcessorManager) {
        String actorTokenProcessorId;
        TokenProcessorInstance actorInstance;
        String subjectTokenProcessorId;
        TokenProcessorInstance subjectInstance;
        if (mapping.getSubjectTokenProcessor() != null && (subjectInstance = (TokenProcessorInstance)tokenProcessorManager.getInstance(subjectTokenProcessorId = mapping.getSubjectTokenProcessor().getId())) != null && subjectInstance.getAttributeContract() != null) {
            Set subjectTokenSrcNames = subjectInstance.getAttributeContract().getAllAttributeNames();
            validSources.put(new SourceTypeIdKey(SourceType.SUBJECT_TOKEN), new TokenSourceTypeValidatorBuilder(subjectTokenSrcNames, "subjecttoken.").setExpectedSourceType(SourceType.SUBJECT_TOKEN));
        }
        if (mapping.getActorTokenProcessor() != null && StringUtils.isNotBlank((String)mapping.getActorTokenType()) && (actorInstance = (TokenProcessorInstance)tokenProcessorManager.getInstance(actorTokenProcessorId = mapping.getActorTokenProcessor().getId())) != null && actorInstance.getAttributeContract() != null) {
            Set actorTokenSrcNames = actorInstance.getAttributeContract().getAllAttributeNames();
            validSources.put(new SourceTypeIdKey(SourceType.ACTOR_TOKEN), new TokenSourceTypeValidatorBuilder(actorTokenSrcNames, "actortoken.").setExpectedSourceType(SourceType.ACTOR_TOKEN));
        }
    }

    private SourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private SourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForTokenExchangeProcessorPolicyMappings());
        return builder;
    }

    private Set<String> getAllAttributeNames(TokenExchangeProcessorPolicy policy) {
        return Stream.concat(new TokenExchangeProcessorAttributeContract().getImmutableAttributeNames().stream().map(name -> {
            TokenExchangeProcessorAttribute coreAttribute = new TokenExchangeProcessorAttribute();
            coreAttribute.setName((String)name);
            return coreAttribute;
        }).collect(Collectors.toList()).stream(), policy.getAttributeContract().getExtendedAttributes().stream()).map(Attribute::getName).collect(Collectors.toSet());
    }
}

