/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeProcessorPolicyPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.simple.DuplicateValidator;
import com.pingidentity.admin.api.validator.simple.IsNotDefaultValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ProcessorPolicyBasicsValidator
extends CompositeValidator {
    private static final String NAME_PATH = TokenExchangeProcessorPolicyPaths.getName();
    private static final String ID_PATH = TokenExchangeProcessorPolicyPaths.getId();
    private static final String ID_FRIENDLY_FIELD_NAME = "ID";
    private static final String NAME_FRIENDLY_NAME = "Name";

    public ProcessorPolicyBasicsValidator(String id, String name, boolean isCreate, Set<String> existingIds, Set<String> existingNames, String currentName) {
        this.addValidator((Validator)new NotNullValidator(id, ID_FRIENDLY_FIELD_NAME, ID_PATH));
        IdValidator idValidator = new IdValidator(id, true, false, 0, 33, ID_PATH);
        idValidator.setBlankIdMessageKey(ApiMessageKey.field_blank);
        idValidator.setBlankIdMessageParams(ID_FRIENDLY_FIELD_NAME);
        this.addValidator((Validator)idValidator);
        this.addValidator((Validator)new IsNotDefaultValidator(id, ID_FRIENDLY_FIELD_NAME, ID_PATH));
        this.addValidator((Validator)new NotBlankValidator(name, NAME_FRIENDLY_NAME, NAME_PATH));
        this.addValidator((Validator)new IsNotDefaultValidator(name, NAME_FRIENDLY_NAME, NAME_PATH));
        if (isCreate) {
            this.addValidator((Validator)new DuplicateValidator<String>(id, ID_PATH, ApiMessageKey.token_exchange_processor_policy_id_exists, existingIds));
            this.addValidator((Validator)new DuplicateValidator<String>(name, NAME_PATH, ApiMessageKey.token_exchange_processor_policy_name_exists, existingNames));
        } else if (!StringUtils.equals((String)name, (String)currentName)) {
            existingNames.remove(currentName);
            this.addValidator((Validator)new DuplicateValidator<String>(name, NAME_PATH, ApiMessageKey.token_exchange_processor_policy_name_exists, existingNames));
        }
    }
}

