/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AuthenticationSourceMappingsValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorPolicySourceTypeValidatorBuilder;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.SourceContextType;

public class ProcessorPolicyToGeneratorAttributeMappingValidator
extends BaseAttributeDataSourceValidator {
    private final AttributeMapping mappingToValidate;
    private final AttributeContract sourceAttributeContract;
    private final AttributeContract targetAttributeContract;
    private final String attributeMappingBasePath;

    public ProcessorPolicyToGeneratorAttributeMappingValidator(AttributeMapping mappingToValidate, AttributeContract sourceAttributeContract, AttributeContract targetAttributeContract, String attributeMappingBasePath, ValidatorContext context) {
        super(context);
        this.mappingToValidate = mappingToValidate;
        this.sourceAttributeContract = sourceAttributeContract;
        this.targetAttributeContract = targetAttributeContract;
        this.attributeMappingBasePath = attributeMappingBasePath;
    }

    @Override
    public boolean validate() {
        Set validAttributeNames = this.targetAttributeContract.getAllAttributeNames();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        this.checkAttributeSourcesForBlankValues();
        ProcessorPolicySourceTypeValidatorBuilder sourceTypeValidatorBuilder = new ProcessorPolicySourceTypeValidatorBuilder(this.sourceAttributeContract.getAllAttributeNames());
        validSources.put(new SourceTypeIdKey(SourceType.TOKEN_EXCHANGE_PROCESSOR_POLICY), sourceTypeValidatorBuilder);
        validSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.TEXT), AuthenticationSourceMappingsValidator.createTextValBuilder());
        this.mapDataStoreTypesToDsValidators(this.mappingToValidate, validSources);
        validSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        ContextSourceTypeValidatorBuilder cstb = new ContextSourceTypeValidatorBuilder();
        cstb.setContextSources(SourceContextType.getContextTypesForTokenExchangeProcessorPolicyMappings());
        validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), cstb);
        AttributeMappingValidator validator = new AttributeMappingValidator(this.mappingToValidate, validAttributeNames, this.getSourceCoreSubstitutionVariables(), null, validSources, this.attributeMappingBasePath, this.getContext()){

            @Override
            public boolean doValidateAttrSourceId(AttributeMapping apiMapping) {
                return false;
            }
        };
        if (!validator.validate()) {
            super.getErrors().addAll(validator.getErrors());
        }
        return !this.hasErrors();
    }

    private void checkAttributeSourcesForBlankValues() {
        int index = 0;
        for (AttributeSource attributeSource : this.mappingToValidate.getAttributeSources()) {
            NotBlankValidator descVal;
            NotBlankValidator idVal = new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", ConnectionPaths.getAttributeSourceIdPath(ConnectionPaths.getAttributeSourcePath(this.attributeMappingBasePath, index)));
            if (!idVal.validate()) {
                super.getErrors().addAll(idVal.getErrors());
            }
            if (!(descVal = new NotBlankValidator(attributeSource.getDescription(), "Attribute Source Description", ConnectionPaths.getAttributeSourceDescriptionPath(ConnectionPaths.getAttributeSourcePath(this.attributeMappingBasePath, index)))).validate()) {
                super.getErrors().addAll(descVal.getErrors());
            }
            ++index;
        }
    }

    private Set<String> getSourceCoreSubstitutionVariables() {
        return new HashSet<String>(this.sourceAttributeContract.getAllAttrNamesSorted());
    }
}

