/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.GenericMappingsPaths;
import com.pingidentity.admin.api.model.oauth.exchange.ProcessorPolicyToGeneratorMapping;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.oauth.exchange.ProcessorPolicyToGeneratorAttributeMappingValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.ProcessorPolicy2TokenGeneratorManager;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;

public class ProcessorPolicyToGeneratorMappingValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final ProcessorPolicyToGeneratorMapping mappingToValidate;
    private final boolean isUpdate;
    private final ProcessorPolicy2TokenGeneratorManager processorPolicy2TokenGeneratorMgr;
    private final TokenExchangeProcessorPolicyManager processorPolicyMgr;
    private final TokenGeneratorManager tokenGeneratorMgr;
    private final ValidatorContext context;

    public ProcessorPolicyToGeneratorMappingValidator(ProcessorPolicyToGeneratorMapping mappingToValidate, ProcessorPolicy2TokenGeneratorManager processorPolicy2TokenGeneratorMgr, TokenExchangeProcessorPolicyManager processorPolicyMgr, TokenGeneratorManager tokenGeneratorMgr, ValidatorContext context) {
        this.mappingToValidate = mappingToValidate;
        this.isUpdate = context.isUpdateRequest();
        this.processorPolicy2TokenGeneratorMgr = processorPolicy2TokenGeneratorMgr;
        this.processorPolicyMgr = processorPolicyMgr;
        this.tokenGeneratorMgr = tokenGeneratorMgr;
        this.context = context;
    }

    public boolean validate() {
        ConfigurablePluginInstance tokenGenerator;
        this.checkForRequiredFields();
        if (this.hasErrors()) {
            return false;
        }
        TokenExchangeProcessorPolicy policy = this.processorPolicyMgr.getTokenExchangeProcessorPolicies().getPolicy(this.mappingToValidate.getSourceId());
        if (policy == null || !policy.getId().equals(this.mappingToValidate.getSourceId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_exchange_processor_policy_to_token_generator_mappings_source_doesnt_exist, GenericMappingsPaths.getSourceId(), new Object[]{this.mappingToValidate.getSourceId()}));
        }
        if ((tokenGenerator = this.tokenGeneratorMgr.getInstance(this.mappingToValidate.getTargetId())) == null || !tokenGenerator.getId().equals(this.mappingToValidate.getTargetId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_exchange_processor_policy_to_token_generator_mappings_target_doesnt_exist, GenericMappingsPaths.getTargetId(), new Object[]{this.mappingToValidate.getTargetId()}));
        }
        if (this.hasErrors()) {
            return !this.hasErrors();
        }
        this.checkForDuplicateMapping();
        ProcessorPolicyToGeneratorAttributeMappingValidator attributeMappingValidator = new ProcessorPolicyToGeneratorAttributeMappingValidator(this.mappingToValidate, (AttributeContract)policy.getContract(), tokenGenerator.getAttributeContract(), "", this.context);
        if (!attributeMappingValidator.validate()) {
            super.getErrors().addAll(attributeMappingValidator.getErrors());
        }
        return !this.hasErrors();
    }

    void checkForRequiredFields() {
        if (this.mappingToValidate.getSourceId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, GenericMappingsPaths.getSourceId(), new Object[]{"Token Exchange Processor policy ID"}));
        }
        if (this.mappingToValidate.getTargetId() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, GenericMappingsPaths.getTargetId(), new Object[]{"Token Generator ID"}));
        }
    }

    void checkForDuplicateMapping() {
        if (!this.isUpdate && this.processorPolicy2TokenGeneratorMgr.getMapping(this.mappingToValidate.getSourceId(), this.mappingToValidate.getTargetId()) != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.token_exchange_processor_policy_to_token_generator_mappings_duplicate_mappings, GenericMappingsPaths.getId(), new Object[]{this.mappingToValidate.getSourceId(), this.mappingToValidate.getTargetId()}));
        }
    }
}

