/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.exchange.TokenExchangeProcessorSettingsPath;
import com.pingidentity.admin.api.model.oauth.exchange.TokenExchangeProcessorSettings;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.domain.WithDefaultInstanceSupport;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;

public class ProcessorSettingsValidator
extends CompositeValidator {
    private static final String DEFAULT_PROCESSOR_POLICY_REF_PATH = TokenExchangeProcessorSettingsPath.getDefaultProcessorPolicyRef();

    public ProcessorSettingsValidator(TokenExchangeProcessorPolicies domain, TokenExchangeProcessorSettings settings) {
        if (domain.getPolicies() != null && !domain.getPolicies().isEmpty()) {
            if (settings == null) {
                this.addValidator((Validator)new NotNullValidator(null, "Settings", null));
            } else {
                ResourceLink defaultProcessorPolicyRef = settings.getDefaultProcessorPolicyRef();
                if (defaultProcessorPolicyRef != null) {
                    this.addValidator((Validator)new ResourceIdValidator(defaultProcessorPolicyRef, "Default policy reference", DEFAULT_PROCESSOR_POLICY_REF_PATH));
                    this.addValidator((Validator)new ResourceLinkIntegrityValidator<TokenExchangeProcessorPolicies>(defaultProcessorPolicyRef, domain, "default instance", DEFAULT_PROCESSOR_POLICY_REF_PATH));
                } else {
                    this.addValidator((Validator)new NotNullValidator(null, "Default policy reference", DEFAULT_PROCESSOR_POLICY_REF_PATH));
                }
            }
        }
    }

    static class ResourceLinkIntegrityValidator<T extends WithDefaultInstanceSupport<String>>
    extends AbstractValidator {
        private final ResourceLink resourceLink;
        private final T t;
        private final String friendlyName;
        private final String fieldPath;
        private ApiMessageKey invalidIdKey = ApiMessageKey.resource_link_integrity_invalid_id;

        ResourceLinkIntegrityValidator(ResourceLink resourceLink, T t, String friendlyName, String fieldPath) {
            this.resourceLink = resourceLink;
            this.t = t;
            this.friendlyName = friendlyName;
            this.fieldPath = fieldPath;
        }

        public boolean validate() {
            ValidationErrorFactory validationErrorFactory = ValidationErrorFactory.getInstance();
            if (this.resourceLink != null) {
                if (!this.t.containsInstance((Object)this.resourceLink.getId())) {
                    this.appendError(validationErrorFactory.create(this.invalidIdKey, this.fieldPath, new Object[]{this.resourceLink.getId()}));
                    return false;
                }
            } else if (this.t.containsConfigureInstances()) {
                this.appendError(validationErrorFactory.create(ApiMessageKey.field_required, this.fieldPath, new Object[]{this.friendlyName}));
                return false;
            }
            return true;
        }
    }
}

