/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.oauth.exchange;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.simple.ListNotContainValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class UiProcessorMappingTokenTypeValidator
extends CompositeValidator {
    private static final String MAPPING_PATH = "";
    private static final String SUBJECT_TOKEN_TYPE_PATH = "";
    private static final String ACTOR_TOKEN_TYPE_PATH = "";
    private static final String SUBJECT_TOKEN_PROCESSOR_PATH = "";
    private static final String ACTOR_TOKEN_PROCESSOR_PATH = "";
    private static final ApiMessageKey TOKEN_PROCESSOR_NOT_FOUND = ApiMessageKey.token_processor_not_found;

    public UiProcessorMappingTokenTypeValidator(TokenProcessorManager tokenProcessorManager, String subjectTokenType, String subjectTokenProcessorId) {
        this.addValidator((Validator)new NotBlankValidator(subjectTokenType, "Subject Token Type", ""));
        this.addValidator((Validator)new NotBlankValidator(subjectTokenProcessorId, "Subject Token Processor", ""));
        if (StringUtils.isNotBlank((String)subjectTokenProcessorId)) {
            PluginExistsValidator pluginExistsValidator = new PluginExistsValidator((PluginManager<?, ?>)tokenProcessorManager, subjectTokenProcessorId, "", TOKEN_PROCESSOR_NOT_FOUND, true);
            this.addValidator((Validator)pluginExistsValidator);
        }
    }

    public void validateActorSettings(TokenProcessorManager tokenProcessorManager, String actorTokenType, String actorTokenProcessorId) {
        this.addValidator((Validator)new NotBlankValidator(actorTokenType, "Actor Token Type", ""));
        this.addValidator((Validator)new NotBlankValidator(actorTokenProcessorId, "Actor Token Processor", ""));
        if (StringUtils.isNotBlank((String)actorTokenProcessorId)) {
            PluginExistsValidator pluginExistsValidator = new PluginExistsValidator((PluginManager<?, ?>)tokenProcessorManager, actorTokenProcessorId, "", TOKEN_PROCESSOR_NOT_FOUND, true);
            this.addValidator((Validator)pluginExistsValidator);
        }
    }

    public void addDuplicateTokenTypeValidator(List<TokenTypePair> existing, TokenTypePair current) {
        this.addValidator((Validator)new ListNotContainValidator<TokenTypePair>(existing, current, ApiMessageKey.token_exchange_processor_mapping_exists, ""));
    }

    public static final class TokenTypePair {
        private final String subjectTokenType;
        private final String actorTokenType;

        public TokenTypePair(String subjectTokenType, String actorTokenType) {
            this.subjectTokenType = subjectTokenType;
            this.actorTokenType = actorTokenType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenTypePair that = (TokenTypePair)o;
            return Objects.equals(this.subjectTokenType, that.subjectTokenType) && Objects.equals(this.actorTokenType, that.actorTokenType);
        }

        public int hashCode() {
            return Objects.hash(this.subjectTokenType, this.actorTokenType);
        }
    }
}

