/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.simple;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class HostnameValidator
extends AbstractValidator {
    private final String fieldValue;
    private final String fieldPath;
    private final boolean required;
    private ApiMessageKey apiMessageKey;

    HostnameValidator(String fieldValue, String fieldPath, boolean required) {
        this.fieldValue = fieldValue;
        this.fieldPath = fieldPath;
        this.required = required;
    }

    void setApiMessageKey(ApiMessageKey apiMessageKey) {
        this.apiMessageKey = apiMessageKey;
    }

    public boolean validate() {
        if (!this.required && StringUtils.isBlank((String)this.fieldValue)) {
            return true;
        }
        if (ValidationUtil.isHostnameValid((String)this.fieldValue)) {
            return true;
        }
        this.appendError(ValidationErrorFactory.getInstance().create(this.apiMessageKey, this.fieldPath, new Object[]{this.fieldValue}));
        return false;
    }

    public static class Builder {
        private final String fieldValue;
        private final String fieldPath;
        private boolean required;
        private ApiMessageKey apiMessageKey = ApiMessageKey.hostname_format_invalid;

        public Builder(String fieldValue, String fieldPath) {
            this.fieldValue = fieldValue;
            this.fieldPath = fieldPath;
        }

        public Builder setRequired() {
            this.required = true;
            return this;
        }

        public Builder setApiMessageKey(ApiMessageKey apiMessageKey) {
            this.apiMessageKey = apiMessageKey;
            return this;
        }

        public Validator build() {
            HostnameValidator validator = new HostnameValidator(this.fieldValue, this.fieldPath, this.required);
            validator.setApiMessageKey(this.apiMessageKey);
            return validator;
        }
    }
}

