/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.simple;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pingcommons.http.uri.HttpUri;
import com.pingidentity.pingcommons.http.uri.HttpUriFactory;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public final class RelativePathValidator
extends AbstractValidator {
    private static final HttpUriFactory HTTP_URI_FACTORY = HttpUriFactory.createLocationUriFactory((HttpUriFactory.Params)HttpUriFactory.DEFUALT_PARAMS);
    private final String value;
    private final String friendlyName;
    private final String fieldPath;
    private final boolean required;
    private ApiMessageKey apiMessageKey;
    private boolean notEndForwardSlash = false;
    private boolean validatePathCharacters = false;

    public RelativePathValidator(String value, String friendlyName, String fieldPath, boolean required) {
        this.value = value;
        this.friendlyName = friendlyName;
        this.fieldPath = fieldPath;
        this.required = required;
    }

    public void setApiMessageKey(ApiMessageKey apiMessageKey) {
        this.apiMessageKey = apiMessageKey;
    }

    public void setNotEndForwardSlash(boolean notEndForwardSlash) {
        this.notEndForwardSlash = notEndForwardSlash;
    }

    public void setValidatePathCharacters(boolean validatePathCharacters) {
        this.validatePathCharacters = validatePathCharacters;
    }

    public boolean validate() {
        ApiMessageKey errorMessageKey;
        NotBlankValidator notBlankValidator = new NotBlankValidator(this.value, this.friendlyName, this.fieldPath);
        if (this.required && !notBlankValidator.validate()) {
            this.appendErrors(notBlankValidator.getErrors());
            return false;
        }
        ApiMessageKey apiMessageKey = errorMessageKey = this.apiMessageKey != null ? this.apiMessageKey : ApiMessageKey.malformed_relative_path;
        if (StringUtils.isNotBlank((String)this.value) && !ValidationUtil.startsWithForwardSlash((String)this.value)) {
            this.doAppendError(errorMessageKey);
        }
        if (!this.hasErrors() && this.notEndForwardSlash && StringUtils.isNotBlank((String)this.value) && ValidationUtil.endsWithForwardSlash((String)this.value)) {
            this.doAppendError(errorMessageKey);
        }
        if (!this.hasErrors() && this.validatePathCharacters && StringUtils.isNotBlank((String)this.value)) {
            try {
                HttpUri httpUri = HTTP_URI_FACTORY.create(this.value);
                if (!this.value.equals(httpUri.getPath())) {
                    this.doAppendError(errorMessageKey);
                }
            }
            catch (InvalidHttpUriException e) {
                this.doAppendError(errorMessageKey);
            }
        }
        return !this.hasErrors();
    }

    private void doAppendError(ApiMessageKey errorMessageKey) {
        this.appendError(ValidationErrorFactory.getInstance().create(errorMessageKey, this.fieldPath, new Object[]{this.friendlyName}));
    }

    public static class Builder {
        private final String value;
        private final String friendlyName;
        private final String fieldPath;
        private boolean required;
        private ApiMessageKey apiMessageKey;
        private boolean notEndForwardSlash = false;
        private boolean validatePathCharacters = false;

        public Builder(String value, String friendlyName, String fieldPath) {
            this.value = value;
            this.friendlyName = friendlyName;
            this.fieldPath = fieldPath;
        }

        public Builder setApiMessageKey(ApiMessageKey apiMessageKey) {
            this.apiMessageKey = apiMessageKey;
            return this;
        }

        public Builder setNotEndForwardSlash() {
            this.notEndForwardSlash = true;
            return this;
        }

        public Builder isRequired() {
            this.required = true;
            return this;
        }

        public Builder validatePathCharacters() {
            this.validatePathCharacters = true;
            return this;
        }

        public Validator build() {
            RelativePathValidator validator = new RelativePathValidator(this.value, this.friendlyName, this.fieldPath, this.required);
            validator.setNotEndForwardSlash(this.notEndForwardSlash);
            if (this.apiMessageKey != null) {
                validator.setApiMessageKey(this.apiMessageKey);
            }
            validator.setValidatePathCharacters(this.validatePathCharacters);
            return validator;
        }
    }
}

