/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.simple;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationErrorFactory;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public final class X509CountryValidator
extends AbstractValidator {
    private final ValidationErrorFactory validationErrorFactory;
    private final String fieldValue;
    private final String friendlyFieldName;
    private final String fieldPath;
    private final boolean required;

    public X509CountryValidator(ValidationErrorFactory validationErrorFactory, String fieldValue, String friendlyFieldName, String fieldPath, boolean required) {
        this.validationErrorFactory = validationErrorFactory;
        this.fieldValue = fieldValue;
        this.friendlyFieldName = friendlyFieldName;
        this.fieldPath = fieldPath;
        this.required = required;
    }

    public boolean validate() {
        if (this.required && StringUtils.isBlank((String)this.fieldValue)) {
            this.appendError(this.validationErrorFactory.create((ApiMessageEnum)ApiMessageKey.field_required, this.fieldPath, new Object[]{this.friendlyFieldName}));
            return false;
        }
        if (!this.required && StringUtils.isBlank((String)this.fieldValue)) {
            return !this.hasErrors();
        }
        if (!ValidationUtil.isValidX509CountryEntry((String)this.fieldValue)) {
            this.appendError(this.validationErrorFactory.create((ApiMessageEnum)ApiMessageKey.new_key_pair_invalid_country, this.fieldPath, new Object[]{this.fieldValue}));
            return false;
        }
        return !this.hasErrors();
    }
}

