/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator.structures;

import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.validator.structures.UpstreamSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UpstreamSources {
    private final List<UpstreamSource> sourceList;

    public UpstreamSources() {
        this.sourceList = new ArrayList<UpstreamSource>();
    }

    public UpstreamSources(UpstreamSources sources) {
        this.sourceList = new ArrayList<UpstreamSource>(sources.sourceList);
    }

    public void addSource(AuthenticationSource source) {
        UpstreamSource upstreamSource = new UpstreamSource(source.getType().toUpstreamType(), source.getSourceRef().getId());
        this.sourceList.add(upstreamSource);
    }

    public void addSource(UpstreamSource source) {
        this.sourceList.add(source);
    }

    public void addSource(String fragmentId) {
        this.sourceList.add(new UpstreamSource(UpstreamSource.UpstreamSourceType.FRAGMENT, fragmentId));
    }

    public boolean isEmpty() {
        return this.sourceList.isEmpty();
    }

    public List<UpstreamSource> getSources() {
        return Collections.unmodifiableList(this.sourceList);
    }
}

