/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.filter;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ApiResultFactory;
import com.pingidentity.pf.admin.rest.filter.JwtAdminAuthHandler;
import com.pingidentity.pf.admin.rest.filter.OAuth2AdminAuthHandler;
import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.audit.ApiAuditLogger;
import com.pingidentity.pf.common.api.authn.ApiAuthenticationType;
import com.pingidentity.pf.common.api.model.ApiResult;
import com.pingidentity.pf.common.api.util.CorsUtils;
import com.pingidentity.session.AdminConsoleApiAccessToken;
import com.pingidentity.session.ApiAccessTokenException;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.auth.AuthorizationHeaderSupport;
import org.sourceid.auth.BasicAuthHelp;
import org.sourceid.auth.BasicAuthValue;
import org.sourceid.auth.BearerAuthHelp;
import org.sourceid.oauth20.token.AdminConsoleTokenManager;
import org.sourceid.oauth20.wwwauth.AccessTokenUtil;
import org.sourceid.saml20.domain.mgmt.AdminAPIAuthManager;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdminUserException;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.OAuth2AdministrativeUser;
import org.sourceid.util.initial.setup.InitialSetupUtil;

public class BasicAuthFilter
implements ContainerRequestFilter {
    private static final Log log = LogFactory.getLog(BasicAuthFilter.class);
    private final ApiAuditLogger auditLogger = ApiAuditLogger.getInstance((String)"AdminApiAuditLogger");
    private final AdminAPIAuthManager adminAPIAuthManager;
    private final AdminUserManager adminApiUserManager;
    private final InitialSetupUtil initialSetupUtil;
    private final AdminConsoleTokenManager adminConsoleTokenManager;
    @Context
    private HttpServletRequest servletRequest;

    public BasicAuthFilter() {
        this(AdminAPIAuthManager.getInstance(), MgmtFactory.getAdminApiUserManager(), new InitialSetupUtil(), MgmtFactory.getAdminConsoleTokenManager());
    }

    public BasicAuthFilter(AdminAPIAuthManager adminAPIAuthManager, AdminUserManager adminApiUserManager, InitialSetupUtil initialSetupUtil, AdminConsoleTokenManager adminConsoleTokenManager) {
        this.adminAPIAuthManager = adminAPIAuthManager;
        this.adminApiUserManager = adminApiUserManager;
        this.initialSetupUtil = initialSetupUtil;
        this.adminConsoleTokenManager = adminConsoleTokenManager;
    }

    public ContainerRequest filter(ContainerRequest containerRequest) {
        if (ApiUtil.isApiDocsRequest(this.servletRequest)) {
            return containerRequest;
        }
        if (!this.initialSetupUtil.isAuthRequired(containerRequest.getPath(), containerRequest.getMethod())) {
            containerRequest.getProperties().put("com.pingidentity.pf.admin.rest.initial_setup", true);
            return containerRequest;
        }
        if (!AuthorizationHeaderSupport.isAuthorizationHeaderValid((HttpServletRequest)this.servletRequest)) {
            log.debug((Object)this.createFailedLogMessage("Multiple authorization headers detected"));
            CommonApiMsgKey authRequiredMsgKey = CommonApiMsgKey.invalid_auth_header;
            ApiResult result = ApiResultFactory.create((CommonApiMsgKey)authRequiredMsgKey);
            throw new WebApplicationException(this.makeChallengeResponse(result));
        }
        if (CorsUtils.isSuccessfulOptionsCorsRequest((String)this.servletRequest.getMethod(), (HttpServletRequest)this.servletRequest)) {
            return containerRequest;
        }
        if (AuthorizationHeaderSupport.isSchemeUsed((HttpServletRequest)this.servletRequest, (String)"Bearer")) {
            this.doAccessTokenValidation();
            return containerRequest;
        }
        if (this.adminAPIAuthManager.isCert()) {
            this.doCertAuth();
            return containerRequest;
        }
        this.doHttpRequestAuthn();
        return containerRequest;
    }

    private void doCertAuth() {
        try {
            AdministrativeUser user = this.adminApiUserManager.authenticate(this.servletRequest);
            this.auditLogger.setAuthenticationType(ApiAuthenticationType.CLIENT_CERT);
            this.auditLogger.setUsername(user.getUserName());
            this.servletRequest.setAttribute("com.pingidentity.pf.admin.rest.user", (Object)user);
        }
        catch (AdminUserException e) {
            log.debug((Object)this.createFailedLogMessage("Authentication failed with code " + e.getCode().name()));
            CommonApiMsgKey key = null;
            switch (e.getCode()) {
                case CERT_INVALID: {
                    key = CommonApiMsgKey.cert_invalid;
                    break;
                }
                case CERT_NOT_FOUND: {
                    key = CommonApiMsgKey.cert_not_found;
                    break;
                }
                case CERT_NOT_TRUSTED: {
                    key = CommonApiMsgKey.cert_not_trusted;
                    break;
                }
                default: {
                    key = CommonApiMsgKey.cert_invalid;
                }
            }
            ApiResult result = ApiResultFactory.create((CommonApiMsgKey)key);
            throw new WebApplicationException(this.makeChallengeResponse(result));
        }
    }

    public void doHttpRequestAuthn() {
        String authnHeaderValue = BasicAuthHelp.getAuthTokenFromHeaders((HttpServletRequest)this.servletRequest);
        this.validateAuthorizationHeader(authnHeaderValue);
        this.auditLogger.setAuthenticationType(ApiAuthenticationType.HTTP_BASIC);
        try {
            BasicAuthValue authValues = BasicAuthHelp.getValues((String)authnHeaderValue, (boolean)true);
            this.auditLogger.setUsername(authValues.getUsername());
            AdministrativeUser user = this.adminAPIAuthManager.initBasicAuthUserManager().authenticate(authValues.getUsername(), authValues.getPassword(), this.servletRequest);
            this.servletRequest.setAttribute("com.pingidentity.pf.admin.rest.user", (Object)user);
        }
        catch (LoginException e) {
            log.debug((Object)this.createFailedLogMessage(e.getMessage()));
            ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.invalid_credentials);
            throw new WebApplicationException(this.makeChallengeResponse(result));
        }
        catch (AdminUserException e) {
            log.debug((Object)this.createFailedLogMessage("Authentication failed with code " + e.getCode().name()));
            ApiResult result = e.getCode() == AdminUserException.Code.LOCKED ? ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.account_locked) : ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.invalid_credentials);
            throw new WebApplicationException(this.makeChallengeResponse(result));
        }
    }

    private void doAccessTokenValidation() {
        try {
            this.auditLogger.setAuthenticationType(ApiAuthenticationType.BEARER);
            String bearerToken = BearerAuthHelp.getAuthTokenFromHeaders((HttpServletRequest)this.servletRequest);
            this.validateAuthorizationHeader(bearerToken);
            AdminConsoleApiAccessToken accessToken = this.adminConsoleTokenManager.validateAccessToken(bearerToken);
            if (accessToken == null || accessToken.getAdminUser() == null) {
                this.auditLogger.setAccessTokenHash(bearerToken);
                OAuth2AdministrativeUser user = this.getOAuth2AdministrativeUser(bearerToken);
                if (user != null) {
                    this.servletRequest.setAttribute("com.pingidentity.pf.admin.rest.user", (Object)user);
                    this.auditLogger.setUsername(user.getUserName());
                    this.auditLogger.setPartnerId(user.getClientId());
                }
                if (user == null) {
                    throw new ApiAccessTokenException("Invalid or expired token.");
                }
            } else {
                this.auditLogger.setUsername(accessToken.getAdminUser().getUserName());
                this.servletRequest.setAttribute("com.pingidentity.pf.admin.rest.user", (Object)accessToken.getAdminUser());
                this.servletRequest.setAttribute("com.pingidentity.pf.admin.rest.accesstoken", (Object)accessToken);
            }
        }
        catch (ApiAccessTokenException e) {
            throw new WebApplicationException(this.makeBearerResponse());
        }
    }

    private OAuth2AdministrativeUser getOAuth2AdministrativeUser(String bearerToken) throws ApiAccessTokenException {
        OAuth2AdministrativeUser user = null;
        if (this.adminAPIAuthManager.isOAuth2()) {
            OAuth2AdminAuthHandler oauthAdminAuthHandler = OAuth2AdminAuthHandler.getInstance();
            user = oauthAdminAuthHandler.validateOAuthAccessToken(bearerToken);
        } else if (this.adminAPIAuthManager.isLocalJwt()) {
            JwtAdminAuthHandler handler = JwtAdminAuthHandler.getInstance();
            user = handler.validateJwt(bearerToken);
        }
        return user;
    }

    private void validateAuthorizationHeader(String token) {
        if (token == null) {
            log.debug((Object)this.createFailedLogMessage("Missing authorization header"));
            CommonApiMsgKey authRequiredMsgKey = CommonApiMsgKey.basic_auth_required;
            if (this.adminAPIAuthManager.isOAuth2()) {
                authRequiredMsgKey = CommonApiMsgKey.bearer_or_basic_auth_required;
            }
            ApiResult result = ApiResultFactory.create((CommonApiMsgKey)authRequiredMsgKey);
            throw new WebApplicationException(this.makeChallengeResponse(result));
        }
    }

    private Response makeChallengeResponse(ApiResult result) {
        return Response.status((int)401).header("WWW-Authenticate", (Object)"Basic realm=\"PingFederate\"").type("application/json").entity((Object)result).build();
    }

    private Response makeBearerResponse() {
        ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.token_invalid);
        String wwwAuthHeaderValue = ApiAuthenticationType.BEARER + " realm=\"PingFederate\", error=\"" + AccessTokenUtil.ErrorCode.invalid_token + "\", error_description=\"" + result.getMessage() + "\"";
        return Response.status((int)401).header("WWW-Authenticate", (Object)wwwAuthHeaderValue).type("application/json").entity((Object)result).build();
    }

    private String createFailedLogMessage(String msg) {
        return String.format("%s, authentication-success=false, msg=%s", this.getRequestInfo(this.servletRequest), msg);
    }

    private String getRequestInfo(HttpServletRequest request) {
        return "Admin API request: uri=" + request.getRequestURI() + ", method=" + request.getMethod() + ", remote-ip=" + request.getRemoteAddr();
    }
}

