/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.filter;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ApiResultFactory;
import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.model.ApiResult;
import com.pingidentity.pf.common.api.util.CorsUtils;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnsureAuthorizationCheckedFilter
implements ContainerResponseFilter {
    private static final Log log = LogFactory.getLog(EnsureAuthorizationCheckedFilter.class);
    @Context
    private HttpServletRequest servletRequest;

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        if (CorsUtils.isSuccessfulOptionsCorsRequest((String)this.servletRequest.getMethod(), (HttpServletRequest)this.servletRequest)) {
            return response;
        }
        if (!ApiUtil.isApiDocsRequest(this.servletRequest) && response.getStatusType().getFamily() == Response.Status.Family.SUCCESSFUL && this.servletRequest.getAttribute("com.pingidentity.pf.admin.rest.authorization_checked") == null && request.getProperties().get("com.pingidentity.pf.admin.rest.initial_setup") == null) {
            log.error((Object)("Missing authorization check on API request, method=" + request.getMethod() + ", path=" + request.getPath() + ", converting response to 500 Server Error"));
            ApiResult result = ApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.server_error);
            Response newResponse = Response.status((int)500).type("application/json").entity((Object)result).build();
            response.setResponse(newResponse);
        }
        return response;
    }
}

