/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.InboundBackChannelAuth;
import com.pingidentity.admin.api.model.OutboundBackChannelAuth;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.validator.SslClientVerificationCertValidator;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public abstract class AbstractBackChannelTranslator {
    public boolean isBackChannelAuthenticationNeeded(ConnectionBase domainConn) {
        if (Protocol.WSFED == domainConn.getProtocol()) {
            return false;
        }
        if (Role.IDP == domainConn.getRoleType()) {
            return domainConn.isAnySsoSelected() && (domainConn.isArtifactSsoSloUsed() || domainConn.isSloBindingUsed("urn:oasis:names:tc:SAML:2.0:bindings:SOAP") || domainConn.isInboundArtifact() || domainConn.getIncomingBindings().getSoapBinding()) || ((org.sourceid.saml20.domain.IdpConnection)domainConn).getAttributeAuthority() != null || ((org.sourceid.saml20.domain.IdpConnection)domainConn).getInboundProvisioning() != null;
        }
        return domainConn.isAnySsoSelected() && (domainConn.isArtifactSsoSloUsed() || domainConn.isInboundArtifact() || domainConn.getIncomingBindings().getSoapBinding() || domainConn.isSloBindingUsed("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) || ((org.sourceid.saml20.domain.SpConnection)domainConn).getAttributeRequester() != null;
    }

    protected boolean authMethodExist(ConnectionBase domainConn, SoapAuthInfo soapAuth) {
        return !this.isXaspOnly(domainConn) || this.isXaspOnly(domainConn) && !soapAuth.isHasNoneEntry();
    }

    protected boolean isXaspOnly(ConnectionBase domainConn) {
        if (Role.SP == domainConn.getRoleType()) {
            org.sourceid.saml20.domain.SpConnection spConn = (org.sourceid.saml20.domain.SpConnection)domainConn;
            return spConn.getAttributeRequester() != null && !spConn.isAnySsoSelected();
        }
        org.sourceid.saml20.domain.IdpConnection idpConn = (org.sourceid.saml20.domain.IdpConnection)domainConn;
        return idpConn.getAttributeAuthority() != null && !idpConn.isAnySsoSelected();
    }

    protected boolean apiNoAuthTypeSelected(Connection apiConn, ValidatorRegistry validatorRegistry) {
        if (Role.SP == apiConn.getType().getRole()) {
            SpConnection spConn = (SpConnection)apiConn;
            InboundBackChannelAuth auth = spConn.getCredentials().getInboundBackChannelAuth();
            SslClientVerificationCertValidator sslValidator = (SslClientVerificationCertValidator)validatorRegistry.getValidator(SslClientVerificationCertValidator.class);
            return auth.getHttpBasicCredentials() == null && StringUtils.isBlank((String)auth.getVerificationSubjectDN()) && sslValidator.getDomainCerts() == null;
        }
        IdpConnection idpConn = (IdpConnection)apiConn;
        OutboundBackChannelAuth auth = idpConn.getCredentials().getOutboundBackChannelAuth();
        return auth.getHttpBasicCredentials() == null && auth.getSslAuthKeyPairRef() == null;
    }

    protected boolean isXaspOnly(Connection apiConn) {
        if (Role.SP == apiConn.getType().getRole()) {
            SpConnection spConn = (SpConnection)apiConn;
            return spConn.getBrowserSso() == null && spConn.getAttributeQuery() != null;
        }
        IdpConnection idpConn = (IdpConnection)apiConn;
        return idpConn.getBrowserSso() == null && idpConn.getAttributeQuery() != null;
    }

    protected Boolean getDigitalSignature(ConnectionBase domainConn, SoapAuthInfo auth) {
        if (this.isXaspOnly(domainConn)) {
            return false;
        }
        return auth.isHasNoneEntry();
    }
}

