/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AbstractIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.BinaryLdapAttributeSettings;
import com.pingidentity.admin.api.model.ConditionalIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.CustomAttributeSource;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.ExpressionIssuanceCriteriaEntry;
import com.pingidentity.admin.api.model.IssuanceCriteria;
import com.pingidentity.admin.api.model.JdbcAttributeSource;
import com.pingidentity.admin.api.model.LdapAttributeSource;
import com.pingidentity.admin.api.model.LdapSearchScope;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.sources.CustomDataSourceDriver;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.sources.gui.FilterFieldsGuiDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AttributeMappingTranslator {
    protected static final Log log = LogFactory.getLog(AttributeMappingTranslator.class);
    private Map<SourceType, String> prefixMap = new HashMap<SourceType, String>();
    private PluginManager<?, ?> pluginManager = null;
    private String pluginId = null;

    public AttributeMappingTranslator() {
        this.prefixMap.put(SourceType.CONTEXT, "context.");
        this.prefixMap.put(SourceType.EXTENDED_CLIENT_METADATA, "extclientmetadata.");
        this.prefixMap.put(SourceType.EXTENDED_PROPERTIES, "extproperties.");
        this.prefixMap.put(SourceType.SUBJECT_TOKEN, "subjecttoken.");
        this.prefixMap.put(SourceType.ACTOR_TOKEN, "actortoken.");
    }

    public AttributeMappingTranslator(String pluginId, PluginManager<?, ?> pluginManager) {
        this();
        this.pluginManager = pluginManager;
        this.pluginId = pluginId;
    }

    public AttributeMappingTranslator(Map<SourceType, String> additionalPrefixes) {
        this();
        this.prefixMap.putAll(additionalPrefixes);
    }

    public void apiToDomain(AttributeMapping apiMapping, org.sourceid.saml20.domain.AttributeMapping domainMapping) {
        this.apiToDomain(apiMapping.getAttributeSources(), domainMapping);
        this.apiToDomain(apiMapping.getAttributeContractFulfillment(), domainMapping.getAttributeMapping());
        this.apiToDomain(apiMapping.getIssuanceCriteria(), domainMapping.getTokenAuthorizationIssuanceCriteria());
    }

    protected void apiToDomain(List<AttributeSource> apiSources, org.sourceid.saml20.domain.AttributeMapping domainMapping) {
        for (AttributeSource apiSource : apiSources) {
            org.sourceid.saml20.domain.impl.CustomAttributeSource domainSource = null;
            DataStoreType dsType = apiSource.getType();
            if (dsType == DataStoreType.CUSTOM) {
                CustomAttributeSource customApiSource = (CustomAttributeSource)apiSource;
                domainSource = this.toDomainAttributeSource(customApiSource);
            } else if (dsType == DataStoreType.LDAP) {
                LdapAttributeSource ldapApiSource = (LdapAttributeSource)apiSource;
                domainSource = this.toDomainAttributeSource(ldapApiSource);
            } else if (dsType == DataStoreType.JDBC) {
                JdbcAttributeSource jdbcApiSource = (JdbcAttributeSource)apiSource;
                domainSource = this.toDomainAttributeSource(jdbcApiSource);
            }
            if (domainSource == null) continue;
            domainMapping.addAttributeSource((org.sourceid.saml20.domain.AttributeSource)domainSource);
        }
    }

    protected org.sourceid.saml20.domain.impl.CustomAttributeSource toDomainAttributeSource(CustomAttributeSource customApiSource) {
        org.sourceid.saml20.domain.impl.CustomAttributeSource customDomainSource = new org.sourceid.saml20.domain.impl.CustomAttributeSource();
        AttributeMappingTranslator.apiToDomain(customApiSource, (org.sourceid.saml20.domain.AttributeSource)customDomainSource);
        for (Field filterField : customApiSource.getFilterFields()) {
            customDomainSource.setParameter(filterField.getName(), filterField.getValue());
        }
        return customDomainSource;
    }

    private org.sourceid.saml20.domain.impl.LdapAttributeSource toDomainAttributeSource(LdapAttributeSource ldapApiSource) {
        org.sourceid.saml20.domain.impl.LdapAttributeSource ldapDomainSource = new org.sourceid.saml20.domain.impl.LdapAttributeSource();
        AttributeMappingTranslator.apiToDomainLdapAttributeSource(ldapApiSource, ldapDomainSource);
        return ldapDomainSource;
    }

    public static void apiToDomainLdapAttributeSource(LdapAttributeSource ldapApiSource, org.sourceid.saml20.domain.impl.LdapAttributeSource ldapDomainSource) {
        AttributeMappingTranslator.apiToDomain(ldapApiSource, (org.sourceid.saml20.domain.AttributeSource)ldapDomainSource);
        Map<String, BinaryLdapAttributeSettings> binaryAttributeSettings = ldapApiSource.getBinaryAttributeSettings();
        LdapDataSource ldapDs = MgmtFactory.getDataSourceManager().getLdapDataSource(ldapApiSource.getDataStoreRef().getId());
        if (ldapDs != null) {
            for (String binaryAttr : ldapDs.getBinaryAttributes()) {
                BinaryLdapAttributeSettings settings = binaryAttributeSettings.get(binaryAttr);
                if (settings != null && settings.getBinaryEncoding() != null) {
                    ldapDomainSource.setAttributeEncodingType(binaryAttr, settings.getBinaryEncoding().name());
                    continue;
                }
                ldapDomainSource.setAttributeEncodingType(binaryAttr, LdapDataSource.LdapAttrEncodingType.BASE64.name());
            }
        }
        ldapDomainSource.setParameter("search_base", ldapApiSource.getBaseDn());
        ldapDomainSource.setParameter("filter", ldapApiSource.getSearchFilter());
        if (ldapApiSource.getSearchAttributes() != null) {
            StringJoiner joiner = new StringJoiner(",");
            ldapApiSource.getSearchAttributes().forEach(joiner::add);
            ldapDomainSource.setParameter("search_attributes", joiner.toString());
        }
        if (ldapApiSource.getSearchScope() != null) {
            String domainScope = ldapApiSource.getSearchScope().getId();
            ldapDomainSource.setParameter("search_scope", domainScope);
        }
        ldapDomainSource.setParameter("memberof_nested_group", String.valueOf(ldapApiSource.isMemberOfNestedGroup()));
    }

    private org.sourceid.saml20.domain.impl.JdbcAttributeSource toDomainAttributeSource(JdbcAttributeSource jdbcApiSource) {
        org.sourceid.saml20.domain.impl.JdbcAttributeSource jdbcDomainSource = new org.sourceid.saml20.domain.impl.JdbcAttributeSource();
        AttributeMappingTranslator.apiToDomain(jdbcApiSource, (org.sourceid.saml20.domain.AttributeSource)jdbcDomainSource);
        if (jdbcApiSource.getSchema() != null) {
            jdbcDomainSource.setParameter("schema", jdbcApiSource.getSchema());
        }
        jdbcDomainSource.setParameter("tableName", jdbcApiSource.getTable());
        jdbcDomainSource.setParameter("filter", jdbcApiSource.getFilter());
        if (jdbcApiSource.getColumnNames() != null) {
            StringJoiner joiner = new StringJoiner(",");
            jdbcApiSource.getColumnNames().forEach(joiner::add);
            jdbcDomainSource.setParameter("columnNames", joiner.toString());
        }
        return jdbcDomainSource;
    }

    private static void apiToDomain(AttributeSource apiSource, org.sourceid.saml20.domain.AttributeSource domainSource) {
        domainSource.setDataSourceId(apiSource.getDataStoreRef().getId());
        if (null != apiSource.getDescription() && !apiSource.getDescription().isEmpty()) {
            domainSource.setDescription(apiSource.getDescription());
        } else {
            domainSource.setDescription(apiSource.getId());
        }
        domainSource.setId(apiSource.getId());
    }

    protected void apiToDomain(Map<String, AttributeFulfillmentValue> apiMappings, Map<String, List<AttrMappingValue>> domainMappings) {
        if (apiMappings != null) {
            for (Map.Entry<String, AttributeFulfillmentValue> entry : apiMappings.entrySet()) {
                String attrName = entry.getKey();
                AttrMappingValue domainValue = this.apiToDomainAttrMappingValue(entry.getValue(), true);
                domainMappings.put(attrName, Arrays.asList(domainValue));
            }
        }
    }

    public AttrMappingValue apiToDomainAttrMappingValue(AttributeFulfillmentValue attrValue, boolean addPrefix) {
        SourceType sourceType = attrValue.getSource().getType();
        Object strValue = attrValue.getValue();
        String attrSourceId = this.apiToDomainSourceId(sourceType, attrValue.getSource().getId());
        String prefix = this.prefixMap.get((Object)sourceType);
        if (addPrefix && prefix != null) {
            strValue = prefix + (String)strValue;
        }
        org.sourceid.saml20.domain.SourceType domainSourceType = sourceType.getCorrespondingDomainSourceType();
        return new AttrMappingValue(domainSourceType, (String)(SourceType.NO_MAPPING.equals((Object)sourceType) ? SourceType.NO_MAPPING.toString() : strValue), null, attrSourceId);
    }

    protected void apiToDomain(IssuanceCriteria issuanceCriteria, List<TokenAuthorizationIssuanceCriterion> tokenAuthorizationIssuanceCriteria) {
        TokenAuthorizationIssuanceCriterion domainCriterion;
        for (ConditionalIssuanceCriteriaEntry conditionalIssuanceCriteriaEntry : issuanceCriteria.getConditionalCriteria()) {
            domainCriterion = new TokenAuthorizationIssuanceCriterion();
            Object attrName = conditionalIssuanceCriteriaEntry.getAttributeName();
            String prefix = this.prefixMap.get((Object)conditionalIssuanceCriteriaEntry.getSource().getType());
            if (prefix != null) {
                attrName = prefix + (String)attrName;
            }
            domainCriterion.setAttrName((String)attrName);
            domainCriterion.setAttrSourceId(conditionalIssuanceCriteriaEntry.getSource().getId());
            domainCriterion.setAttrSourceType(conditionalIssuanceCriteriaEntry.getSource().getType().getCorrespondingDomainSourceType());
            domainCriterion.setComparisonValue(conditionalIssuanceCriteriaEntry.getValue());
            domainCriterion.setCondition(conditionalIssuanceCriteriaEntry.getCondition());
            domainCriterion.setErrorResult(conditionalIssuanceCriteriaEntry.getErrorResult());
            tokenAuthorizationIssuanceCriteria.add(domainCriterion);
        }
        if (issuanceCriteria.getExpressionCriteria() != null) {
            for (ExpressionIssuanceCriteriaEntry expressionIssuanceCriteriaEntry : issuanceCriteria.getExpressionCriteria()) {
                domainCriterion = new TokenAuthorizationIssuanceCriterion();
                domainCriterion.setAttrSourceType(org.sourceid.saml20.domain.SourceType.EXPRESSION);
                domainCriterion.setExpr(expressionIssuanceCriteriaEntry.getExpression());
                domainCriterion.setErrorResult(expressionIssuanceCriteriaEntry.getErrorResult());
                tokenAuthorizationIssuanceCriteria.add(domainCriterion);
            }
        }
    }

    public void domainToApi(org.sourceid.saml20.domain.AttributeMapping domainMapping, AttributeMapping apiMapping) {
        this.domainToApi(domainMapping.getAttributeSources(), apiMapping.getAttributeSources());
        this.domainToApi(domainMapping.getAttributeMapping(), apiMapping.getAttributeContractFulfillment());
        this.domainToApi(domainMapping.getTokenAuthorizationIssuanceCriteria(), apiMapping.getIssuanceCriteria());
    }

    public void domainToApi(org.sourceid.saml20.domain.AttributeMapping domainMapping, AttributeMapping apiMapping, Set<String> validAttributes, boolean useDeletedAttribute) {
        this.domainToApi(domainMapping.getAttributeSources(), apiMapping.getAttributeSources());
        this.domainToApi(domainMapping.getAttributeMapping(), apiMapping.getAttributeContractFulfillment(), validAttributes, useDeletedAttribute);
        this.domainToApi(domainMapping.getTokenAuthorizationIssuanceCriteria(), apiMapping.getIssuanceCriteria());
    }

    protected void domainToApi(List<org.sourceid.saml20.domain.AttributeSource> domainSources, List<AttributeSource> apiSources) {
        for (org.sourceid.saml20.domain.AttributeSource domainSource : domainSources) {
            AttributeSource apiSource = null;
            DataSource.DSType dsType = DataSource.DSType.fromName((String)domainSource.getType());
            switch (dsType) {
                case Other: {
                    org.sourceid.saml20.domain.impl.CustomAttributeSource customDomainSource = (org.sourceid.saml20.domain.impl.CustomAttributeSource)domainSource;
                    apiSource = this.toApiAttributeSource(customDomainSource);
                    break;
                }
                case LDAP: {
                    org.sourceid.saml20.domain.impl.LdapAttributeSource ldapDomainSource = (org.sourceid.saml20.domain.impl.LdapAttributeSource)domainSource;
                    apiSource = AttributeMappingTranslator.toApiAttributeSource(ldapDomainSource);
                    break;
                }
                case JDBC: {
                    org.sourceid.saml20.domain.impl.JdbcAttributeSource jdbcDomainSource = (org.sourceid.saml20.domain.impl.JdbcAttributeSource)domainSource;
                    apiSource = this.toApiAttributeSource(jdbcDomainSource);
                    break;
                }
                default: {
                    apiSource = null;
                }
            }
            if (apiSource == null) continue;
            apiSources.add(apiSource);
        }
    }

    private AttributeSource toApiAttributeSource(org.sourceid.saml20.domain.impl.CustomAttributeSource customDomainSource) {
        CustomDataSourceDriverDescriptor dsdd;
        FilterFieldsGuiDescriptor ffd;
        SourceDescriptor sourceDescriptor;
        CustomAttributeSource customApiSource = new CustomAttributeSource();
        AttributeMappingTranslator.domainToApi((org.sourceid.saml20.domain.AttributeSource)customDomainSource, customApiSource);
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        CustomDataSource ds = dsMgr.getCustomDataSource(customDomainSource.getDataSourceId());
        if (ds == null) {
            log.error((Object)("The custom data store (ID: \"" + customDomainSource.getDataSourceId() + "\") used as an attribute source cannot be loaded. Ensure that all custom data store JAR files are deployed."));
            return null;
        }
        CustomDataSourceDriver dsDriver = ds.getDriver();
        if (dsDriver == null) {
            dsMgr.loadCustomDataSourceDriver(ds);
            dsDriver = ds.getDriver();
        }
        if ((sourceDescriptor = dsDriver.getSourceDescriptor()) instanceof CustomDataSourceDriverDescriptor && (ffd = (dsdd = (CustomDataSourceDriverDescriptor)dsDriver.getSourceDescriptor()).getFilterFieldsDescriptor()) != null && ffd.getFields() != null) {
            for (FieldDescriptor fd : ffd.getFields()) {
                String filterFieldName = fd.getName();
                String filterFieldLabel = fd.getLabel();
                String filterFieldValue = customDomainSource.getParameter(filterFieldName);
                customApiSource.getFilterFields().add(new Field(filterFieldName, filterFieldLabel, filterFieldValue));
            }
        }
        return customApiSource;
    }

    public static AttributeSource toApiAttributeSource(org.sourceid.saml20.domain.impl.LdapAttributeSource ldapDomainSource) {
        LdapAttributeSource ldapApiSource = new LdapAttributeSource();
        AttributeMappingTranslator.domainToApiLdapAttributeSource(ldapDomainSource, ldapApiSource);
        return ldapApiSource;
    }

    private static void domainToApiLdapAttributeSource(org.sourceid.saml20.domain.impl.LdapAttributeSource ldapDomainSource, LdapAttributeSource ldapApiSource) {
        Collection<Object> ldapDsBinaryAttributes;
        AttributeMappingTranslator.domainToApi((org.sourceid.saml20.domain.AttributeSource)ldapDomainSource, ldapApiSource);
        ldapApiSource.setBaseDn(ldapDomainSource.getParameter("search_base"));
        ldapApiSource.setSearchFilter(ldapDomainSource.getParameter("filter"));
        String searchAttributes = ldapDomainSource.getParameter("search_attributes");
        if (searchAttributes != null) {
            String[] searchAttributeTokens = searchAttributes.split(",");
            ArrayList<String> searchAttributeList = new ArrayList<String>(Arrays.asList(searchAttributeTokens));
            ldapApiSource.setSearchAttributes(searchAttributeList);
        }
        String domainScope = ldapDomainSource.getParameter("search_scope");
        ldapApiSource.setSearchScope(LdapSearchScope.getType(domainScope));
        boolean memberOfNestedGroups = Boolean.valueOf(ldapDomainSource.getParameter("memberof_nested_group"));
        ldapApiSource.setMemberOfNestedGroup(memberOfNestedGroups);
        LdapDataSource ldapDs = MgmtFactory.getDataSourceManager().getLdapDataSource(ldapDomainSource.getDataSourceId());
        if (ldapDs != null) {
            ldapDsBinaryAttributes = ldapDs.getBinaryAttributes();
        } else {
            log.error((Object)("The LDAP data store (ID: \"" + ldapDomainSource.getDataSourceId() + "\") used as an attribute source cannot be loaded. Ensure that the LDAP data store exists."));
            ldapDsBinaryAttributes = ldapDomainSource.getAttributeEncodingTypeMap().keySet();
        }
        for (String binaryAttr : ldapDsBinaryAttributes) {
            String encodingVal = (String)ldapDomainSource.getAttributeEncodingTypeMap().get(binaryAttr);
            BinaryLdapAttributeSettings settings = new BinaryLdapAttributeSettings();
            LdapDataSource.LdapAttrEncodingType encodingType = null;
            try {
                encodingType = LdapDataSource.LdapAttrEncodingType.valueOf((String)encodingVal);
            }
            catch (Exception e) {
                encodingType = LdapDataSource.LdapAttrEncodingType.BASE64;
            }
            settings.setBinaryEncoding(encodingType);
            ldapApiSource.getBinaryAttributeSettings().put(binaryAttr, settings);
        }
    }

    private AttributeSource toApiAttributeSource(org.sourceid.saml20.domain.impl.JdbcAttributeSource jdbcDomainSource) {
        JdbcAttributeSource jdbcApiSource = new JdbcAttributeSource();
        AttributeMappingTranslator.domainToApi((org.sourceid.saml20.domain.AttributeSource)jdbcDomainSource, jdbcApiSource);
        jdbcApiSource.setSchema(jdbcDomainSource.getParameter("schema"));
        jdbcApiSource.setTable(jdbcDomainSource.getParameter("tableName"));
        jdbcApiSource.setFilter(jdbcDomainSource.getParameter("filter"));
        String columnNames = jdbcDomainSource.getParameter("columnNames");
        if (columnNames != null) {
            String[] columnNameTokens = columnNames.split(",");
            ArrayList<String> columnNamesList = new ArrayList<String>(Arrays.asList(columnNameTokens));
            jdbcApiSource.setColumnNames(columnNamesList);
        }
        return jdbcApiSource;
    }

    protected static void domainToApi(org.sourceid.saml20.domain.AttributeSource domainSource, AttributeSource apiSource) {
        ResourceLink dsRef = new ResourceLink();
        dsRef.setId(domainSource.getDataSourceId());
        dsRef.setLocation(ApiUtil.getResourceUrl("/dataStores", domainSource.getDataSourceId()));
        apiSource.setDataStoreRef(dsRef);
        apiSource.setId(domainSource.getId());
        apiSource.setDescription(domainSource.getDescription());
    }

    protected void domainToApi(Map<String, List<AttrMappingValue>> domainMapping, Map<String, AttributeFulfillmentValue> apiMapping) {
        Set<String> validAttributes = new HashSet<String>();
        boolean useDeletedAttribute = true;
        if (this.pluginId != null && this.pluginManager != null) {
            ConfigurablePluginInstance pluginInstance = this.pluginManager.getInstance(this.pluginId);
            validAttributes = pluginInstance.getAttributeContract().getAllAttributeNames();
            if (pluginInstance instanceof BearerAccessTokenMgmtPluginInstance) {
                validAttributes.addAll(((BearerAccessTokenMgmtPluginInstance)pluginInstance).getTokenEndpointAttributeContract().getAllAttributeNames());
            }
            useDeletedAttribute = false;
        }
        this.domainToApi(domainMapping, apiMapping, validAttributes, useDeletedAttribute);
    }

    private void domainToApi(Map<String, List<AttrMappingValue>> domainMapping, Map<String, AttributeFulfillmentValue> apiMapping, Set<String> validAttributes, boolean useDeletedAttribute) {
        for (Map.Entry<String, List<AttrMappingValue>> entry : domainMapping.entrySet()) {
            if (!useDeletedAttribute && !validAttributes.contains(entry.getKey())) continue;
            AttrMappingValue domainAttrValue = entry.getValue().get(0);
            AttributeFulfillmentValue apiAttrValue = this.domainToApiAttributeValue(domainAttrValue);
            apiMapping.put(entry.getKey(), apiAttrValue);
        }
    }

    public AttributeFulfillmentValue domainToApiAttributeValue(AttrMappingValue domainAttrValue) {
        AttributeFulfillmentValue apiAttrValue = new AttributeFulfillmentValue();
        SourceType apiSourceType = SourceType.getApiSourceTypeFromDomainSourceType(domainAttrValue.getType());
        String apiValue = domainAttrValue.getValue();
        if (this.prefixMap.containsKey((Object)apiSourceType)) {
            int index = apiValue.indexOf(".");
            apiValue = apiValue.substring(index + 1);
        }
        apiAttrValue.setSource(new SourceTypeIdKey(apiSourceType, domainAttrValue.getAttributeSourceId()));
        apiAttrValue.setValue(apiValue);
        return apiAttrValue;
    }

    protected void domainToApi(List<TokenAuthorizationIssuanceCriterion> domainIssuanceCriteria, IssuanceCriteria apiIssuanceCriteria) {
        LinkedList<ExpressionIssuanceCriteriaEntry> expressionCriteria = new LinkedList<ExpressionIssuanceCriteriaEntry>();
        for (TokenAuthorizationIssuanceCriterion domainIC : domainIssuanceCriteria) {
            AbstractIssuanceCriteriaEntry apiCritEntry;
            if (StringUtils.isEmpty((String)domainIC.getExpr())) {
                apiCritEntry = new ConditionalIssuanceCriteriaEntry();
                SourceTypeIdKey sourceKey = new SourceTypeIdKey();
                String attrSourceId = domainIC.getAttrSourceId();
                if (attrSourceId != null && attrSourceId.length() == 0) {
                    attrSourceId = null;
                }
                sourceKey.setId(attrSourceId);
                sourceKey.setType(SourceType.getApiSourceTypeFromDomainSourceType(domainIC.getAttrSourceType()));
                String apiAttrName = domainIC.getAttrName();
                if (this.prefixMap.containsKey((Object)sourceKey.getType())) {
                    int index = apiAttrName.indexOf(".");
                    apiAttrName = apiAttrName.substring(index + 1);
                }
                ((ConditionalIssuanceCriteriaEntry)apiCritEntry).setAttributeName(apiAttrName);
                ((ConditionalIssuanceCriteriaEntry)apiCritEntry).setCondition(domainIC.getCondition());
                apiCritEntry.setErrorResult(domainIC.getErrorResult());
                ((ConditionalIssuanceCriteriaEntry)apiCritEntry).setSource(sourceKey);
                ((ConditionalIssuanceCriteriaEntry)apiCritEntry).setValue(domainIC.getComparisonValue());
                apiIssuanceCriteria.getConditionalCriteria().add((ConditionalIssuanceCriteriaEntry)apiCritEntry);
                continue;
            }
            apiCritEntry = new ExpressionIssuanceCriteriaEntry();
            apiCritEntry.setErrorResult(domainIC.getErrorResult());
            ((ExpressionIssuanceCriteriaEntry)apiCritEntry).setExpression(domainIC.getExpr());
            expressionCriteria.add((ExpressionIssuanceCriteriaEntry)apiCritEntry);
        }
        if (!expressionCriteria.isEmpty()) {
            apiIssuanceCriteria.setExpressionCriteria(expressionCriteria);
        }
    }

    private String apiToDomainSourceId(SourceType apiSourceType, String sourceId) {
        if (SourceType.INPUTS.equals((Object)apiSourceType)) {
            return "inputs";
        }
        return sourceId;
    }
}

