/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.auditing.AuditLoggingSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;

public class AuditLoggingSettingsTranslator {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingSettingsTranslator.class);
    private final NotificationPublisherPluginManager notificationPublisherPluginManager;

    public AuditLoggingSettingsTranslator(NotificationPublisherPluginManager notificationPublisherPluginManager) {
        this.notificationPublisherPluginManager = notificationPublisherPluginManager;
    }

    public AuditLoggingSettingsTranslator() {
        this(MgmtFactory.getNotificationPublisherPluginManager());
    }

    public AuditLoggingSettings domainToApi(org.sourceid.saml20.domain.AuditLoggingSettings domainSettings) {
        AuditLoggingSettings loggingSettings = new AuditLoggingSettings();
        loggingSettings.setTrackAuditLogFailures(domainSettings.isTrackAuditLogFailures());
        loggingSettings.setFailureMode(domainSettings.getFailureMode());
        loggingSettings.setInterval(domainSettings.getInterval());
        loggingSettings.setThreshold(domainSettings.getThreshold());
        if (domainSettings.getNotificationPublisherId() != null && this.doesNotificationPublisherExist(domainSettings.getNotificationPublisherId())) {
            ResourceLink resourceLinkNotificationPublisher = new ResourceLink();
            resourceLinkNotificationPublisher.setId(domainSettings.getNotificationPublisherId());
            resourceLinkNotificationPublisher.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherId()));
            loggingSettings.setNotificationPublisher(resourceLinkNotificationPublisher);
        }
        loggingSettings.setEmailsToNotify(domainSettings.getEmailsToNotify());
        return loggingSettings;
    }

    private boolean doesNotificationPublisherExist(String notificationPublisherId) {
        return this.notificationPublisherPluginManager.getNotificationSenderPlugin(notificationPublisherId) != null;
    }

    public org.sourceid.saml20.domain.AuditLoggingSettings apiToDomain(AuditLoggingSettings apiSettings) {
        org.sourceid.saml20.domain.AuditLoggingSettings domainSettings = new org.sourceid.saml20.domain.AuditLoggingSettings();
        domainSettings.setTrackAuditLogFailures(Boolean.valueOf(apiSettings.isTrackAuditLogFailures()));
        domainSettings.setFailureMode(apiSettings.getFailureMode());
        domainSettings.setInterval(apiSettings.getInterval());
        domainSettings.setThreshold(apiSettings.getThreshold());
        if (apiSettings.getNotificationPublisher() != null) {
            domainSettings.setNotificationPublisherId(apiSettings.getNotificationPublisher().getId());
        }
        domainSettings.setEmailsToNotify(apiSettings.getEmailsToNotify());
        return domainSettings;
    }
}

