/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AuthenticationPolicy;
import com.pingidentity.admin.api.model.AuthenticationPolicyTree;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicyTreeTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationSourceTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.sourceid.saml20.domain.TrackedHttpParamsSettings;
import org.sourceid.saml20.domain.mgmt.AuthnSelectionConfigManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AuthnSourceKey;

public class AuthenticationPolicyTranslator {
    public AuthenticationPolicy domainToApi(AuthnSelectionConfigManager configManager) {
        AuthenticationPolicy apiAuthnPolicies = new AuthenticationPolicy();
        apiAuthnPolicies.setFailIfNoSelection(configManager.isFailIfNoSelection());
        AuthenticationPolicyTreeTranslator authenticationPolicyTreeTranslator = new AuthenticationPolicyTreeTranslator();
        LinkedList<AuthenticationPolicyTree> apiTreeList = new LinkedList<AuthenticationPolicyTree>();
        for (AuthnSelectionTree domainTree : configManager.getAuthnSelectionTrees()) {
            apiTreeList.add(authenticationPolicyTreeTranslator.domainToApi(domainTree));
        }
        apiAuthnPolicies.setAuthnSelectionTrees(apiTreeList);
        AuthenticationSourceTranslator authenticationSourceTranslator = new AuthenticationSourceTranslator();
        ArrayList<AuthenticationSource> defaultAuthenticationSources = new ArrayList<AuthenticationSource>();
        for (AuthnSourceKey authnSourceKey : configManager.getDefaultAuthnSourceKeys()) {
            defaultAuthenticationSources.add(authenticationSourceTranslator.domainToApi(authnSourceKey));
        }
        apiAuthnPolicies.setDefaultAuthenticationSources(defaultAuthenticationSources);
        TrackedHttpParamsSettings settings = MgmtFactory.getTrackedHttpParamManager().getTrackedParamSettings();
        if (settings.isTrackingEnabled()) {
            apiAuthnPolicies.setTrackedHttpParameters(settings.getTrackedParamNames());
        }
        return apiAuthnPolicies;
    }

    public void apiToDomain(AuthnSelectionConfigManager configManager, AuthenticationPolicy apiPolicy) {
        configManager.setFailIfNoSelection(apiPolicy.isFailIfNoSelection());
        AuthenticationPolicyTreeTranslator authenticationPolicyTreeTranslator = new AuthenticationPolicyTreeTranslator();
        LinkedList<AuthnSelectionTree> domainTreeList = new LinkedList<AuthnSelectionTree>();
        for (AuthenticationPolicyTree apiTree : apiPolicy.getAuthnSelectionTrees()) {
            domainTreeList.add(authenticationPolicyTreeTranslator.apiToDomain(apiTree));
        }
        configManager.setAuthnSelectionTrees(domainTreeList);
        TrackedHttpParamsSettings settings = new TrackedHttpParamsSettings(apiPolicy.getTrackedHttpParameters() != null ? apiPolicy.getTrackedHttpParameters() : Collections.emptyList());
        MgmtFactory.getTrackedHttpParamManager().saveTrackedParamSettings(settings);
        AuthenticationSourceTranslator authenticationSourceTranslator = new AuthenticationSourceTranslator();
        ArrayList<AuthnSourceKey> domainAuthnSourceKeys = new ArrayList<AuthnSourceKey>();
        if (apiPolicy.getDefaultAuthenticationSources() != null && !apiPolicy.getDefaultAuthenticationSources().isEmpty()) {
            for (AuthenticationSource apiAuthenticationSource : apiPolicy.getDefaultAuthenticationSources()) {
                domainAuthnSourceKeys.add(authenticationSourceTranslator.apiToDomain(apiAuthenticationSource));
            }
        }
        configManager.setDefaultAuthnSourceKeys(domainAuthnSourceKeys);
    }
}

