/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthenticationPolicySelectionActionType;
import com.pingidentity.admin.api.model.AuthenticationPolicyTree;
import com.pingidentity.admin.api.model.AuthenticationPolicyTreeNode;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.pf.admin.rest.translator.ApcMappingActionTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicySelectionActionTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthnSelectorActionTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthnSourceActionTranslator;
import com.pingidentity.pf.admin.rest.translator.FragmentActionTranslator;
import com.pingidentity.pf.admin.rest.translator.LocalIdentityMappingActionTranslator;
import com.pingidentity.pf.admin.rest.translator.NoOpActionTranslator;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public class AuthenticationPolicyTreeTranslator {
    public AuthenticationPolicyTree domainToApi(AuthnSelectionTree domainTree) {
        AuthenticationPolicyTree apiTree = new AuthenticationPolicyTree();
        apiTree.setRootNode(this.buildApiPolicyTree((Tree.Node<AuthnSelectionAction>)domainTree.getRootNode()));
        if (StringUtils.isNotBlank((String)domainTree.getId())) {
            apiTree.setId(domainTree.getId());
        }
        if (StringUtils.isNotBlank((String)domainTree.getName())) {
            apiTree.setName(domainTree.getName());
        }
        if (StringUtils.isNotBlank((String)domainTree.getDescription())) {
            apiTree.setDescription(domainTree.getDescription());
        }
        apiTree.setEnabled(!domainTree.isDisabled());
        if (StringUtils.isNotBlank((String)domainTree.getOverrideAuthnApiApplicationId())) {
            ResourceLink overrideApp = new ResourceLink(domainTree.getOverrideAuthnApiApplicationId(), ApiUtil.getResourceUrl("/authenticationApi/applications", domainTree.getOverrideAuthnApiApplicationId()));
            apiTree.setAuthenticationApiApplicationRef(overrideApp);
        }
        apiTree.setHandleFailuresLocally(domainTree.isHandleFailuresLocally());
        return apiTree;
    }

    public AuthenticationPolicyTreeNode buildApiPolicyTree(Tree.Node<AuthnSelectionAction> domainRootNode) {
        AuthenticationPolicyTreeNode apiRootNode = new AuthenticationPolicyTreeNode();
        AuthnSelectionAction domainRootAction = (AuthnSelectionAction)domainRootNode.getData();
        AuthenticationPolicySelectionActionTranslator authenticationPolicySelectionActionTranslator = this.getActionTranslator(domainRootAction);
        PolicyAction apiRootAction = authenticationPolicySelectionActionTranslator.domainToApi(domainRootAction);
        apiRootNode.setAction(apiRootAction);
        List<Tree.Node<AuthnSelectionAction>> domainTreeRootNodeChildren = domainRootNode.getChildren();
        if (domainRootAction instanceof AuthnSelectorAction) {
            domainTreeRootNodeChildren = this.sortChildNodes((AuthnSelectorAction)domainRootAction, domainTreeRootNodeChildren);
        }
        this.buildApiTree(apiRootNode, domainTreeRootNodeChildren);
        return apiRootNode;
    }

    private void buildApiTree(AuthenticationPolicyTreeNode apiParentNode, List<Tree.Node<AuthnSelectionAction>> domainNodeChildren) {
        if (domainNodeChildren != null && !domainNodeChildren.isEmpty()) {
            apiParentNode.setChildren(new ArrayList<AuthenticationPolicyTreeNode>());
            for (Tree.Node<AuthnSelectionAction> domainNodeChild : domainNodeChildren) {
                AuthenticationPolicyTreeNode apiChildNode = new AuthenticationPolicyTreeNode();
                AuthnSelectionAction domainAction = (AuthnSelectionAction)domainNodeChild.getData();
                AuthenticationPolicySelectionActionTranslator actionTranslator = this.getActionTranslator(domainAction);
                PolicyAction apiAction = actionTranslator.domainToApi(domainAction);
                apiChildNode.setAction(apiAction);
                apiParentNode.getChildren().add(apiChildNode);
                List<Tree.Node<AuthnSelectionAction>> children = domainNodeChild.getChildren();
                if (domainAction instanceof AuthnSelectorAction) {
                    children = this.sortChildNodes((AuthnSelectorAction)domainAction, children);
                }
                this.buildApiTree(apiChildNode, children);
            }
        }
    }

    private List<Tree.Node<AuthnSelectionAction>> sortChildNodes(AuthnSelectorAction action, List<Tree.Node<AuthnSelectionAction>> children) {
        final AuthnSelectorInstance instance = (AuthnSelectorInstance)MgmtFactory.getAuthnSelectorManager().getInstance(action.getAuthnSelectorId());
        if (instance == null) {
            return children;
        }
        ArrayList<Tree.Node<AuthnSelectionAction>> result = new ArrayList<Tree.Node<AuthnSelectionAction>>(children);
        Collections.sort(result, new Comparator<Tree.Node<AuthnSelectionAction>>(){

            @Override
            public int compare(Tree.Node<AuthnSelectionAction> action1, Tree.Node<AuthnSelectionAction> action2) {
                return instance.compareResultValues(((AuthnSelectionAction)action1.getData()).getContext(), ((AuthnSelectionAction)action2.getData()).getContext());
            }
        });
        return result;
    }

    public AuthnSelectionTree apiToDomain(AuthenticationPolicyTree apiTree) {
        AuthenticationPolicyTreeNode apiTreeRootNode = apiTree.getRootNode();
        AuthnSelectionTree domainTree = new AuthnSelectionTree(this.buildDomainPolicyTree(apiTreeRootNode));
        if (StringUtils.isBlank((String)apiTree.getId())) {
            domainTree.setId(AuthnPolicyUtil.getDefault().generateId());
        } else {
            domainTree.setId(apiTree.getId());
        }
        if (StringUtils.isNotBlank((String)apiTree.getName())) {
            domainTree.setName(apiTree.getName());
        }
        if (StringUtils.isNotBlank((String)apiTree.getDescription())) {
            domainTree.setDescription(apiTree.getDescription());
        }
        if (apiTree.isEnabled() != null) {
            domainTree.setDisabled(apiTree.isEnabled() == false);
        } else {
            domainTree.setDisabled(false);
        }
        if (apiTree.getAuthenticationApiApplicationRef() != null) {
            domainTree.setOverrideAuthnApiApplicationId(apiTree.getAuthenticationApiApplicationRef().getId());
        }
        domainTree.setHandleFailuresLocally(apiTree.getHandleFailuresLocally().booleanValue());
        return domainTree;
    }

    private void buildDomainTree(Tree.Node<AuthnSelectionAction> domainParentNode, List<AuthenticationPolicyTreeNode> apiNodeChildren) {
        if (apiNodeChildren != null && !apiNodeChildren.isEmpty()) {
            for (AuthenticationPolicyTreeNode apiNodeChild : apiNodeChildren) {
                AuthenticationPolicySelectionActionTranslator actionTranslator = this.getActionTranslator(apiNodeChild.getAction().getType());
                AuthnSelectionAction domainAction = actionTranslator.apiToDomain(apiNodeChild.getAction());
                Tree.Node domainChildNode = new Tree.Node((Object)domainAction);
                domainParentNode.addChildNode(domainChildNode);
                this.buildDomainTree((Tree.Node<AuthnSelectionAction>)domainChildNode, apiNodeChild.getChildren());
            }
        }
    }

    public Tree.Node<AuthnSelectionAction> buildDomainPolicyTree(AuthenticationPolicyTreeNode apiTreeRootNode) {
        AuthenticationPolicySelectionActionTranslator actionTranslator = this.getActionTranslator(apiTreeRootNode.getAction().getType());
        AuthnSelectionAction domainRootAction = actionTranslator.apiToDomain(apiTreeRootNode.getAction());
        Tree.Node domainRootNode = new Tree.Node((Object)domainRootAction);
        List<AuthenticationPolicyTreeNode> apiTreeRootNodeChildren = apiTreeRootNode.getChildren();
        this.buildDomainTree((Tree.Node<AuthnSelectionAction>)domainRootNode, apiTreeRootNodeChildren);
        return domainRootNode;
    }

    private AuthenticationPolicySelectionActionTranslator getActionTranslator(AuthnSelectionAction domainAction) {
        if (domainAction instanceof ApcMappingAction) {
            return new ApcMappingActionTranslator();
        }
        if (domainAction instanceof AuthnSelectorAction) {
            return new AuthnSelectorActionTranslator();
        }
        if (domainAction instanceof AuthnSourceAction) {
            return new AuthnSourceActionTranslator();
        }
        if (domainAction instanceof LocalIdentityMappingAction) {
            return new LocalIdentityMappingActionTranslator();
        }
        if (domainAction instanceof NoOpAction) {
            return new NoOpActionTranslator();
        }
        if (domainAction instanceof FragmentAction) {
            return new FragmentActionTranslator();
        }
        throw new RuntimeException("Unexpected Authentication Selection PolicyAction: " + domainAction);
    }

    private AuthenticationPolicySelectionActionTranslator getActionTranslator(AuthenticationPolicySelectionActionType apiActionType) {
        switch (apiActionType) {
            case APC_MAPPING: {
                return new ApcMappingActionTranslator();
            }
            case AUTHN_SELECTOR: {
                return new AuthnSelectorActionTranslator();
            }
            case AUTHN_SOURCE: {
                return new AuthnSourceActionTranslator();
            }
            case LOCAL_IDENTITY_MAPPING: {
                return new LocalIdentityMappingActionTranslator();
            }
            case DONE: {
                return new NoOpActionTranslator();
            }
            case CONTINUE: {
                return new NoOpActionTranslator();
            }
            case RESTART: {
                return new NoOpActionTranslator();
            }
            case FRAGMENT: {
                return new FragmentActionTranslator();
            }
        }
        throw new RuntimeException("Unexpected Authentication Selection Type: " + apiActionType);
    }
}

