/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ApplicationSessionPolicy;
import com.pingidentity.admin.api.model.AuthenticationSessionPolicy;
import com.pingidentity.admin.api.model.GlobalAuthenticationSessionPolicy;
import com.pingidentity.admin.api.model.sessions.SessionQuotaSettings;
import com.pingidentity.pf.admin.rest.translator.AuthenticationSourceTranslator;
import org.sourceid.saml20.domain.AuthnSessionPolicy;
import org.sourceid.saml20.domain.GlobalAuthnSessionPolicy;
import org.sourceid.saml20.domain.UserDeviceType;
import org.sourceid.saml20.domain.sessions.QuotaPolicy;

public class AuthenticationSessionPolicyTranslator {
    private final AuthenticationSourceTranslator authnSourceTranslator = new AuthenticationSourceTranslator();

    public GlobalAuthnSessionPolicy apiToDomain(GlobalAuthenticationSessionPolicy apiPolicy) {
        GlobalAuthnSessionPolicy result = new GlobalAuthnSessionPolicy();
        result.setEnableSessions(apiPolicy.isEnableSessions().booleanValue());
        if (apiPolicy.getIdleTimeoutMins() == null) {
            result.setIdleTimeoutMins(60);
        } else {
            result.setIdleTimeoutMins(apiPolicy.getIdleTimeoutMins().intValue());
        }
        if (apiPolicy.getMaxTimeoutMins() == null) {
            result.setMaxTimeoutMins(480);
        } else {
            result.setMaxTimeoutMins(apiPolicy.getMaxTimeoutMins().intValue());
        }
        if (apiPolicy.isPersistentSessions() != null) {
            result.setPersistentSessions(apiPolicy.isPersistentSessions().booleanValue());
        }
        if (apiPolicy.isHashUniqueUserKeyAttribute() != null) {
            result.setHashUniqueUserKeyAttribute(apiPolicy.isHashUniqueUserKeyAttribute().booleanValue());
        }
        if (apiPolicy.getIdleTimeoutDisplayUnit() != null) {
            result.setIdleTimeoutDisplayUnit(apiPolicy.getIdleTimeoutDisplayUnit());
        }
        if (apiPolicy.getMaxTimeoutDisplayUnit() != null) {
            result.setMaxTimeoutDisplayUnit(apiPolicy.getMaxTimeoutDisplayUnit());
        }
        return result;
    }

    public GlobalAuthenticationSessionPolicy domainToApi(GlobalAuthnSessionPolicy domainPolicy) {
        GlobalAuthenticationSessionPolicy result = new GlobalAuthenticationSessionPolicy();
        result.setEnableSessions(domainPolicy.isEnableSessions());
        result.setPersistentSessions(domainPolicy.isPersistentSessions());
        result.setHashUniqueUserKeyAttribute(domainPolicy.isHashUniqueUserKeyAttribute());
        result.setIdleTimeoutMins(domainPolicy.getIdleTimeoutMins());
        result.setIdleTimeoutDisplayUnit(domainPolicy.getIdleTimeoutDisplayUnit());
        result.setMaxTimeoutMins(domainPolicy.getMaxTimeoutMins());
        result.setMaxTimeoutDisplayUnit(domainPolicy.getMaxTimeoutDisplayUnit());
        return result;
    }

    public SessionQuotaSettings domainToApi(QuotaPolicy domainPolicy) {
        SessionQuotaSettings result = new SessionQuotaSettings();
        result.setEnableSessionQuotas(domainPolicy.isEnableSessionQuotas());
        if (domainPolicy.isEnableSessionQuotas()) {
            result.setSessionLimit(domainPolicy.getActiveSessionLimit());
            result.setSessionQuotaBehavior(domainPolicy.getQuotaLimitBehavior());
        }
        return result;
    }

    public QuotaPolicy apiToDomain(SessionQuotaSettings apiPolicy) {
        QuotaPolicy result = new QuotaPolicy();
        result.setActiveSessionLimit((apiPolicy.getSessionLimit() == null ? QuotaPolicy.DEFAULT_ACTIVE_SESSION_LIMIT : apiPolicy.getSessionLimit()).intValue());
        result.setEnableSessionQuotas(apiPolicy.getEnableSessionQuotas().booleanValue());
        result.setQuotaLimitBehavior(apiPolicy.getSessionQuotaBehavior() == null ? QuotaPolicy.DEFAULT_QUOTA_LIMIT_BEHAVIOR : apiPolicy.getSessionQuotaBehavior());
        return result;
    }

    public AuthnSessionPolicy apiToDomain(AuthenticationSessionPolicy apiPolicy) {
        AuthnSessionPolicy result = new AuthnSessionPolicy();
        result.setId(apiPolicy.getId());
        result.setAuthnSourceKey(this.authnSourceTranslator.apiToDomain(apiPolicy.getAuthenticationSource()));
        result.setEnableSessions(apiPolicy.isEnableSessions().booleanValue());
        UserDeviceType userDevice = apiPolicy.getUserDeviceType();
        if (userDevice == null) {
            userDevice = UserDeviceType.getDefaultUserDevice();
        }
        result.setUserDeviceType(userDevice);
        if (apiPolicy.isPersistent() != null) {
            result.setPersistent(apiPolicy.isPersistent().booleanValue());
        }
        result.setIdleTimeoutMins(apiPolicy.getIdleTimeoutMins());
        result.setMaxTimeoutMins(apiPolicy.getMaxTimeoutMins());
        if (apiPolicy.getTimeoutDisplayUnit() != null) {
            result.setTimeoutDisplayUnit(apiPolicy.getTimeoutDisplayUnit());
        }
        result.setAuthnContextSensitive(apiPolicy.isAuthnContextSensitive());
        return result;
    }

    public AuthenticationSessionPolicy domainToApi(AuthnSessionPolicy domainPolicy) {
        AuthenticationSessionPolicy result = new AuthenticationSessionPolicy();
        result.setId(domainPolicy.getId());
        result.setAuthenticationSource(this.authnSourceTranslator.domainToApi(domainPolicy.getAuthnSourceKey()));
        result.setEnableSessions(domainPolicy.isEnableSessions());
        result.setUserDeviceType(domainPolicy.getUserDeviceType());
        result.setPersistent(domainPolicy.isPersistent());
        result.setIdleTimeoutMins(domainPolicy.getIdleTimeoutMins());
        result.setMaxTimeoutMins(domainPolicy.getMaxTimeoutMins());
        result.setTimeoutDisplayUnit(domainPolicy.getTimeoutDisplayUnit());
        result.setAuthnContextSensitive(domainPolicy.isAuthnContextSensitive());
        return result;
    }

    public ApplicationSessionPolicy domainToApi(org.sourceid.saml20.domain.ApplicationSessionPolicy domainPolicy) {
        ApplicationSessionPolicy result = new ApplicationSessionPolicy();
        result.setIdleTimeoutMins(domainPolicy.getIdleTimeoutMins());
        result.setMaxTimeoutMins(domainPolicy.getMaxTimeoutMins());
        return result;
    }

    public org.sourceid.saml20.domain.ApplicationSessionPolicy apiToDomain(ApplicationSessionPolicy apiPolicy) {
        org.sourceid.saml20.domain.ApplicationSessionPolicy result = new org.sourceid.saml20.domain.ApplicationSessionPolicy();
        if (apiPolicy.getIdleTimeoutMins() == null) {
            result.setIdleTimeoutMins(60);
        } else {
            result.setIdleTimeoutMins(apiPolicy.getIdleTimeoutMins().intValue());
        }
        if (apiPolicy.getMaxTimeoutMins() == null) {
            result.setMaxTimeoutMins(480);
        } else {
            result.setMaxTimeoutMins(apiPolicy.getMaxTimeoutMins().intValue());
        }
        return result;
    }
}

