/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeRules;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.AuthnSourcePolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.pf.admin.rest.translator.AttributeRuleTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicySelectionActionTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationSourceTranslator;
import java.util.ArrayList;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.service.AuthnSourceKey;

public class AuthnSourceActionTranslator
extends AuthenticationPolicySelectionActionTranslator<AuthnSourcePolicyAction, AuthnSourceAction> {
    @Override
    public PolicyAction domainToApi(AuthnSourceAction domainAction) {
        AuthnSourcePolicyAction apiAuthnSourceAction = super.domainToApi(new AuthnSourcePolicyAction(), domainAction);
        AuthenticationSourceTranslator authenticationSourceTranslator = new AuthenticationSourceTranslator();
        AuthenticationSource authenticationSource = authenticationSourceTranslator.domainToApi(domainAction.getAuthnSourceKey());
        apiAuthnSourceAction.setAuthenticationSource(authenticationSource);
        if (domainAction.getInputUserIdMapping() != null) {
            apiAuthnSourceAction.setInputUserIdMapping(this.domainToApiInputUserIdMapping(domainAction));
            apiAuthnSourceAction.setUserIdAuthenticated(domainAction.isUserIdAuthenticated());
        }
        AttributeRuleTranslator attributeRuleTranslator = new AttributeRuleTranslator();
        if (domainAction.getAttributeRules() != null && !domainAction.getAttributeRules().isEmpty()) {
            ArrayList<com.pingidentity.admin.api.model.AttributeRule> apiAttributeRules = new ArrayList<com.pingidentity.admin.api.model.AttributeRule>();
            for (AttributeRule domainAttrRule : domainAction.getAttributeRules()) {
                com.pingidentity.admin.api.model.AttributeRule apiAttrRule = attributeRuleTranslator.domainToApi(domainAttrRule);
                apiAttributeRules.add(apiAttrRule);
            }
            AttributeRules attributeRuleItems = new AttributeRules();
            attributeRuleItems.setItems(apiAttributeRules);
            attributeRuleItems.setFallbackToSuccess(domainAction.isFallbackToSuccess());
            apiAuthnSourceAction.setAttributeRules(attributeRuleItems);
        }
        return apiAuthnSourceAction;
    }

    private AttributeFulfillmentValue domainToApiInputUserIdMapping(AuthnSourceAction domainAction) {
        AttributeFulfillmentValue apiInputUserIdMapping = new AttributeFulfillmentValue();
        AttrMappingValue domainInputUserIdMapping = domainAction.getInputUserIdMapping();
        com.pingidentity.admin.api.model.SourceType apiSourceType = com.pingidentity.admin.api.model.SourceType.getApiSourceTypeFromDomainSourceType(domainInputUserIdMapping.getType());
        String apiValue = domainInputUserIdMapping.getValue();
        apiInputUserIdMapping.setSource(new SourceTypeIdKey(apiSourceType, domainInputUserIdMapping.getAttributeSourceId()));
        apiInputUserIdMapping.setValue(apiValue);
        return apiInputUserIdMapping;
    }

    @Override
    public AuthnSelectionAction apiToDomain(AuthnSourcePolicyAction apiAction) {
        AuthnSourceKey domainAuthnSourceKey = new AuthenticationSourceTranslator().apiToDomain(apiAction.getAuthenticationSource());
        AuthnSourceAction domainAction = new AuthnSourceAction(domainAuthnSourceKey);
        if (apiAction.getInputUserIdMapping() == null) {
            domainAction.setUserIdAuthenticated(false);
        } else {
            AttrMappingValue attrMappingValue = this.apiToDomainInputUserIdMapping(apiAction);
            domainAction.setInputUserIdMapping(attrMappingValue);
            if (apiAction.getUserIdAuthenticated() == null) {
                domainAction.setUserIdAuthenticated(false);
            } else {
                domainAction.setUserIdAuthenticated(apiAction.getUserIdAuthenticated().booleanValue());
            }
        }
        AttributeRules attributeRules = apiAction.getAttributeRules();
        if (attributeRules != null && attributeRules.getItems() != null && !attributeRules.getItems().isEmpty()) {
            ArrayList<AttributeRule> domainAttrRulesList = new ArrayList<AttributeRule>();
            for (com.pingidentity.admin.api.model.AttributeRule apiAttributeRule : attributeRules.getItems()) {
                AttributeRule domainAttrRule = new AttributeRule();
                if (apiAttributeRule.getAttributeSource() != null) {
                    com.pingidentity.admin.api.model.SourceType apiSourceType = apiAttributeRule.getAttributeSource().getType();
                    domainAttrRule.setAuthenticationSourceType(apiSourceType.getCorrespondingDomainSourceType());
                    String sourceId = this.apiToDomainSourceId(apiSourceType, apiAttributeRule.getAttributeSource().getId());
                    domainAttrRule.setAuthenticationSourceId(sourceId);
                } else {
                    if (AuthnSourceKey.AuthnSourceType.ADAPTER.equals((Object)domainAuthnSourceKey.getType())) {
                        domainAttrRule.setAuthenticationSourceType(SourceType.ADAPTER);
                    } else if (AuthnSourceKey.AuthnSourceType.IDP_CONN.equals((Object)domainAuthnSourceKey.getType())) {
                        domainAttrRule.setAuthenticationSourceType(SourceType.IDP_CONNECTION);
                    }
                    domainAttrRule.setAuthenticationSourceId(domainAuthnSourceKey.getId());
                }
                domainAttrRule.setAttribute(apiAttributeRule.getAttributeName());
                domainAttrRule.setCondition(apiAttributeRule.getCondition());
                domainAttrRule.setExpectedValue(apiAttributeRule.getExpectedValue());
                domainAttrRule.setExpression(apiAttributeRule.getExpression());
                domainAttrRule.setResult(apiAttributeRule.getResult());
                domainAttrRulesList.add(domainAttrRule);
            }
            domainAction.setAttributeRules(domainAttrRulesList);
            domainAction.setFallbackToSuccess(attributeRules.isFallbackToSuccess());
        }
        super.apiToDomain(apiAction, domainAction);
        return domainAction;
    }

    private AttrMappingValue apiToDomainInputUserIdMapping(AuthnSourcePolicyAction apiAction) {
        AttributeFulfillmentValue apiInputUserIdMapping = apiAction.getInputUserIdMapping();
        com.pingidentity.admin.api.model.SourceType sourceType = apiInputUserIdMapping.getSource().getType();
        String strValue = apiInputUserIdMapping.getValue();
        String attrSourceId = this.apiToDomainSourceId(sourceType, apiInputUserIdMapping.getSource().getId());
        SourceType domainSourceType = sourceType.getCorrespondingDomainSourceType();
        return new AttrMappingValue(domainSourceType, strValue, null, attrSourceId);
    }

    private String apiToDomainSourceId(com.pingidentity.admin.api.model.SourceType apiSourceType, String sourceId) {
        if (com.pingidentity.admin.api.model.SourceType.INPUTS.equals((Object)apiSourceType)) {
            return "Inputs";
        }
        return sourceId;
    }
}

