/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ArtifactResolverLocation;
import com.pingidentity.admin.api.model.ArtifactSettings;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.SloServiceEndpoint;
import com.pingidentity.pf.admin.rest.translator.MessageCustomizationHookTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.domain.trans.DomainTranslator;

public abstract class BaseBrowserSsoTranslator {
    MessageCustomizationHookTranslator messageCutomisationHookTranslator = new MessageCustomizationHookTranslator();

    protected void apiToDomain(List<ProtocolMessageCustomization> messageCustomizations, Map<String, MessageCustomization> messageCustomizationHooks) {
        this.messageCutomisationHookTranslator.apiToDomain(messageCustomizations, messageCustomizationHooks);
    }

    protected void domainToApi(Map<String, MessageCustomization> messageCustomizationHooks, List<ProtocolMessageCustomization> messageCustomizations) {
        this.messageCutomisationHookTranslator.domainToApi(messageCustomizationHooks, messageCustomizations);
    }

    protected void domainToApi(List<UrlWhitelistEntry> redirectValidationWhitelist, BaseBrowserSso browserSso) {
        if (redirectValidationWhitelist != null && redirectValidationWhitelist.size() > 0) {
            ArrayList<com.pingidentity.admin.api.model.UrlWhitelistEntry> whitelistEntries = new ArrayList<com.pingidentity.admin.api.model.UrlWhitelistEntry>();
            for (UrlWhitelistEntry entry : redirectValidationWhitelist) {
                com.pingidentity.admin.api.model.UrlWhitelistEntry whitelistEntry = new com.pingidentity.admin.api.model.UrlWhitelistEntry();
                whitelistEntry.setRequireHttps(entry.isRequireHttps());
                whitelistEntry.setValidDomain(entry.getValidDomain());
                whitelistEntry.setValidPath(entry.getValidPath());
                whitelistEntry.setAllowQueryAndFragment(entry.isAllowQueryAndFragment());
                whitelistEntries.add(whitelistEntry);
            }
            browserSso.setUrlWhitelistEntries(whitelistEntries);
        } else {
            browserSso.setUrlWhitelistEntries(null);
        }
    }

    protected void apiToDomain(List<com.pingidentity.admin.api.model.UrlWhitelistEntry> urlWhitelistEntries, ConnectionBase domainConn) {
        if (urlWhitelistEntries != null && urlWhitelistEntries.size() > 0) {
            ArrayList<UrlWhitelistEntry> domainUrlWhiteListEntries = new ArrayList<UrlWhitelistEntry>();
            for (com.pingidentity.admin.api.model.UrlWhitelistEntry entry : urlWhitelistEntries) {
                UrlWhitelistEntry domainEntry = new UrlWhitelistEntry();
                domainEntry.setValidPath(entry.getValidPath());
                domainEntry.setValidDomain(entry.getValidDomain());
                domainEntry.setRequireHttps(entry.isRequireHttps());
                domainEntry.setAllowQueryAndFragment(entry.isAllowQueryAndFragment());
                domainUrlWhiteListEntries.add(domainEntry);
            }
            domainConn.setRedirectValidationWhitelist(domainUrlWhiteListEntries);
        }
    }

    protected void domainToApiArtifact(ConnectionBase domainConn, BaseBrowserSso browserSso) {
        ArtifactSettings artifact = new ArtifactSettings();
        boolean addArtifact = false;
        if (domainConn.isArtifactSsoSloUsed()) {
            artifact.setLifetime(domainConn.getArtifactTimeoutSeconds());
            addArtifact = true;
        }
        if (domainConn.isInboundArtifact()) {
            ArrayList<ArtifactResolverLocation> resolverLocations = new ArrayList<ArtifactResolverLocation>();
            IndexedEndpoints artifactResolutionServices = domainConn.getArtifactResolutionServices();
            for (Map.Entry entry : artifactResolutionServices.getEndpointsMap().entrySet()) {
                ArtifactResolverLocation resolverLocation = new ArtifactResolverLocation();
                if (domainConn.getProtocol() == Protocol.SAML10 || domainConn.getProtocol() == Protocol.SAML11) {
                    resolverLocation.setIndex(null);
                } else {
                    resolverLocation.setIndex((Integer)entry.getKey());
                }
                resolverLocation.setUrl(((Endpoint)entry.getValue()).getLocation());
                resolverLocations.add(resolverLocation);
                addArtifact = true;
            }
            artifact.setResolverLocations(resolverLocations);
        }
        if (addArtifact) {
            if (StringUtils.isNotBlank((String)domainConn.getSourceIdString())) {
                artifact.setSourceId(domainConn.getSourceIdString());
            }
            browserSso.setArtifact(artifact);
        }
    }

    protected void apiToDomain(Set<Binding> apiBindings, IncomingBindings domainBindings) {
        if (apiBindings != null) {
            domainBindings.setArtifactBinding(apiBindings.contains((Object)Binding.ARTIFACT));
            domainBindings.setRedirectBinding(apiBindings.contains((Object)Binding.REDIRECT));
            domainBindings.setPostBinding(apiBindings.contains((Object)Binding.POST));
            domainBindings.setSoapBinding(apiBindings.contains((Object)Binding.SOAP));
        } else {
            domainBindings.setArtifactBinding(false);
            domainBindings.setRedirectBinding(false);
            domainBindings.setPostBinding(false);
            domainBindings.setSoapBinding(false);
        }
    }

    protected void domainToApi(IncomingBindings domainBindings, Set<Binding> apiBindings) {
        if (domainBindings.getArtifactBinding()) {
            apiBindings.add(Binding.ARTIFACT);
        }
        if (domainBindings.getPostBinding()) {
            apiBindings.add(Binding.POST);
        }
        if (domainBindings.getRedirectBinding()) {
            apiBindings.add(Binding.REDIRECT);
        }
        if (domainBindings.getSoapBinding()) {
            apiBindings.add(Binding.SOAP);
        }
    }

    protected void apiToDomainArtifact(BaseBrowserSso browserSso, ConnectionBase domainConn) {
        if (browserSso.getArtifact() == null) {
            return;
        }
        if (browserSso.isArtifactSsoSloUsed()) {
            domainConn.setArtifactTimeoutSeconds(browserSso.getArtifact().getLifetime().intValue());
        }
        if (browserSso.isInboundArtifact()) {
            IndexedEndpoints endpoints = new IndexedEndpoints();
            for (ArtifactResolverLocation location : browserSso.getArtifact().getResolverLocations()) {
                DomainTranslator domainTranslator = DomainTranslator.getTranslator((Protocol)domainConn.getProtocol());
                String soapUri = domainTranslator.toBindingUri("SOAP");
                Integer index = location.getIndex();
                if (com.pingidentity.admin.api.model.Protocol.isSaml1x(browserSso.getProtocol())) {
                    index = 0;
                }
                Endpoint endpoint = new Endpoint(soapUri, location.getUrl());
                endpoints.setEndpoint(index.intValue(), endpoint);
            }
            domainConn.setArtifactResolutionServices(endpoints);
            if (StringUtils.isNotBlank((String)browserSso.getArtifact().getSourceId())) {
                domainConn.setSourceIdString(browserSso.getArtifact().getSourceId());
            }
        }
    }

    protected void apiToDomain(Set<Profile> apiProfiles, EnabledProfiles domainProfiles) {
        domainProfiles.setIdpInitiatedSSOEnabled(apiProfiles.contains((Object)Profile.IDP_INITIATED_SSO));
        domainProfiles.setSpInitiatedSSOEnabled(apiProfiles.contains((Object)Profile.SP_INITIATED_SSO));
        domainProfiles.setIdpInitiatedSLOEnabled(apiProfiles.contains((Object)Profile.IDP_INITIATED_SLO));
        domainProfiles.setSpInitiatedSLOEnabled(apiProfiles.contains((Object)Profile.SP_INITIATED_SLO));
    }

    protected void domainToApi(EnabledProfiles domainProfiles, Set<Profile> apiProfiles) {
        if (domainProfiles.isIdpInitiatedSSOEnabled()) {
            apiProfiles.add(Profile.IDP_INITIATED_SSO);
        }
        if (domainProfiles.isSpInitiatedSSOEnabled()) {
            apiProfiles.add(Profile.SP_INITIATED_SSO);
        }
        if (domainProfiles.isIdpInitiatedSLOEnabled()) {
            apiProfiles.add(Profile.IDP_INITIATED_SLO);
        }
        if (domainProfiles.isSpInitiatedSLOEnabled()) {
            apiProfiles.add(Profile.SP_INITIATED_SLO);
        }
    }

    protected void domainToApi(EndpointGroup domainSloEndpointGroup, Protocol protocol, BaseBrowserSso spBrowserSso) {
        if (Protocol.SAML20 != protocol) {
            return;
        }
        LinkedList<SloServiceEndpoint> sloServiceEndpoints = new LinkedList<SloServiceEndpoint>();
        DomainTranslator bindingTranslator = DomainTranslator.getTranslator((Protocol)protocol);
        for (Endpoint endpoint : domainSloEndpointGroup.getEndpoints()) {
            String bindingUri = endpoint.getBinding();
            String bindingName = bindingTranslator.toBindingGuiName(bindingUri);
            Binding bindingModel = Binding.fromGuiName(bindingName);
            if (bindingModel == null) continue;
            SloServiceEndpoint sloServiceEndpoint = new SloServiceEndpoint();
            sloServiceEndpoint.setBinding(bindingModel);
            sloServiceEndpoint.setUrl(endpoint.getLocation());
            if (endpoint.hasResponseLocation()) {
                sloServiceEndpoint.setResponseUrl(endpoint.getResponseLocation());
            }
            sloServiceEndpoints.add(sloServiceEndpoint);
        }
        if (!sloServiceEndpoints.isEmpty()) {
            spBrowserSso.setSloServiceEndpoints(sloServiceEndpoints);
        }
    }

    protected void apiToDomain(List<SloServiceEndpoint> sloEndpoints, Protocol protocol, EndpointGroup sloServices) {
        if (Protocol.SAML20 != protocol || sloEndpoints == null) {
            return;
        }
        DomainTranslator bindingTranslator = DomainTranslator.getTranslator((Protocol)protocol);
        ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
        for (SloServiceEndpoint item : sloEndpoints) {
            String newBinding = bindingTranslator.toBindingUri(item.getBinding().getGuiName());
            if (StringUtils.isBlank((String)item.getResponseUrl())) {
                allEndpoints.add(new Endpoint(newBinding, item.getUrl()));
                continue;
            }
            allEndpoints.add(new Endpoint(newBinding, item.getUrl(), item.getResponseUrl()));
        }
        sloServices.setEndpoints(allEndpoints);
    }

    protected boolean isSaml(com.pingidentity.admin.api.model.Protocol protocol) {
        return protocol == com.pingidentity.admin.api.model.Protocol.SAML10 || protocol == com.pingidentity.admin.api.model.Protocol.SAML11 || protocol == com.pingidentity.admin.api.model.Protocol.SAML20;
    }

    protected void populateEnabledProfilesAndIncomingBindings(BaseBrowserSso browserSso, Role role) {
        if (browserSso.getEnabledProfiles() == null) {
            browserSso.setEnabledProfiles(new HashSet<Profile>());
        }
        if (com.pingidentity.admin.api.model.Protocol.isSaml1x(browserSso.getProtocol()) && role == Role.IDP) {
            browserSso.getEnabledProfiles().add(Profile.IDP_INITIATED_SSO);
        }
        if (browserSso.getProtocol() == com.pingidentity.admin.api.model.Protocol.WSFED || role == Role.SP && com.pingidentity.admin.api.model.Protocol.isSaml1x(browserSso.getProtocol())) {
            browserSso.getEnabledProfiles().add(Profile.IDP_INITIATED_SSO);
            browserSso.getEnabledProfiles().add(Profile.SP_INITIATED_SSO);
            browserSso.getEnabledProfiles().add(Profile.IDP_INITIATED_SLO);
            browserSso.getEnabledProfiles().add(Profile.SP_INITIATED_SLO);
            if (browserSso.getIncomingBindings() == null) {
                browserSso.setIncomingBindings(new HashSet<Binding>());
            }
            browserSso.getIncomingBindings().add(Binding.POST);
            browserSso.getIncomingBindings().add(Binding.ARTIFACT);
            browserSso.getIncomingBindings().add(Binding.SOAP);
            browserSso.getIncomingBindings().add(Binding.REDIRECT);
        } else if (browserSso.getProtocol() == com.pingidentity.admin.api.model.Protocol.OIDC) {
            browserSso.getEnabledProfiles().add(Profile.IDP_INITIATED_SSO);
            browserSso.getEnabledProfiles().add(Profile.SP_INITIATED_SSO);
            if (browserSso.getIncomingBindings() == null) {
                browserSso.setIncomingBindings(new HashSet<Binding>());
            }
            browserSso.getIncomingBindings().add(Binding.POST);
            browserSso.getIncomingBindings().add(Binding.ARTIFACT);
            browserSso.getIncomingBindings().add(Binding.SOAP);
            browserSso.getIncomingBindings().add(Binding.REDIRECT);
        }
    }

    protected boolean isArtifactEnabled(BaseBrowserSso browserSso) {
        return browserSso.getArtifact() != null || browserSso.isArtifactSsoSloUsed() || browserSso.isInboundArtifact();
    }

    protected boolean isArtifactEnabled(ConnectionBase domainConn) {
        return domainConn.isArtifactSsoSloUsed() || domainConn.isInboundArtifact();
    }
}

