/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.CertView;
import com.pingidentity.admin.api.model.CryptoProvider;
import com.pingidentity.admin.api.model.KeyPairRotationSettings;
import com.pingidentity.admin.api.model.KeyPairView;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CertTranslator {
    private static final Log log = LogFactory.getLog(CertTranslator.class);
    private DSignRotationSettingsManager rotationManager = MgmtFactory.getDSignRotationSettingsManager();

    public CertView domainToApi(Cert domainCert, boolean setCertId) {
        CertView certView = new CertView();
        this.domainToApi(domainCert, certView);
        if (setCertId) {
            certView.setId(domainCert.getAlias());
        }
        return certView;
    }

    public CertView domainToApi(Cert domainCert) {
        CertView certView = new CertView();
        this.domainToApi(domainCert, certView);
        certView.setId(domainCert.getAlias());
        return certView;
    }

    public KeyPairView domainToApi(PkCert domainCert) {
        KeyPairView keyPairView = new KeyPairView();
        this.domainToApi((Cert)domainCert, keyPairView);
        keyPairView.setId(domainCert.getAlias());
        keyPairView.setRotationSettings(this.domainToApiRotationKey((Cert)domainCert));
        return keyPairView;
    }

    private void domainToApi(Cert domainCert, CertView certView) {
        X509Certificate x509 = domainCert.getX509Certificate();
        certView.setIssuerDN(x509.getIssuerDN().getName());
        certView.setSubjectDN(x509.getSubjectDN().getName());
        try {
            certView.setSubjectAlternativeNames(domainCert.getX509CertificateSubjectAlternativeNames());
        }
        catch (CertificateParsingException e) {
            log.debug((Object)"An error occurred when extracting subject alternative names from certificate: ", (Throwable)e);
            certView.setSubjectAlternativeNames(Collections.emptyList());
        }
        certView.setSerialNumber(domainCert.getX509Certificate().getSerialNumber().toString());
        certView.setValidFrom(x509.getNotBefore());
        certView.setExpires(x509.getNotAfter());
        certView.setKeyAlgorithm(domainCert.getPublicKeyAlgorithm());
        Integer keySize = domainCert.getPublicKeySize();
        if (keySize != null) {
            certView.setKeySize(keySize);
        }
        certView.setVersion(x509.getVersion());
        certView.setStatus(CertificateHelper.getValidity((Cert)domainCert));
        certView.setSignatureAlgorithm(x509.getSigAlgName().replaceAll("WITH", "with"));
        certView.setSha1Fingerprint(domainCert.getFingerPrint(HashAlgorithm.SHA1).toUpperCase());
        certView.setSha256Fingerprint(domainCert.getFingerPrint(HashAlgorithm.SHA256).toUpperCase());
        CryptoProvider cryptoProvider = null;
        if (domainCert.isStoredOnHSM() != null) {
            cryptoProvider = domainCert.isStoredOnHSM() != false ? CryptoProvider.HSM : CryptoProvider.LOCAL;
        }
        certView.setCryptoProvider(cryptoProvider);
    }

    public KeyPairRotationSettings domainToApiRotationKey(Cert domainCert) {
        DSignRotationSetting rotationSetting;
        if (CertificateHelper.isSelfSigned((X509Certificate)domainCert.getX509Certificate()) && this.rotationManager != null && (rotationSetting = this.rotationManager.getRotationSetting(domainCert.getAlias())) != null && rotationSetting.isEnableCertRotation()) {
            KeyPairRotationSettings apiRotationSettings = new KeyPairRotationSettings();
            apiRotationSettings.setActivationBufferDays(rotationSetting.getActivationBufferDays().intValue());
            apiRotationSettings.setCreationBufferDays(rotationSetting.getRotationBufferDays().intValue());
            apiRotationSettings.setKeySize(rotationSetting.getKeySize());
            apiRotationSettings.setKeyAlgorithm(rotationSetting.getKeyAlgorithm());
            apiRotationSettings.setValidDays(rotationSetting.getValidityPeriodDays());
            apiRotationSettings.setSignatureAlgorithm(rotationSetting.getSignatureAlgorithm());
            return apiRotationSettings;
        }
        return null;
    }

    public DSignRotationSetting apiToDomain(Cert pkCert, KeyPairRotationSettings keyPairRotationSettings) {
        DSignRotationSetting rotationSetting = new DSignRotationSetting(pkCert.getAlias(), true);
        rotationSetting.setActivationBufferMins(keyPairRotationSettings.getActivationBufferDays() * 24 * 60);
        rotationSetting.setKeySize(keyPairRotationSettings.getKeySize().intValue());
        rotationSetting.setRotationBufferMins(keyPairRotationSettings.getCreationBufferDays() * 24 * 60);
        rotationSetting.setSignatureAlgorithm(keyPairRotationSettings.getSignatureAlgorithm());
        rotationSetting.setValidityPeriodDays(keyPairRotationSettings.getValidDays().intValue());
        rotationSetting.setKeyAlgorithm(keyPairRotationSettings.getKeyAlgorithm());
        return rotationSetting;
    }
}

