/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.Channel;
import com.pingidentity.admin.api.model.ChannelSource;
import com.pingidentity.admin.api.model.SaasAttributeMapping;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.validator.SaasAttributeMappingsValidator;
import com.pingidentity.pf.admin.rest.translator.ChannelSourceTranslator;
import com.pingidentity.pf.admin.rest.translator.SaasAttributeMappingTranslator;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ChannelTranslator {
    private final ChannelSourceTranslator channelSourceTranslator = new ChannelSourceTranslator();
    private final SaasAttributeMappingTranslator identityMappingTranslator = new SaasAttributeMappingTranslator();

    ChannelTranslator() {
    }

    Channel domainToApi(com.pingidentity.provisioner.domain.Channel domainChannel) {
        Channel apiChannel = new Channel();
        ChannelSource channelSource = this.channelSourceTranslator.domainToApi(domainChannel.getSource());
        apiChannel.setChannelSource(channelSource);
        ArrayList<SaasAttributeMapping> apiIdentityMappingFields = new ArrayList<SaasAttributeMapping>();
        for (IdentityMappingField field : domainChannel.getIdentityMapping()) {
            SaasAttributeMapping apiField = this.identityMappingTranslator.domainToApi(field);
            apiIdentityMappingFields.add(apiField);
        }
        apiChannel.setAttributeMapping(apiIdentityMappingFields);
        apiChannel.setName(domainChannel.getName());
        apiChannel.setMaxThreads(domainChannel.getMaxThreads());
        apiChannel.setTimeout(domainChannel.getTimeout() == 0 ? 60 : domainChannel.getTimeout());
        apiChannel.setActive(domainChannel.isActive());
        return apiChannel;
    }

    void apiToDomain(Channel apiChannel, com.pingidentity.provisioner.domain.Channel domainChannel, String pluginType, List<SchemaAttribute> schemaAttributes) {
        com.pingidentity.provisioner.domain.source.ChannelSource channelSource = new com.pingidentity.provisioner.domain.source.ChannelSource();
        this.channelSourceTranslator.apiToDomain(apiChannel.getChannelSource(), channelSource);
        domainChannel.setSource(channelSource);
        ArrayList<IdentityMappingField> domainIdentityMappingFields = new ArrayList<IdentityMappingField>();
        SaasPluginManager saasManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin saasPlugin = saasManager.getPluginInstance(pluginType);
        HashSet<String> mappedAttributeNames = new HashSet<String>();
        try {
            List fieldInfos = saasPlugin.getFieldsInfo();
            for (FieldInfo fieldInfo : fieldInfos) {
                IdentityMappingField field = new IdentityMappingField(fieldInfo.getCode());
                for (SaasAttributeMapping apiField : apiChannel.getAttributeMapping()) {
                    if (!fieldInfo.getCode().equals(apiField.getFieldName())) continue;
                    mappedAttributeNames.add(fieldInfo.getCode());
                    this.identityMappingTranslator.apiToDomain(apiField, field, fieldInfo);
                }
                if (!mappedAttributeNames.contains(fieldInfo.getCode())) {
                    FieldConfig fieldConfig = new FieldConfig();
                    field.setFieldName(fieldInfo.getCode());
                    field.setFieldInfo(fieldInfo);
                    field.setFieldConfig(fieldConfig);
                }
                domainIdentityMappingFields.add(field);
            }
            this.apiToDomainCustomScimAttributes(apiChannel, schemaAttributes, mappedAttributeNames, domainIdentityMappingFields);
            domainChannel.setidentityMapping(domainIdentityMappingFields);
            domainChannel.setName(apiChannel.getName());
            domainChannel.setMaxThreads(apiChannel.getMaxThreads());
            domainChannel.setTimeout(apiChannel.getTimeout());
            domainChannel.setActive(apiChannel.isActive());
        }
        catch (SaasException saasException) {
            // empty catch block
        }
    }

    private void apiToDomainCustomScimAttributes(Channel apiChannel, List<SchemaAttribute> schemaAttributes, Set<String> mappedAttributeNames, List<IdentityMappingField> domainMappings) {
        if (mappedAttributeNames == null) {
            return;
        }
        block0: for (SaasAttributeMapping apiField : apiChannel.getAttributeMapping()) {
            if (mappedAttributeNames.contains(apiField.getFieldName())) continue;
            for (SchemaAttribute schemaAttribute : schemaAttributes) {
                List<String> attributeNames = SaasAttributeMappingsValidator.getAttributeName(schemaAttribute);
                boolean translated = false;
                for (String attributeName : attributeNames) {
                    if (!apiField.getFieldName().equals(attributeName)) continue;
                    IdentityMappingField field = new IdentityMappingField(attributeName);
                    FieldInfo fieldInfo = new FieldInfo(attributeName, attributeName);
                    fieldInfo.setAttributeGroup(true);
                    fieldInfo.setMultiValue(schemaAttribute.isMultiValued().booleanValue());
                    this.identityMappingTranslator.apiToDomain(apiField, field, fieldInfo);
                    domainMappings.add(field);
                    translated = true;
                    mappedAttributeNames.add(attributeName);
                    break;
                }
                if (!translated) continue;
                continue block0;
            }
        }
    }
}

