/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ConfigurationEncryptionKey;
import com.pingidentity.admin.api.model.ConfigurationEncryptionKeys;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public class ConfigurationEncryptionKeysTranslator {
    public static ConfigurationEncryptionKeys domainToApi(JsonWebKeySet keySet) {
        ArrayList<ConfigurationEncryptionKey> apiKeyList = new ArrayList<ConfigurationEncryptionKey>();
        List keys = keySet.getJsonWebKeys();
        for (JsonWebKey domainKey : keys) {
            Date creationDate;
            Long dateValue = (Long)domainKey.getOtherParameterValue("creationDate", Long.class);
            if (dateValue != null) {
                Instant creationInstant = Instant.ofEpochSecond(dateValue);
                creationDate = Date.from(creationInstant);
            } else {
                creationDate = null;
            }
            ConfigurationEncryptionKey apiKey = new ConfigurationEncryptionKey(domainKey.getKeyId(), creationDate);
            apiKeyList.add(apiKey);
        }
        ConfigurationEncryptionKeys configurationEncryptionKeys = new ConfigurationEncryptionKeys(apiKeyList);
        return configurationEncryptionKeys;
    }
}

