/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.CertView;
import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.X509File;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.admin.rest.translator.CertTranslator;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.ConnectionCerts;

public class ConnectionCertsTranslator {
    private static final Log log = LogFactory.getLog(ConnectionCertsTranslator.class);
    private final CertTranslator certTranslator = new CertTranslator();

    public List<ConnectionCert> domainToApi(ConnectionCerts domainCerts) {
        ArrayList<ConnectionCert> apiCerts = new ArrayList<ConnectionCert>();
        List activeVerificationCerts = domainCerts.getActiveVerificationCerts();
        ArrayList inactiveVerificationCerts = new ArrayList(domainCerts.getAllVerificationCerts());
        inactiveVerificationCerts.removeAll(activeVerificationCerts);
        for (int i = 0; i < activeVerificationCerts.size(); ++i) {
            ConnectionCert apiCert = this.domainToApi((Cert)activeVerificationCerts.get(i), i == 0 ? CertStatus.PRIMARY : (i == 1 ? CertStatus.SECONDARY : CertStatus.ACTIVE));
            apiCerts.add(apiCert);
        }
        for (Cert inactiveVerificationCert : inactiveVerificationCerts) {
            ConnectionCert apiCert = this.domainToApi(inactiveVerificationCert, CertStatus.INACTIVE);
            apiCerts.add(apiCert);
        }
        return apiCerts;
    }

    public ConnectionCert domainToApi(Cert domainCert, CertStatus certStatus, boolean isEncryptionCert) {
        ConnectionCert apiCert = new ConnectionCert();
        apiCert.setPrimaryVerificationCert(certStatus == CertStatus.PRIMARY);
        apiCert.setSecondaryVerificationCert(certStatus == CertStatus.SECONDARY);
        apiCert.setActiveVerificationCert(certStatus != CertStatus.INACTIVE);
        apiCert.setEncryptionCert(isEncryptionCert);
        CertView certView = this.certTranslator.domainToApi(domainCert);
        apiCert.setCertView(certView);
        X509File data = new X509File();
        try {
            data.setFileData(domainCert.exportCert());
            data.setId(domainCert.getId());
            data.setCryptoProvider(certView.getCryptoProvider());
        }
        catch (CertificateEncodingException e) {
            String message = "Error exporting data for certificate with alias " + domainCert.getAlias();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        apiCert.setX509File(data);
        return apiCert;
    }

    public ConnectionCert domainToApi(Cert domainCert, CertStatus certStatus) {
        return this.domainToApi(domainCert, certStatus, false);
    }

    public ConnectionCert domainToApiEncryptionCert(Cert domainCert) {
        return this.domainToApi(domainCert, CertStatus.INACTIVE, true);
    }

    public CertStatus getCertStatus(int index) {
        CertStatus status = CertStatus.ACTIVE;
        switch (index) {
            case -1: {
                status = CertStatus.INACTIVE;
                break;
            }
            case 0: {
                status = CertStatus.PRIMARY;
                break;
            }
            case 1: {
                status = CertStatus.SECONDARY;
                break;
            }
        }
        return status;
    }

    public static enum CertStatus {
        PRIMARY,
        SECONDARY,
        ACTIVE,
        INACTIVE;

    }
}

