/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SigningSettings;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.admin.api.validator.EncryptionSettingsValidator;
import com.pingidentity.admin.api.validator.VerificationCertValidator;
import com.pingidentity.admin.api.validator.VerificationSettingsValidator;
import com.pingidentity.crypto.EncryptAlgorithms;
import com.pingidentity.pf.admin.rest.translator.ConnectionCertsTranslator;
import com.pingidentity.pf.admin.rest.translator.InboundBackChannelAuthTranslator;
import com.pingidentity.pf.admin.rest.translator.OutboundBackChannelAuthTranslator;
import com.pingidentity.pf.admin.rest.translator.SigningSettingsTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import java.util.List;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EncryptionPolicy;
import org.sourceid.saml20.domain.EncryptionSettings;

public class CredentialsTranslator {
    private final ConnectionCertsTranslator certsTranslator;
    private ValidatorRegistry validatorRegistry;
    private SigningSettingsTranslator signingSettingsTranslator = new SigningSettingsTranslator();

    public CredentialsTranslator() {
        this.certsTranslator = new ConnectionCertsTranslator();
    }

    public CredentialsTranslator(ValidatorRegistry registry) {
        this.certsTranslator = new ConnectionCertsTranslator();
        this.validatorRegistry = registry;
    }

    public void apiToDomain(Connection apiConn, ConnectionBase domainConn) {
        if (apiConn.getCredentials() != null) {
            EncryptionSettingsValidator encryptionValidator;
            ConnectionCredentials connCreds = apiConn.getCredentials();
            domainConn.setDsigVerificationExpectedSubjectDN(connCreds.getVerificationSubjectDN());
            domainConn.setDsigVerificationExpectedIssuerDN(connCreds.getVerificationIssuerDN());
            if (this.validatorRegistry == null) {
                throw new RuntimeException("For api-to-domain translation, you must provide a ValidatorRegistry via the constructor");
            }
            VerificationCertValidator certValidator = (VerificationCertValidator)this.validatorRegistry.getValidator(VerificationCertValidator.class);
            if (certValidator == null) {
                throw new RuntimeException("No validator is registered for type " + VerificationSettingsValidator.class);
            }
            if (certValidator.getDomainCerts() != null) {
                domainConn.setDsigVerificationCerts(certValidator.getDomainCerts());
            }
            if (connCreds.getSigningSettings() != null) {
                this.signingSettingsTranslator.apiToDomain(connCreds.getSigningSettings(), domainConn, this.isWSFedConnection(apiConn), this.getApiTokenType(apiConn));
            }
            if (connCreds.getDecryptionKeyPairRef() != null) {
                domainConn.getEncryptionSettings().setDecryptionKeyAlias(connCreds.getDecryptionKeyPairRef().getId());
            }
            if (connCreds.getSecondaryDecryptionKeyPairRef() != null) {
                domainConn.getEncryptionSettings().setSecondaryDecryptionKeyAlias(connCreds.getSecondaryDecryptionKeyPairRef().getId());
            }
            if ((encryptionValidator = (EncryptionSettingsValidator)this.validatorRegistry.getValidator(EncryptionSettingsValidator.class)) != null && encryptionValidator.getConvertedEncryptionCert() != null) {
                domainConn.getEncryptionSettings().setEncryptionCert(encryptionValidator.getConvertedEncryptionCert());
                if (connCreds.getBlockEncryptionAlgorithm() != null) {
                    domainConn.getEncryptionSettings().getEncryptionPolicy().setEncryptionAlgorithm(this.convertDisplayNameToXmlCipher(connCreds.getBlockEncryptionAlgorithm()));
                }
                if (connCreds.getKeyTransportAlgorithm() != null) {
                    domainConn.getEncryptionSettings().getEncryptionPolicy().setKeyTransportAlgorithm(this.convertDisplayNameToXmlCipher(connCreds.getKeyTransportAlgorithm()));
                }
            }
            OutboundBackChannelAuthTranslator outboundTranslator = new OutboundBackChannelAuthTranslator();
            outboundTranslator.apiToDomain(apiConn, domainConn);
            InboundBackChannelAuthTranslator inboundTranslator = new InboundBackChannelAuthTranslator();
            inboundTranslator.apiToDomain(apiConn, domainConn, this.validatorRegistry);
        }
    }

    private WsFedTokenType getApiTokenType(Connection apiConn) {
        if (apiConn.getBrowserSso() != null && apiConn.getBrowserSso() instanceof SpBrowserSso) {
            return ((SpBrowserSso)apiConn.getBrowserSso()).getWsFedTokenType();
        }
        return null;
    }

    private boolean isWSFedConnection(Connection apiConn) {
        return apiConn.getBrowserSso() != null && apiConn.getBrowserSso().getProtocol() == Protocol.WSFED;
    }

    public void domainToApi(ConnectionBase domainConn, Connection apiConn) {
        String href;
        if (domainConn.isOIDCConnection()) {
            return;
        }
        EncryptionSettings domainEncryptionSettings = domainConn.getEncryptionSettings();
        String primaryDecryptAlias = domainEncryptionSettings.getDecryptionKeyAlias();
        String secondaryDecryptAlias = domainEncryptionSettings.getSecondaryDecryptionKeyAlias();
        ConnectionCredentials credentials = new ConnectionCredentials();
        apiConn.setCredentials(credentials);
        credentials.setVerificationSubjectDN(domainConn.getStringDsigVerificationExpectedSubjectDNas());
        credentials.setVerificationIssuerDN(domainConn.getStringDsigVerificationExpectedIssuerDNas());
        credentials.setCerts(this.certsTranslator.domainToApi(domainConn.getDsigVerificationCerts()));
        if (domainConn.getSigningKeyAlias() != null || domainConn.getSigningKey() != null) {
            SigningSettings signingSettings = this.signingSettingsTranslator.domainToApi(domainConn);
            credentials.setSigningSettings(signingSettings);
        }
        if (primaryDecryptAlias != null) {
            href = ApiUtil.getResourceUrl("/keyPairs/signing", primaryDecryptAlias);
            credentials.setDecryptionKeyPairRef(new ResourceLink(primaryDecryptAlias, href));
        }
        if (secondaryDecryptAlias != null) {
            href = ApiUtil.getResourceUrl("/keyPairs/signing", secondaryDecryptAlias);
            credentials.setSecondaryDecryptionKeyPairRef(new ResourceLink(secondaryDecryptAlias, href));
        }
        OutboundBackChannelAuthTranslator outboundTranslator = new OutboundBackChannelAuthTranslator();
        outboundTranslator.domainToApi(domainConn, credentials);
        InboundBackChannelAuthTranslator inboundTranslator = new InboundBackChannelAuthTranslator();
        inboundTranslator.domainToApi(domainConn, credentials);
        if (domainConn.getEncryptionSettings().getEncryptionPolicy() != null) {
            EncryptionPolicy policy = domainConn.getEncryptionSettings().getEncryptionPolicy();
            if (domainConn.getEncryptionSettings().getEncryptionCert() != null) {
                ConnectionCert encryptCert = this.certsTranslator.domainToApiEncryptionCert(domainConn.getEncryptionSettings().getEncryptionCert());
                if (this.isCertAlreadyInList(encryptCert, credentials.getCerts())) {
                    ConnectionCert cert = this.retrieveCertFromList(encryptCert, credentials.getCerts());
                    cert.setEncryptionCert(true);
                } else {
                    credentials.getCerts().add(encryptCert);
                }
                credentials.setKeyTransportAlgorithm(this.convertXmlCipherToDisplayName(policy.getKeyTransportAlgorithm()));
                credentials.setBlockEncryptionAlgorithm(this.convertXmlCipherToDisplayName(policy.getEncryptionAlgorithm()));
            }
        }
    }

    private String convertXmlCipherToDisplayName(String xmlCipher) {
        String alg = null;
        try {
            alg = EncryptAlgorithms.fromXMLCipher((String)xmlCipher).getDisplayName();
        }
        catch (EncryptAlgorithms.AlgorithmNotFoundException algorithmNotFoundException) {
            // empty catch block
        }
        return alg;
    }

    private String convertDisplayNameToXmlCipher(String label) {
        String cipher = null;
        try {
            cipher = EncryptAlgorithms.fromDisplayName((String)label).getMatchingXmlCipher();
        }
        catch (EncryptAlgorithms.AlgorithmNotFoundException algorithmNotFoundException) {
            // empty catch block
        }
        return cipher;
    }

    private ConnectionCert retrieveCertFromList(ConnectionCert cert, List<ConnectionCert> certs) {
        for (ConnectionCert currentCert : certs) {
            if (!currentCert.getCertView().getSerialNumber().equals(cert.getCertView().getSerialNumber())) continue;
            return currentCert;
        }
        return null;
    }

    private boolean isCertAlreadyInList(ConnectionCert encryptCert, List<ConnectionCert> certs) {
        return this.retrieveCertFromList(encryptCert, certs) != null;
    }
}

