/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeRules;
import com.pingidentity.admin.api.model.FragmentPolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.pf.admin.rest.translator.AttributeRuleTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicySelectionActionTranslator;
import com.pingidentity.pf.admin.rest.translator.FragmentMappingTranslator;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceType;

public class FragmentActionTranslator
extends AuthenticationPolicySelectionActionTranslator<FragmentPolicyAction, FragmentAction> {
    @Override
    public PolicyAction domainToApi(FragmentAction domainAction) {
        FragmentPolicyAction apiFragmentAction = super.domainToApi(new FragmentPolicyAction(), domainAction);
        String fragmentId = domainAction.getFragmentId();
        ResourceLink resourceLink = new ResourceLink();
        resourceLink.setId(fragmentId);
        resourceLink.setLocation(ApiUtil.getResourceUrl("/authenticationPolicies/fragments", fragmentId));
        apiFragmentAction.setFragment(resourceLink);
        AttributeMapping domainMapping = domainAction.getAttributeMapping();
        com.pingidentity.admin.api.model.AttributeMapping apiMapping = new com.pingidentity.admin.api.model.AttributeMapping();
        FragmentMappingTranslator attributeMappingTranslator = new FragmentMappingTranslator();
        if (StringUtils.isEmpty((CharSequence)domainAction.getApcId())) {
            attributeMappingTranslator.domainToApi(domainMapping, apiMapping);
        } else {
            attributeMappingTranslator.domainToApi(domainMapping, apiMapping, domainAction.getAssociatedFragment().getInputContractAllAttributes(), false);
        }
        if (apiMapping.hasAttributeMapping()) {
            apiFragmentAction.setFragmentMapping(apiMapping);
        }
        AttributeRuleTranslator attributeRuleTranslator = new AttributeRuleTranslator();
        if (domainAction.getAttributeRules() != null && !domainAction.getAttributeRules().isEmpty()) {
            ArrayList<com.pingidentity.admin.api.model.AttributeRule> apiAttributeRules = new ArrayList<com.pingidentity.admin.api.model.AttributeRule>();
            for (AttributeRule domainAttrRule : domainAction.getAttributeRules()) {
                com.pingidentity.admin.api.model.AttributeRule apiAttrRule = attributeRuleTranslator.domainToApi(domainAttrRule);
                apiAttributeRules.add(apiAttrRule);
            }
            AttributeRules attributeRuleItems = new AttributeRules();
            attributeRuleItems.setItems(apiAttributeRules);
            attributeRuleItems.setFallbackToSuccess(domainAction.isFallbackToSuccess());
            apiFragmentAction.setAttributeRules(attributeRuleItems);
        }
        return apiFragmentAction;
    }

    @Override
    public AuthnSelectionAction apiToDomain(FragmentPolicyAction apiAction) {
        String fragmentId = apiAction.getFragment().getId();
        FragmentAction domainAction = new FragmentAction(fragmentId);
        super.apiToDomain(apiAction, domainAction);
        com.pingidentity.admin.api.model.AttributeMapping apiMapping = apiAction.getFragmentMapping();
        AttributeMapping domainMapping = new AttributeMapping();
        if (apiMapping != null) {
            FragmentMappingTranslator attributeMappingTranslator = new FragmentMappingTranslator();
            attributeMappingTranslator.apiToDomain(apiMapping, domainMapping);
        }
        domainAction.setAttributeMapping(domainMapping);
        AttributeRules attributeRules = apiAction.getAttributeRules();
        if (attributeRules != null && attributeRules.getItems() != null && !attributeRules.getItems().isEmpty()) {
            ArrayList<AttributeRule> domainAttrRulesList = new ArrayList<AttributeRule>();
            for (com.pingidentity.admin.api.model.AttributeRule apiAttributeRule : attributeRules.getItems()) {
                AttributeRule domainAttrRule = new AttributeRule();
                if (apiAttributeRule.getAttributeSource() != null) {
                    domainAttrRule.setAuthenticationSourceType(apiAttributeRule.getAttributeSource().getType().getCorrespondingDomainSourceType());
                    domainAttrRule.setAuthenticationSourceId(apiAttributeRule.getAttributeSource().getId());
                } else {
                    domainAttrRule.setAuthenticationSourceType(SourceType.FRAGMENT);
                    domainAttrRule.setAuthenticationSourceId(fragmentId);
                }
                domainAttrRule.setAttribute(apiAttributeRule.getAttributeName());
                domainAttrRule.setCondition(apiAttributeRule.getCondition());
                domainAttrRule.setExpectedValue(apiAttributeRule.getExpectedValue());
                domainAttrRule.setExpression(apiAttributeRule.getExpression());
                domainAttrRule.setResult(apiAttributeRule.getResult());
                domainAttrRulesList.add(domainAttrRule);
            }
            domainAction.setAttributeRules(domainAttrRulesList);
            domainAction.setFallbackToSuccess(attributeRules.isFallbackToSuccess());
        }
        return domainAction;
    }
}

