/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AdditionalAllowedEntitiesConfiguration;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ContactInfo;
import com.pingidentity.admin.api.model.Entity;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.OIDCClientCredentials;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.util.DateUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class GeneralInfoTranslator {
    public void apiToDomain(Connection apiConn, ConnectionBase domainConn) {
        VirtualIdentity virtualIdentity;
        domainConn.setId(apiConn.getId());
        domainConn.setEntityId(apiConn.getEntityId());
        domainConn.setName(apiConn.getName());
        List virtualIdentityList = domainConn.getVirtualIdentities();
        if (apiConn.getVirtualEntityIds() != null) {
            for (String virtualEntityId : apiConn.getVirtualEntityIds()) {
                VirtualIdentity virtualIdentity2 = new VirtualIdentity();
                virtualIdentity2.setVirtualEntityId(virtualEntityId, DomainMode.CONFIGTIME);
                virtualIdentityList.add(virtualIdentity2);
            }
        }
        if (apiConn.getDefaultVirtualEntityId() != null) {
            virtualIdentity = new VirtualIdentity();
            virtualIdentity.setVirtualEntityId(apiConn.getDefaultVirtualEntityId(), DomainMode.CONFIGTIME);
            domainConn.setDefaultVirtualIdentity(virtualIdentity);
        } else if (apiConn.getVirtualEntityIds() != null && !apiConn.getVirtualEntityIds().isEmpty()) {
            virtualIdentity = new VirtualIdentity();
            virtualIdentity.setVirtualEntityId(apiConn.getVirtualEntityIds().get(0), DomainMode.CONFIGTIME);
            domainConn.setDefaultVirtualIdentity(virtualIdentity);
        }
        if (!StringUtils.isBlank((String)apiConn.getBaseUrl())) {
            URL baseUrl = this.getUrl(apiConn.getBaseUrl());
            domainConn.setBaseUrl(baseUrl);
        }
        if (apiConn.getContactInfo() != null) {
            org.sourceid.saml20.domain.ContactInfo domainContactInfo = new org.sourceid.saml20.domain.ContactInfo();
            ContactInfo contactInfo = apiConn.getContactInfo();
            domainContactInfo.setCompany(contactInfo.getCompany());
            domainContactInfo.setEmail(contactInfo.getEmail());
            domainContactInfo.setFirstName(contactInfo.getFirstName());
            domainContactInfo.setLastName(contactInfo.getLastName());
            domainContactInfo.setPhone(contactInfo.getPhone());
            domainConn.setContactInfo(domainContactInfo);
        }
        if (domainConn instanceof org.sourceid.saml20.domain.IdpConnection) {
            ((org.sourceid.saml20.domain.IdpConnection)domainConn).setErrorPageMsg(((IdpConnection)apiConn).getErrorPageMsgId());
        }
        if (apiConn.getLoggingMode() != null) {
            domainConn.setLoggingMode(apiConn.getLoggingMode());
        }
        if (apiConn instanceof SpConnection) {
            SpConnection spApiConn = (SpConnection)apiConn;
            org.sourceid.saml20.domain.SpConnection spDomainConn = (org.sourceid.saml20.domain.SpConnection)domainConn;
            spDomainConn.setApplicationName(spApiConn.getApplicationName());
            URL url = this.getUrl(spApiConn.getApplicationIconUrl());
            spDomainConn.setApplicationIconUrl(url);
        } else if (apiConn instanceof IdpConnection) {
            AdditionalAllowedEntitiesConfiguration apiAdditionalAllowedEntitiesConfiguration;
            IdpConnection idpApiConn = (IdpConnection)apiConn;
            OIDCClientCredentials apiOidcClientCredential = idpApiConn.getOidcClientCredentials();
            if (apiOidcClientCredential != null) {
                org.sourceid.saml20.domain.IdpConnection domainIdpConnection = (org.sourceid.saml20.domain.IdpConnection)domainConn;
                if (domainIdpConnection.getOidcSettings() == null) {
                    domainIdpConnection.setOidcSettings(new OIDCSettings());
                }
                domainIdpConnection.getOidcSettings().setClientId(apiOidcClientCredential.getClientId());
                if (StringUtils.isNotBlank((String)apiOidcClientCredential.getClientSecret())) {
                    domainIdpConnection.getOidcSettings().setClientSecret(FieldObfuscator.REAL.obfuscate(apiOidcClientCredential.getClientSecret()));
                } else {
                    domainIdpConnection.getOidcSettings().setClientSecret(apiOidcClientCredential.getEncryptedSecret());
                }
            }
            if ((apiAdditionalAllowedEntitiesConfiguration = idpApiConn.getAdditionalAllowedEntitiesConfiguration()) != null) {
                org.sourceid.saml20.domain.IdpConnection domainIdpConnection = (org.sourceid.saml20.domain.IdpConnection)domainConn;
                domainIdpConnection.setAllowAdditionalEntities(apiAdditionalAllowedEntitiesConfiguration.isAllowAdditionalEntities());
                domainIdpConnection.setAllowAllEntities(apiAdditionalAllowedEntitiesConfiguration.isAllowAllEntities());
                domainIdpConnection.setAdditionalAllowedEntities(apiAdditionalAllowedEntitiesConfiguration.getAdditionalAllowedEntities().stream().map(entity -> new org.sourceid.saml20.domain.Entity(entity.getEntityId(), entity.getEntityDescription())).collect(Collectors.toList()));
            }
        }
        domainConn.setLicenseConnectionGroupAssignment(apiConn.getLicenseConnectionGroup());
    }

    private URL getUrl(String url) {
        try {
            if (url != null) {
                return new URL(url);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + url, e);
        }
        return null;
    }

    public void domainToApi(ConnectionBase domainConn, Connection apiConn) {
        apiConn.setId(domainConn.getId());
        apiConn.setEntityId(domainConn.getEntityId());
        apiConn.setName(domainConn.getName());
        apiConn.setModificationDate(DateUtil.calendarToDate((Calendar)domainConn.getLastModified()));
        apiConn.setCreationDate(DateUtil.calendarToDate((Calendar)domainConn.getCreationTime()));
        if (MgmtFactory.getClusterSettingsManager().isEnableSelectiveReplicationForConnections()) {
            apiConn.setReplicationStatus(domainConn.getReplicationStatus());
        }
        HashSet<String> virtualIdentities = new HashSet<String>();
        String defaultVirtualEntityId = null;
        if (domainConn.getDefaultVirtualIdentity() != null) {
            defaultVirtualEntityId = domainConn.getDefaultVirtualIdentity().getVirtualEntityId(DomainMode.CONFIGTIME);
            if (StringUtils.isNotEmpty((String)defaultVirtualEntityId)) {
                virtualIdentities.add(defaultVirtualEntityId);
            }
        } else if (!domainConn.getVirtualIdentities().isEmpty()) {
            defaultVirtualEntityId = ((VirtualIdentity)domainConn.getVirtualIdentities().get(0)).getVirtualEntityId(DomainMode.CONFIGTIME);
        }
        if (domainConn.isOIDCConnection()) {
            IdpConnection apiIdpConnection = (IdpConnection)apiConn;
            org.sourceid.saml20.domain.IdpConnection oidcDomainIdpConnection = (org.sourceid.saml20.domain.IdpConnection)domainConn;
            OIDCSettings oidcSettings = oidcDomainIdpConnection.getOidcSettings();
            if (oidcSettings != null) {
                if (apiIdpConnection.getOidcClientCredentials() == null) {
                    apiIdpConnection.setOidcClientCredentials(new OIDCClientCredentials());
                }
                apiIdpConnection.getOidcClientCredentials().setClientId(oidcSettings.getClientId());
                apiIdpConnection.getOidcClientCredentials().setEncryptedSecret(oidcSettings.getClientSecret());
                AdditionalAllowedEntitiesConfiguration configuration = new AdditionalAllowedEntitiesConfiguration();
                configuration.setAllowAdditionalEntities(oidcDomainIdpConnection.isAllowAdditionalEntities());
                configuration.setAllowAllEntities(oidcDomainIdpConnection.isAllowAllEntities());
                configuration.setAdditionalAllowedEntities(oidcDomainIdpConnection.getAdditionalAllowedEntities().stream().map(domainEntity -> {
                    Entity additionalEntity = new Entity();
                    additionalEntity.setEntityId(domainEntity.getEntityId());
                    additionalEntity.setEntityDescription(domainEntity.getEntityDescription());
                    return additionalEntity;
                }).collect(Collectors.toList()));
                apiIdpConnection.setAdditionalAllowedEntitiesConfiguration(configuration);
            }
            apiConn.setVirtualEntityIds(null);
        } else {
            if (StringUtils.isNotEmpty((String)defaultVirtualEntityId)) {
                apiConn.setDefaultVirtualEntityId(defaultVirtualEntityId);
            }
            for (VirtualIdentity virtualIdentity : domainConn.getVirtualIdentities()) {
                String virtualEntityId = virtualIdentity.getVirtualEntityId(DomainMode.CONFIGTIME);
                if (!StringUtils.isNotEmpty((String)virtualEntityId)) continue;
                virtualIdentities.add(virtualEntityId);
            }
            if (apiConn.getVirtualEntityIds() == null) {
                apiConn.setVirtualEntityIds(new ArrayList<String>(virtualIdentities));
            } else {
                apiConn.getVirtualEntityIds().addAll(virtualIdentities);
            }
        }
        if (domainConn.getBaseUrl() != null) {
            apiConn.setBaseUrl(domainConn.getBaseUrl().toString());
        }
        if (domainConn.getContactInfo() != null) {
            ContactInfo apiContactInfo = new ContactInfo();
            org.sourceid.saml20.domain.ContactInfo domainContactInfo = domainConn.getContactInfo();
            apiContactInfo.setCompany(domainContactInfo.getCompany());
            apiContactInfo.setEmail(domainContactInfo.getEmail());
            apiContactInfo.setFirstName(domainContactInfo.getFirstName());
            apiContactInfo.setLastName(domainContactInfo.getLastName());
            apiContactInfo.setPhone(domainContactInfo.getPhone());
            apiConn.setContactInfo(apiContactInfo);
        }
        if (domainConn instanceof org.sourceid.saml20.domain.IdpConnection) {
            IdpConnection apiIdpConn = (IdpConnection)apiConn;
            apiIdpConn.setErrorPageMsgId(((org.sourceid.saml20.domain.IdpConnection)domainConn).getErrorPageMsg());
        }
        if (domainConn instanceof org.sourceid.saml20.domain.SpConnection) {
            SpConnection spApiConn = (SpConnection)apiConn;
            org.sourceid.saml20.domain.SpConnection spDomainConn = (org.sourceid.saml20.domain.SpConnection)domainConn;
            spApiConn.setApplicationName(spDomainConn.getApplicationName());
            if (spDomainConn.getApplicationIconUrl() != null) {
                spApiConn.setApplicationIconUrl(spDomainConn.getApplicationIconUrl().toExternalForm());
            }
        }
        apiConn.setLoggingMode(domainConn.getConfiguredLogMode());
        apiConn.setLicenseConnectionGroup(domainConn.getLicenseConnectionGroupAssignment());
    }
}

