/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.IdpAdapterAssertionMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.plugin.IdpAdapter;
import com.pingidentity.admin.api.validator.IdpAdapterValidator;
import com.pingidentity.pf.admin.rest.translator.AttributeAssertionMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.plugin.IdpAdapterTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;

public class IdpAdapterMappingTranslator {
    private ValidatorContext validatorContext;

    public IdpAdapterMappingTranslator(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public void apiToDomain(SpConnection apiConn, List<AdapterToAssertionMapping> domainMappings) {
        List<IdpAdapterAssertionMapping> adapterMappings = apiConn.getSpBrowserSso().getAdapterMappings();
        domainMappings.clear();
        for (IdpAdapterAssertionMapping apiMapping : adapterMappings) {
            AdapterToAssertionMapping domainMapping = new AdapterToAssertionMapping();
            domainMappings.add(domainMapping);
            AttributeAssertionMappingTranslator mappingTranslator = new AttributeAssertionMappingTranslator();
            if (apiConn.getSpBrowserSso().getProtocol() == Protocol.WSFED) {
                mappingTranslator.apiToDomain_wsFed(apiMapping, (AuthnSourceToAssertionMapping)domainMapping);
            } else {
                mappingTranslator.apiToDomain_nonWsFed(apiMapping, (AuthnSourceToAssertionMapping)domainMapping);
            }
            List domainAttributeMappings = domainMapping.getAttributeMappingList();
            AttributeMapping defaultAttributeMapping = domainMapping.getDefaultAttributeMapping();
            if (domainAttributeMappings.size() > 0 && (defaultAttributeMapping == null || defaultAttributeMapping.getAttributeMapping().isEmpty()) && apiMapping.isAbortSsoTransactionAsFailSafe()) {
                domainMapping.setAbortIfNotFoundInAnyDataSources(true);
            }
            domainMapping.setRestrictVirtualServerIds(apiMapping.isRestrictVirtualEntityIds());
            if (apiMapping.isRestrictVirtualEntityIds()) {
                domainMapping.setRestrictedVirtualServerIds(apiMapping.getRestrictedVirtualEntityIds());
            }
            if (apiMapping.hasAdapterOverride()) {
                IdpAdapter adapterOverride = apiMapping.getAdapterOverrideSettings();
                IdpAdapterValidator idpAdapterValidator = new IdpAdapterValidator(adapterOverride, false, this.validatorContext);
                idpAdapterValidator.validate();
                IdpAdapterTranslator idpAdapterTranslator = new IdpAdapterTranslator();
                IdpAuthnAdapterInstance domainOverrideAdapterInstance = idpAdapterTranslator.apiToDomain(adapterOverride, idpAdapterValidator);
                String parentAdapterId = adapterOverride.getParentRef().getId();
                String connectionId = apiConn.getEntityId();
                String adapterRefGeneratedId = adapterOverride.getId();
                domainMapping.setAdapterInstanceId(adapterRefGeneratedId);
                domainOverrideAdapterInstance.setId(adapterRefGeneratedId);
                domainOverrideAdapterInstance.setParentId(parentAdapterId);
                domainOverrideAdapterInstance.setConnectionId(connectionId);
                domainMapping.setConnectionOverrideInstance(domainOverrideAdapterInstance);
                continue;
            }
            domainMapping.setAdapterInstanceId(apiMapping.getIdpAdapterRef().getId());
        }
    }

    public void domainToApi(Collection<AdapterToAssertionMapping> domainMappings, List<IdpAdapterAssertionMapping> adapterMappings) {
        adapterMappings.clear();
        for (AdapterToAssertionMapping domainMapping : domainMappings) {
            IdpAuthnAdapterInstance domainAdapterOverride;
            ResourceLink resourceId = new ResourceLink();
            String adapterId = domainMapping.getAdapterInstanceId();
            if (adapterId != null) {
                resourceId.setId(adapterId);
                resourceId.setLocation(ApiUtil.getResourceUrl("/idp/adapters", adapterId));
            }
            IdpAdapterAssertionMapping idpAdapterAssertionMapping = new IdpAdapterAssertionMapping();
            idpAdapterAssertionMapping.setIdpAdapterRef(resourceId);
            adapterMappings.add(idpAdapterAssertionMapping);
            AttributeAssertionMappingTranslator mappingTranslator = new AttributeAssertionMappingTranslator();
            mappingTranslator.domainToApi(domainMapping.getAttributeMappingList(), (com.pingidentity.admin.api.model.AttributeMapping)idpAdapterAssertionMapping);
            if (domainMapping.getDefaultAttributeMapping() != null) {
                mappingTranslator.domainToApi(domainMapping.getDefaultAttributeMapping(), (com.pingidentity.admin.api.model.AttributeMapping)idpAdapterAssertionMapping);
            }
            idpAdapterAssertionMapping.setRestrictVirtualEntityIds(domainMapping.isRestrictVirtualServerIds());
            if (domainMapping.isRestrictVirtualServerIds()) {
                idpAdapterAssertionMapping.setRestrictedVirtualEntityIds(domainMapping.getRestrictedVirtualServerIds());
            }
            if ((domainAdapterOverride = domainMapping.getConnectionOverrideInstance()) != null) {
                IdpAdapterTranslator idpAdapterTranslator = new IdpAdapterTranslator();
                IdpAdapter apiAdapterOverride = idpAdapterTranslator.domainToApi(domainAdapterOverride);
                apiAdapterOverride.setPluginDescriptorRef(null);
                apiAdapterOverride.setName(null);
                idpAdapterAssertionMapping.setIdpAdapterRef(null);
                idpAdapterAssertionMapping.setAdapterOverrideSettings(apiAdapterOverride);
            }
            if (!domainMapping.isAbortIfNotFoundInAnyDataSources()) continue;
            idpAdapterAssertionMapping.setAbortSsoTransactionAsFailSafe(true);
        }
    }
}

