/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AttributeQueryNameMapping;
import com.pingidentity.admin.api.model.IdpAttributeQuery;
import com.pingidentity.admin.api.model.IdpAttributeQueryPolicy;
import com.pingidentity.admin.api.model.IdpConnection;
import java.util.ArrayList;
import java.util.Collection;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.AttributeNameMapping;
import org.sourceid.saml20.domain.Endpoint;

public class IdpAttributeQueryTranslator {
    public void domainToApi(org.sourceid.saml20.domain.IdpConnection domainConn, IdpConnection apiConn) {
        AttributeAuthority attribAuthority = domainConn.getAttributeAuthority();
        if (attribAuthority != null) {
            IdpAttributeQuery attributeQuery = new IdpAttributeQuery();
            attributeQuery.setUrl(attribAuthority.getAttributeService().getLocation());
            ArrayList<AttributeQueryNameMapping> apiMappings = new ArrayList<AttributeQueryNameMapping>();
            Collection mapping = attribAuthority.getAttributeNameMapping().getNameMappings();
            for (AttributeNameMapping.NameMapping item : mapping) {
                AttributeQueryNameMapping apiMapping = new AttributeQueryNameMapping();
                apiMapping.setLocalName(item.getLocalName());
                apiMapping.setRemoteName(item.getRemoteName());
                apiMappings.add(apiMapping);
            }
            attributeQuery.setNameMappings(apiMappings);
            IdpAttributeQueryPolicy policy = new IdpAttributeQueryPolicy();
            policy.setSignAttributeQuery(attribAuthority.isSignAttributeQuery());
            policy.setEncryptNameId(attribAuthority.isEncryptNameId());
            policy.setRequireSignedResponse(attribAuthority.isRequireSignedResponse());
            policy.setRequireSignedAssertion(attribAuthority.isRequireSignedAssertion());
            policy.setRequireEncryptedAssertion(attribAuthority.isRequireEncryptedAssertion());
            policy.setMaskAttributeValues(attribAuthority.isMaskAttributeValues());
            attributeQuery.setPolicy(policy);
            apiConn.setAttributeQuery(attributeQuery);
        }
    }

    public void apiToDomain(IdpConnection apiConn, org.sourceid.saml20.domain.IdpConnection domainConn) {
        IdpAttributeQuery attributeQuery = apiConn.getAttributeQuery();
        if (attributeQuery != null) {
            AttributeAuthority tempAttributeAuthority = new AttributeAuthority();
            tempAttributeAuthority.setAttributeService(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", attributeQuery.getUrl()));
            ArrayList<AttributeNameMapping.NameMapping> nameMappingList = new ArrayList<AttributeNameMapping.NameMapping>();
            for (AttributeQueryNameMapping item : attributeQuery.getNameMappings()) {
                AttributeNameMapping.NameMapping newItem = new AttributeNameMapping.NameMapping(item.getLocalName(), item.getRemoteName());
                nameMappingList.add(newItem);
            }
            tempAttributeAuthority.getAttributeNameMapping().setNameMappings(nameMappingList);
            IdpAttributeQueryPolicy policy = attributeQuery.getPolicy();
            tempAttributeAuthority.setSignAttributeQuery(policy.isSignAttributeQuery());
            tempAttributeAuthority.setEncryptNameId(policy.isEncryptNameId());
            tempAttributeAuthority.setRequireSignedResponse(policy.isRequireSignedResponse());
            tempAttributeAuthority.setRequireSignedAssertion(policy.isRequireSignedAssertion());
            tempAttributeAuthority.setRequireEncryptedAssertion(policy.isRequireEncryptedAssertion());
            tempAttributeAuthority.setMaskAttributeValues(policy.isMaskAttributeValues());
            domainConn.setAttributeAuthority(tempAttributeAuthority);
        }
    }
}

