/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttributeContract;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.websso.Protocol;

public class IdpConnectionAttributeContractTranslator {
    public void apiToDomain(IdpBrowserSso browserSso, IdpConnection domainConn) {
        String attrName;
        IdpBrowserSsoAttributeContract apiContract = browserSso.getAttributeContract();
        AssertionAttributeContract domainContract = new AssertionAttributeContract();
        HashSet<String> maskedAttrNames = new HashSet<String>();
        for (IdpBrowserSsoAttribute immutableAttr : apiContract.getCoreAttributes()) {
            attrName = immutableAttr.getName();
            if (attrName == null || !domainContract.isImmutable(attrName) || immutableAttr.isMasked() == null || !immutableAttr.isMasked().booleanValue()) continue;
            maskedAttrNames.add(attrName);
        }
        for (IdpBrowserSsoAttribute mutableAttr : apiContract.getExtendedAttributes()) {
            attrName = mutableAttr.getName();
            if (mutableAttr.isMasked().booleanValue()) {
                maskedAttrNames.add(attrName);
            }
            domainContract.addMutableAttributeName(attrName);
        }
        domainConn.setAttributeContract((AttributeContract)domainContract);
        domainConn.setMaskedAttributeNames(maskedAttrNames);
    }

    public void domainToApi(IdpConnection domainConn, IdpBrowserSsoAttributeContract apiContract) {
        AttributeContract domainContract = domainConn.getAttributeContract();
        Set maskedAttrNames = domainConn.getMaskedAttributeNames();
        for (String immutableAttrName : domainContract.getImmutableAttributeNames()) {
            IdpBrowserSsoAttribute immutableAttr = new IdpBrowserSsoAttribute();
            immutableAttr.setName(immutableAttrName);
            if (domainConn.getProtocol() != Protocol.WSFED) {
                immutableAttr.setMasked(maskedAttrNames.contains(immutableAttrName));
            } else {
                immutableAttr.setMasked(null);
            }
            apiContract.getCoreAttributes().add(immutableAttr);
        }
        for (String mutableAttrName : domainContract.getMutableAttributeNames()) {
            IdpBrowserSsoAttribute mutableAttr = new IdpBrowserSsoAttribute();
            mutableAttr.setName(mutableAttrName);
            mutableAttr.setMasked(maskedAttrNames.contains(mutableAttrName));
            apiContract.getExtendedAttributes().add(mutableAttr);
        }
    }
}

