/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.InboundBackChannelAuth;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.admin.api.validator.SslClientVerificationCertValidator;
import com.pingidentity.pf.admin.rest.translator.AbstractBackChannelTranslator;
import com.pingidentity.pf.admin.rest.translator.ConnectionCertsTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.InCertAuthInfo;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.Role;

public class InboundBackChannelAuthTranslator
extends AbstractBackChannelTranslator {
    public void domainToApi(ConnectionBase domainConn, ConnectionCredentials credentials) {
        if (!this.isBackChannelAuthenticationNeeded(domainConn) || !this.isOutboundArtifactSelected(domainConn)) {
            return;
        }
        SoapAuthInfo soapAuthIn = domainConn.getSoapAuthIn();
        InboundBackChannelAuth auth = new InboundBackChannelAuth();
        if (soapAuthIn.isHasBasicEntry() && this.authMethodExist(domainConn, soapAuthIn)) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials();
            SoapAuthInfo.BasicAuthInfo basicAuthInfo = soapAuthIn.getBasicAuthInfo();
            creds.setUsername(basicAuthInfo.getUsername());
            String encodedPassword = basicAuthInfo.getEncodedPassword();
            if (!StringUtils.isBlank((String)encodedPassword)) {
                creds.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(encodedPassword));
            }
            auth.setHttpBasicCredentials(creds);
        }
        if (soapAuthIn.isHasCertEntry() && this.authMethodExist(domainConn, soapAuthIn)) {
            if (soapAuthIn.getCertAuthInfo().getCert() != null) {
                ConnectionCertsTranslator certsTranslator = new ConnectionCertsTranslator();
                List<ConnectionCert> certs = certsTranslator.domainToApi(domainConn.getClientAuthCerts());
                auth.setCerts(certs);
            } else {
                auth.setVerificationSubjectDN(soapAuthIn.getCertAuthInfo().getSubjectDN());
                auth.setVerificationIssuerDN(soapAuthIn.getCertAuthInfo().getIssuerDN());
            }
        }
        Boolean digitalSignature = this.getDigitalSignature(domainConn, soapAuthIn);
        auth.setDigitalSignature(digitalSignature);
        auth.setRequireSsl(soapAuthIn.isSsl());
        if (auth.getCerts() == null && auth.getHttpBasicCredentials() == null && auth.getVerificationIssuerDN() == null && auth.getVerificationSubjectDN() == null && !auth.isRequireSsl() && !auth.isDigitalSignature().booleanValue()) {
            auth = null;
        }
        credentials.setInboundBackChannelAuth(auth);
    }

    public void apiToDomain(Connection apiConn, ConnectionBase domainConn, ValidatorRegistry validatorRegistry) {
        ConnectionCredentials credentials = apiConn.getCredentials();
        if (credentials.getInboundBackChannelAuth() == null) {
            return;
        }
        SoapAuthInfo soapAuthIn = domainConn.getSoapAuthIn();
        InboundBackChannelAuth auth = credentials.getInboundBackChannelAuth();
        UsernamePasswordCredentials basicAuth = auth.getHttpBasicCredentials();
        if (this.isXaspOnly(apiConn) && this.apiNoAuthTypeSelected(apiConn, validatorRegistry)) {
            soapAuthIn.setHasNoneEntry(true);
        } else {
            if (basicAuth != null) {
                String password = null;
                String existingPassword = EncryptedFieldValidator.decryptCiphertext(basicAuth.getEncryptedPassword());
                SoapAuthInfo.IncomingBasicAuthInfo incomingBasicAuth = new SoapAuthInfo.IncomingBasicAuthInfo(basicAuth.getUsername(), existingPassword);
                if (!StringUtils.isBlank((String)basicAuth.getPassword())) {
                    password = basicAuth.getPassword();
                    incomingBasicAuth.setNewPassword(password);
                }
                soapAuthIn.setBasicAuthInfo((SoapAuthInfo.BasicAuthInfo)incomingBasicAuth);
            }
            if (StringUtils.isNotBlank((String)auth.getVerificationSubjectDN())) {
                soapAuthIn.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(auth.getVerificationSubjectDN(), auth.getVerificationIssuerDN(), null, null));
            } else {
                SslClientVerificationCertValidator sslValidator = (SslClientVerificationCertValidator)validatorRegistry.getValidator(SslClientVerificationCertValidator.class);
                if (sslValidator != null && sslValidator.getDomainCerts() != null) {
                    soapAuthIn.setCertAuthInfo((SoapAuthInfo.CertAuthInfo)new InCertAuthInfo(sslValidator.getDomainCerts()));
                }
            }
            soapAuthIn.setHasNoneEntry(auth.isDigitalSignature().booleanValue());
        }
        soapAuthIn.setSsl(auth.isRequireSsl() || soapAuthIn.getCertAuthInfo() != null);
        domainConn.setSoapAuthIn(soapAuthIn);
    }

    public boolean isOutboundArtifactSelected(ConnectionBase domainConn) {
        boolean selected = false;
        selected = this.isArtifactSsoSlo(domainConn);
        selected |= this.isInboundSoap(domainConn);
        if (Role.SP == domainConn.getRoleType()) {
            SpConnection spConn = (SpConnection)domainConn;
            selected |= spConn.getAttributeRequester() != null;
        }
        if (Role.IDP == domainConn.getRoleType()) {
            selected |= domainConn.doesInboundProvisioningExist();
        }
        return selected;
    }

    public boolean isArtifactSsoSlo(ConnectionBase domainConn) {
        return domainConn.isAnySsoSelected() && domainConn.isArtifactSsoSloUsed();
    }

    private boolean isInboundSoap(ConnectionBase domainConn) {
        return domainConn.isAnySsoSelected() && domainConn.getIncomingBindings().getSoapBinding();
    }
}

