/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.JdbcDataStore;
import com.pingidentity.admin.api.validator.JdbcDataStoreValidator;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.pf.admin.rest.translator.DataStoreTranslator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagConfig;
import org.sourceid.saml20.domain.datasource.tag.JdbcInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;

public class JdbcDataStoreTranslator
extends DataStoreTranslator<JdbcDataStore, JdbcDataSource, JdbcDataStoreValidator> {
    @Override
    public void apiToDomain(JdbcDataStore dataStore, JdbcDataSource dataSource, JdbcDataStoreValidator validator) {
        super.apiToDomain(dataStore, dataSource, validator);
        dataSource.setConnectionUrl(dataStore.getConnectionUrl());
        dataSource.setDriverClass(dataStore.getDriverClass());
        dataSource.setUserName(dataStore.getUserName());
        String password = StringUtils.isNotBlank((String)dataStore.getPassword()) ? dataStore.getPassword() : (SecretReferenceUtil.isSecretReference((String)dataStore.getEncryptedPassword()) ? dataStore.getEncryptedPassword() : FieldObfuscator.REAL.deobfuscate(dataStore.getEncryptedPassword()));
        dataSource.setPassword(password);
        dataSource.setCheckValidConnectionSql(dataStore.getValidateConnectionSql());
        dataSource.setMultiValueAttributesAllowed(dataStore.isAllowMultiValueAttributes());
        this.setDataSourceTagConfig(dataStore, dataSource);
        dataSource.setMinPoolSize(dataStore.getMinPoolSize().intValue());
        dataSource.setMaxPoolSize(dataStore.getMaxPoolSize().intValue());
        dataSource.setBlockingTimeoutMillis(dataStore.getBlockingTimeout().intValue());
        dataSource.setIdleTimeoutMinutes(dataStore.getIdleTimeout().intValue());
        if (StringUtils.isNotBlank((String)dataStore.getName())) {
            dataSource.setDsName(dataStore.getName());
            dataSource.setDescription(dataStore.getName());
        }
    }

    private void setDataSourceTagConfig(JdbcDataStore dataStore, JdbcDataSource dataSource) {
        if (CollectionUtils.isEmpty(dataStore.getConnectionUrlTags()) && StringUtils.isNotEmpty((String)dataStore.getConnectionUrl())) {
            LinkedList<JdbcTagConfig> revisedJdbcTagConfigList = new LinkedList<JdbcTagConfig>();
            JdbcInstanceIdentifier defaultInstanceIdentifier = new JdbcInstanceIdentifier(dataStore.getConnectionUrl());
            revisedJdbcTagConfigList.add(new JdbcTagConfig(defaultInstanceIdentifier, null, true));
            dataSource.setJdbcTagConfigList(revisedJdbcTagConfigList);
        } else if (CollectionUtils.isNotEmpty(dataStore.getConnectionUrlTags()) && StringUtils.isEmpty((String)dataStore.getConnectionUrl())) {
            dataStore.getConnectionUrlTags().parallelStream().filter(DataSourceTagConfig::isDefaultSource).findFirst().ifPresent(defaultJdbcTagConfig -> dataSource.setConnectionUrl(defaultJdbcTagConfig.getIdentifier().getJdbcUrl()));
            dataSource.setJdbcTagConfigList(dataStore.getConnectionUrlTags());
        } else {
            dataSource.setJdbcTagConfigList(dataStore.getConnectionUrlTags());
        }
    }

    @Override
    public void domainToApi(JdbcDataSource dataSource, JdbcDataStore dataStore) {
        super.domainToApi(dataSource, dataStore);
        dataStore.setConnectionUrl(dataSource.getConnectionUrl());
        dataStore.setDriverClass(dataSource.getDriverClass());
        dataStore.setUserName(dataSource.getUserName());
        dataStore.setEncryptedPassword(SecretReferenceUtil.isSecretReference((String)dataSource.getPassword()) ? dataSource.getPassword() : FieldObfuscator.REAL.obfuscate(dataSource.getPassword()));
        dataStore.setValidateConnectionSql(dataSource.getCheckValidConnectionSql());
        dataStore.setAllowMultiValueAttributes(dataSource.isMultiValueAttributesAllowed());
        this.setDataStoreTagConfig(dataSource, dataStore);
        dataStore.setMinPoolSize(dataSource.getMinPoolSize());
        dataStore.setMaxPoolSize(dataSource.getMaxPoolSize());
        dataStore.setBlockingTimeout(dataSource.getBlockingTimeoutMillis());
        dataStore.setIdleTimeout(dataSource.getIdleTimeoutMinutes());
        if (StringUtils.isNotBlank((String)dataSource.getDsName())) {
            dataStore.setName(dataSource.getDsName());
        }
    }

    private void setDataStoreTagConfig(JdbcDataSource dataSource, JdbcDataStore dataStore) {
        if (CollectionUtils.isEmpty((Collection)dataSource.getJdbcTagConfigList()) && StringUtils.isNotEmpty((String)dataSource.getConnectionUrl())) {
            LinkedList<JdbcTagConfig> revisedJdbcTagConfigList = new LinkedList<JdbcTagConfig>();
            JdbcInstanceIdentifier defaultInstanceIdentifier = new JdbcInstanceIdentifier(dataSource.getConnectionUrl());
            revisedJdbcTagConfigList.add(new JdbcTagConfig(defaultInstanceIdentifier, null, true));
            dataStore.setConnectionUrlTags(revisedJdbcTagConfigList);
        } else if (CollectionUtils.isNotEmpty((Collection)dataSource.getJdbcTagConfigList()) && StringUtils.isEmpty((String)dataSource.getConnectionUrl())) {
            dataSource.getJdbcTagConfigList().parallelStream().filter(DataSourceTagConfig::isDefaultSource).findFirst().ifPresent(defaultJdbcTagConfig -> dataStore.setConnectionUrl(defaultJdbcTagConfig.getIdentifier().getJdbcUrl()));
            dataStore.setConnectionUrlTags(dataSource.getJdbcTagConfigList());
        } else {
            dataStore.setConnectionUrlTags(dataSource.getJdbcTagConfigList());
        }
    }
}

