/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.DataStoreRepositoryType;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.sso.idp.DataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.ErrorHandlingType;
import com.pingidentity.admin.api.model.sso.idp.EventTriggerType;
import com.pingidentity.admin.api.model.sso.idp.JdbcDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.JitProvisioning;
import com.pingidentity.admin.api.model.sso.idp.JitProvisioningUserAttributes;
import com.pingidentity.admin.api.model.sso.idp.LdapDataStoreRepository;
import com.pingidentity.admin.api.model.sso.idp.SqlMethod;
import com.pingidentity.admin.api.model.sso.idp.StoredProcedure;
import com.pingidentity.admin.api.model.sso.idp.Table;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.impl.JdbcAttributeSource;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;

public class JitProvisioningTranslator {
    public void apiToDomain(JitProvisioning apiJitProvisioning, UserProvisioning domainUserProvisioning) {
        JitProvisioningUserAttributes jitProvisioningUserAttributes = apiJitProvisioning.getUserAttributes();
        domainUserProvisioning.setDoAttributeQuery(jitProvisioningUserAttributes.isDoAttributeQuery());
        this.apiToDomainUserRepository(apiJitProvisioning, domainUserProvisioning);
        this.apiToDomainEventTrigger(apiJitProvisioning, domainUserProvisioning);
        this.apiToDomainErrorHandling(apiJitProvisioning.getErrorHandling(), domainUserProvisioning);
    }

    public void domainToApi(IdpConnection domainConn, JitProvisioning apiJitProvisioning) {
        UserProvisioning userProvisioning = domainConn.getUserProvisioning();
        this.domainToApiUserAttributes(domainConn, apiJitProvisioning);
        this.domainToApiUserRepository(userProvisioning, apiJitProvisioning);
        this.domainToApiEventTrigger(userProvisioning, apiJitProvisioning);
        this.domainToApiErrorHandling(userProvisioning, apiJitProvisioning);
    }

    private void domainToApiUserAttributes(IdpConnection domainConn, JitProvisioning apiJitProvisioning) {
        JitProvisioningUserAttributes jitProvisioningUserAttributes = new JitProvisioningUserAttributes();
        apiJitProvisioning.setUserAttributes(jitProvisioningUserAttributes);
        Set maskedAttrNames = domainConn.getMaskedAttributeNames();
        for (String attributeName : domainConn.getAttributeContract().getAllAttributeNames()) {
            IdpBrowserSsoAttribute attribute = new IdpBrowserSsoAttribute();
            attribute.setName(attributeName);
            attribute.setMasked(maskedAttrNames.contains(attributeName));
            apiJitProvisioning.getUserAttributes().getAttributeContract().add(attribute);
        }
        jitProvisioningUserAttributes.setDoAttributeQuery(domainConn.getUserProvisioning().isDoAttributeQuery());
        apiJitProvisioning.setUserAttributes(jitProvisioningUserAttributes);
    }

    private void domainToApiUserRepository(UserProvisioning domainUserProvisioning, JitProvisioning apiJitProvisioning) {
        HashMap<String, AttributeFulfillmentValue> apiJitRepositoryAttributeMapping = new HashMap<String, AttributeFulfillmentValue>();
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        attributeMappingTranslator.domainToApi(domainUserProvisioning.getAttributeMapping(), apiJitRepositoryAttributeMapping);
        DataStoreRepository apiDataStoreRepository = null;
        switch (DataSource.DSType.fromName((String)domainUserProvisioning.getAttributeSource().getType())) {
            case LDAP: {
                apiDataStoreRepository = new LdapDataStoreRepository();
                LdapAttributeSource domainLdapAttributeSource = (LdapAttributeSource)domainUserProvisioning.getAttributeSource();
                this.domainToApiLdapAttributeSource(domainLdapAttributeSource, (LdapDataStoreRepository)apiDataStoreRepository);
                apiDataStoreRepository.setJitRepositoryAttributeMapping(apiJitRepositoryAttributeMapping);
                apiJitProvisioning.setUserRepository(apiDataStoreRepository);
                break;
            }
            case JDBC: {
                apiDataStoreRepository = new JdbcDataStoreRepository();
                JdbcAttributeSource domainJdbcAttributeSource = (JdbcAttributeSource)domainUserProvisioning.getAttributeSource();
                this.domainToApiJdbcAttributeSource(domainJdbcAttributeSource, (JdbcDataStoreRepository)apiDataStoreRepository, domainUserProvisioning.getSqlMethod());
                apiDataStoreRepository.setJitRepositoryAttributeMapping(apiJitRepositoryAttributeMapping);
                apiJitProvisioning.setUserRepository(apiDataStoreRepository);
                break;
            }
        }
    }

    private void apiToDomainUserRepository(JitProvisioning apiJitProvisioning, UserProvisioning domainUserProvisioning) {
        DataStoreRepository apiDataStoreRepository = apiJitProvisioning.getUserRepository();
        if (apiDataStoreRepository != null) {
            Map<String, AttributeFulfillmentValue> apiJitRepositoryAttributeMapping = apiDataStoreRepository.getJitRepositoryAttributeMapping();
            if (apiJitRepositoryAttributeMapping != null) {
                AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
                attributeMappingTranslator.apiToDomain(apiJitRepositoryAttributeMapping, domainUserProvisioning.getAttributeMapping());
            }
            LdapAttributeSource domainAttributeSource = null;
            switch (apiDataStoreRepository.getType()) {
                case LDAP: {
                    domainAttributeSource = new LdapAttributeSource();
                    this.apiToDomainLdapAttributeSource((LdapDataStoreRepository)apiDataStoreRepository, domainAttributeSource);
                    domainUserProvisioning.setAttributeSource((AttributeSource)domainAttributeSource);
                    break;
                }
                case JDBC: {
                    domainAttributeSource = new JdbcAttributeSource();
                    this.apiToDomainJdbcAttributeSource((JdbcDataStoreRepository)apiDataStoreRepository, (JdbcAttributeSource)domainAttributeSource, domainUserProvisioning);
                    domainUserProvisioning.setAttributeSource((AttributeSource)domainAttributeSource);
                    break;
                }
            }
        }
    }

    private void domainToApiLdapAttributeSource(LdapAttributeSource domainLdapAttributeSource, LdapDataStoreRepository apiDataStoreRepository) {
        ResourceLink ldapDataSourceResourceLink = JitProvisioningTranslator.getResourceLinkFromDomain((AttributeSource)domainLdapAttributeSource);
        apiDataStoreRepository.setDataStoreRef(ldapDataSourceResourceLink);
        apiDataStoreRepository.setBaseDn(domainLdapAttributeSource.getParameter("search_base"));
        apiDataStoreRepository.setUniqueUserIdFilter(domainLdapAttributeSource.getParameter("filter"));
    }

    private void apiToDomainLdapAttributeSource(LdapDataStoreRepository apiDataStoreRepository, LdapAttributeSource domainLdapAttributeSource) {
        domainLdapAttributeSource.setDataSourceId(apiDataStoreRepository.getDataStoreRef().getId());
        domainLdapAttributeSource.setParameter("search_base", apiDataStoreRepository.getBaseDn());
        domainLdapAttributeSource.setParameter("filter", apiDataStoreRepository.getUniqueUserIdFilter());
        domainLdapAttributeSource.setParameter("search_scope", "ONELEVEL_SCOPE");
    }

    private void domainToApiJdbcAttributeSource(JdbcAttributeSource domainJdbcAttributeSource, JdbcDataStoreRepository apiDataStoreRepository, UserProvisioning.SqlMethodType sqlMethodType) {
        ResourceLink jdbcDataSourceResourceLink = JitProvisioningTranslator.getResourceLinkFromDomain((AttributeSource)domainJdbcAttributeSource);
        apiDataStoreRepository.setDataStoreRef(jdbcDataSourceResourceLink);
        SqlMethod sqlMethod = new SqlMethod();
        switch (sqlMethodType) {
            case Table: {
                Table table = new Table();
                table.setSchema(domainJdbcAttributeSource.getParameter("schema"));
                table.setTableName(domainJdbcAttributeSource.getParameter("tableName"));
                table.setUniqueIdColumn(domainJdbcAttributeSource.getParameter("filter"));
                sqlMethod.setTable(table);
                break;
            }
            case StoredProcedure: {
                StoredProcedure storedProcedure = new StoredProcedure();
                storedProcedure.setSchema(domainJdbcAttributeSource.getParameter("schema"));
                storedProcedure.setStoredProcedure(domainJdbcAttributeSource.getParameter("storedProcedure"));
                sqlMethod.setStoredProcedure(storedProcedure);
                break;
            }
        }
        apiDataStoreRepository.setSqlMethod(sqlMethod);
    }

    private void apiToDomainJdbcAttributeSource(JdbcDataStoreRepository apiDataStoreRepository, JdbcAttributeSource domainJdbcAttributeSource, UserProvisioning domainUserProvisioning) {
        domainJdbcAttributeSource.setDataSourceId(apiDataStoreRepository.getDataStoreRef().getId());
        SqlMethod sqlMethod = apiDataStoreRepository.getSqlMethod();
        if (sqlMethod != null) {
            if (sqlMethod.getTable() != null) {
                Table table = sqlMethod.getTable();
                domainJdbcAttributeSource.setParameter("schema", table.getSchema());
                domainJdbcAttributeSource.setParameter("tableName", table.getTableName());
                domainJdbcAttributeSource.setParameter("filter", table.getUniqueIdColumn());
                domainUserProvisioning.setSqlMethod(UserProvisioning.SqlMethodType.Table);
            } else if (sqlMethod.getStoredProcedure() != null) {
                StoredProcedure storedProcedure = sqlMethod.getStoredProcedure();
                domainJdbcAttributeSource.setParameter("schema", storedProcedure.getSchema());
                domainJdbcAttributeSource.setParameter("storedProcedure", storedProcedure.getStoredProcedure());
                domainUserProvisioning.setSqlMethod(UserProvisioning.SqlMethodType.StoredProcedure);
            }
        }
    }

    private void domainToApiEventTrigger(UserProvisioning userProvisioning, JitProvisioning apiJitProvisioning) {
        if (DataSource.DSType.JDBC.toString().equals(userProvisioning.getAttributeSource().getType()) && UserProvisioning.SqlMethodType.StoredProcedure.equals((Object)userProvisioning.getSqlMethod())) {
            apiJitProvisioning.setEventTrigger(EventTriggerType.ALL_SAML_ASSERTIONS);
            return;
        }
        switch (userProvisioning.getEventTrigger()) {
            case NewUserOnly: {
                apiJitProvisioning.setEventTrigger(EventTriggerType.NEW_USER_ONLY);
                break;
            }
            case AllSAMLAssertions: {
                apiJitProvisioning.setEventTrigger(EventTriggerType.ALL_SAML_ASSERTIONS);
                break;
            }
        }
    }

    private void apiToDomainEventTrigger(JitProvisioning apiJitProvisioning, UserProvisioning domainUserProvisioning) {
        if (DataStoreRepositoryType.JDBC.equals((Object)apiJitProvisioning.getUserRepository().getType()) && ((JdbcDataStoreRepository)apiJitProvisioning.getUserRepository()).getSqlMethod().getStoredProcedure() != null) {
            domainUserProvisioning.setEventTrigger(UserProvisioning.EventTriggerType.AllSAMLAssertions);
            return;
        }
        if (apiJitProvisioning.getEventTrigger() == null) {
            domainUserProvisioning.setEventTrigger(UserProvisioning.EventTriggerType.NewUserOnly);
            return;
        }
        switch (apiJitProvisioning.getEventTrigger()) {
            case NEW_USER_ONLY: {
                domainUserProvisioning.setEventTrigger(UserProvisioning.EventTriggerType.NewUserOnly);
                break;
            }
            case ALL_SAML_ASSERTIONS: {
                domainUserProvisioning.setEventTrigger(UserProvisioning.EventTriggerType.AllSAMLAssertions);
                break;
            }
        }
    }

    private void domainToApiErrorHandling(UserProvisioning userProvisioning, JitProvisioning apiJitProvisioning) {
        switch (userProvisioning.getErrorHandling()) {
            case ContinueSSO: {
                apiJitProvisioning.setErrorHandling(ErrorHandlingType.CONTINUE_SSO);
                break;
            }
            case AbortSSO: {
                apiJitProvisioning.setErrorHandling(ErrorHandlingType.ABORT_SSO);
                break;
            }
        }
    }

    private void apiToDomainErrorHandling(ErrorHandlingType errorHandling, UserProvisioning domainUserProvisioning) {
        switch (errorHandling) {
            case CONTINUE_SSO: {
                domainUserProvisioning.setErrorHandling(UserProvisioning.ErrorHandlingType.ContinueSSO);
                break;
            }
            case ABORT_SSO: {
                domainUserProvisioning.setErrorHandling(UserProvisioning.ErrorHandlingType.AbortSSO);
                break;
            }
        }
    }

    private static ResourceLink getResourceLinkFromDomain(AttributeSource domainSource) {
        ResourceLink dsRef = new ResourceLink();
        dsRef.setId(domainSource.getDataSourceId());
        dsRef.setLocation(ApiUtil.getResourceUrl("/dataStores", domainSource.getDataSourceId()));
        return dsRef;
    }
}

