/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.KerberosConfigUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.KerberosConnectionType;
import org.sourceid.saml20.domain.KerberosKeySet;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.KerberosKeySetUtil;

public class KerberosRealmTranslator {
    public com.pingidentity.admin.api.model.KerberosRealm domainToApi(KerberosRealm domainKerberosRealm) {
        com.pingidentity.admin.api.model.KerberosRealm apiKerberosRealm = new com.pingidentity.admin.api.model.KerberosRealm();
        apiKerberosRealm.setId(domainKerberosRealm.getId());
        apiKerberosRealm.setKerberosRealmName(domainKerberosRealm.getKerberosRealmName());
        if (domainKerberosRealm.getConnectionType() != null) {
            apiKerberosRealm.setConnectionType(domainKerberosRealm.getConnectionType());
        }
        if (domainKerberosRealm.isDirectConnection() || domainKerberosRealm.isLocalValidationConnection()) {
            apiKerberosRealm.setKerberosUsername(domainKerberosRealm.getKerberosUsername());
            apiKerberosRealm.setKerberosEncryptedPassword(FieldObfuscator.REAL.obfuscate(domainKerberosRealm.getKerberosPassword()));
            apiKerberosRealm.setRetainPreviousKeysOnPasswordChange(domainKerberosRealm.isRetainPreviousKeysOnPasswordChange());
            ArrayList<com.pingidentity.admin.api.model.KerberosKeySet> apiKeySets = new ArrayList<com.pingidentity.admin.api.model.KerberosKeySet>();
            for (KerberosKeySet domainKeySet : domainKerberosRealm.getValidKeySets(Instant.now())) {
                com.pingidentity.admin.api.model.KerberosKeySet apiKeySet = new com.pingidentity.admin.api.model.KerberosKeySet();
                apiKeySet.setEncryptedKeySet(KerberosKeySetUtil.toEncryptedKeySet((KerberosKeySet)domainKeySet));
                Date deactivatedAt = domainKeySet.getDeactivatedAt() != null ? new Date(domainKeySet.getDeactivatedAt().toEpochMilli()) : null;
                apiKeySet.setDeactivatedAt(deactivatedAt);
                apiKeySets.add(apiKeySet);
            }
            if (!apiKeySets.isEmpty()) {
                apiKerberosRealm.setKeySets(apiKeySets);
            }
            if (domainKerberosRealm.isDirectConnection()) {
                apiKerberosRealm.setKeyDistributionCenters(domainKerberosRealm.getKeyDistributionCenters());
                apiKerberosRealm.setSuppressDomainNameConcatenation(domainKerberosRealm.isSuppressDomainNameConcatenation());
            }
        } else if (domainKerberosRealm.isLdapGatewayConnection()) {
            ResourceLink ldapGatewayResourceLink = new ResourceLink(domainKerberosRealm.getLdapGatewayDatastoreId(), ApiUtil.getResourceUrl("/dataStores", domainKerberosRealm.getLdapGatewayDatastoreId()));
            apiKerberosRealm.setLdapGatewayDataStoreRef(ldapGatewayResourceLink);
        }
        return apiKerberosRealm;
    }

    public KerberosRealm apiToDomain(com.pingidentity.admin.api.model.KerberosRealm apiKerberosRealm) {
        KerberosRealm domainKerberosRealm = new KerberosRealm();
        domainKerberosRealm.setId(apiKerberosRealm.getId());
        domainKerberosRealm.setKerberosRealmName(apiKerberosRealm.getKerberosRealmName());
        domainKerberosRealm.setConnectType(apiKerberosRealm.getConnectionType());
        if (KerberosConnectionType.DIRECT.equals((Object)apiKerberosRealm.getConnectionType()) || KerberosConnectionType.LOCAL_VALIDATION.equals((Object)apiKerberosRealm.getConnectionType())) {
            domainKerberosRealm.setKerberosUsername(apiKerberosRealm.getKerberosUsername());
            String password = StringUtils.isNotBlank((String)apiKerberosRealm.getKerberosPassword()) ? apiKerberosRealm.getKerberosPassword() : FieldObfuscator.REAL.deobfuscate(apiKerberosRealm.getKerberosEncryptedPassword());
            domainKerberosRealm.setKerberosPassword(password);
            if (apiKerberosRealm.isRetainPreviousKeysOnPasswordChange() != null) {
                domainKerberosRealm.setRetainPreviousKeysOnPasswordChange(apiKerberosRealm.isRetainPreviousKeysOnPasswordChange().booleanValue());
            }
            ArrayList<KerberosKeySet> domainKeySets = new ArrayList<KerberosKeySet>();
            if (apiKerberosRealm.getKeySets() != null && apiKerberosRealm.isRetainPreviousKeysOnPasswordChange().booleanValue()) {
                for (com.pingidentity.admin.api.model.KerberosKeySet apiKeySet : apiKerberosRealm.getKeySets()) {
                    Instant deactivatedAt = apiKeySet.getDeactivatedAt() != null ? apiKeySet.getDeactivatedAt().toInstant() : null;
                    domainKeySets.add(KerberosKeySetUtil.fromEncryptedKeySet((Instant)deactivatedAt, (String)apiKeySet.getEncryptedKeySet()));
                }
            }
            domainKerberosRealm.setKeySets(domainKeySets);
            if (KerberosConnectionType.DIRECT.equals((Object)apiKerberosRealm.getConnectionType())) {
                if (!KerberosConfigUtil.isAutoGenerateKrb5ConfFile() && apiKerberosRealm.getId() != null) {
                    domainKerberosRealm.setKeyDistributionCenters(this.retrieveExistingKdcValuesFromDisc(apiKerberosRealm.getId()));
                } else {
                    List<String> apiKDCs = apiKerberosRealm.getKeyDistributionCenters();
                    if (apiKDCs == null) {
                        apiKDCs = new ArrayList<String>();
                    }
                    domainKerberosRealm.setKeyDistributionCenters(apiKDCs);
                }
                boolean suppressDomainNameConcatenation = false;
                if (apiKerberosRealm.getSuppressDomainNameConcatenation() != null) {
                    suppressDomainNameConcatenation = apiKerberosRealm.getSuppressDomainNameConcatenation();
                }
                domainKerberosRealm.setSuppressDomainNameConcatenation(suppressDomainNameConcatenation);
            }
        } else if (KerberosConnectionType.LDAP_GATEWAY.equals((Object)apiKerberosRealm.getConnectionType())) {
            domainKerberosRealm.setLdapGatewayDatastoreId(apiKerberosRealm.getLdapGatewayDataStoreRef().getId());
        }
        return domainKerberosRealm;
    }

    private List<String> retrieveExistingKdcValuesFromDisc(String realmId) {
        KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
        for (KerberosRealm kerberosRealmFromDisc : kerberosRealmManager.getKerberosRealms()) {
            if (!kerberosRealmFromDisc.getId().equals(realmId)) continue;
            return kerberosRealmFromDisc.getKeyDistributionCenters();
        }
        return new ArrayList<String>();
    }
}

