/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.LdapType;
import com.pingidentity.admin.api.model.PingOneLdapGatewayDataStore;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.validator.LdapGatewayDataStoreValidator;
import com.pingidentity.pf.admin.rest.translator.DataStoreTranslator;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;

public class LdapGatewayDataStoreTranslator
extends DataStoreTranslator<PingOneLdapGatewayDataStore, LdapDataSource, LdapGatewayDataStoreValidator> {
    @Override
    public void apiToDomain(PingOneLdapGatewayDataStore dataStore, LdapDataSource dataSource, LdapGatewayDataStoreValidator validator) {
        super.apiToDomain(dataStore, dataSource, validator);
        dataSource.setHost(String.format("%s:%s:%s", dataStore.getPingOneConnectionRef().getId(), dataStore.getPingOneEnvironmentId(), dataStore.getPingOneLdapGatewayId()));
        dataSource.setLdapType(dataStore.getLdapType().getLdapInfoEquivalent());
        switch (dataStore.getLdapType()) {
            case ACTIVE_DIRECTORY: {
                dataSource.setLdapType(LdapInfo.LdapType.ActiveDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.ActiveDirectory.getDescription());
                break;
            }
            case ORACLE_DIRECTORY_SERVER: {
                dataSource.setLdapType(LdapInfo.LdapType.SunDirectoryServer);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.SunDirectoryServer.getDescription());
                break;
            }
            case ORACLE_UNIFIED_DIRECTORY: {
                dataSource.setLdapType(LdapInfo.LdapType.OracleUnifiedDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.OracleUnifiedDirectory.getDescription());
                break;
            }
            case UNBOUNDID_DS: {
                dataSource.setLdapType(LdapInfo.LdapType.PingDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.PingDirectory.getDescription());
                break;
            }
            case PING_DIRECTORY: {
                dataSource.setLdapType(LdapInfo.LdapType.PingDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.PingDirectory.getDescription());
                break;
            }
            case PING_DS: {
                dataSource.setLdapType(LdapInfo.LdapType.PingDS);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.PingDS.getDescription());
                break;
            }
            default: {
                dataSource.setLdapType(LdapInfo.LdapType.Generic);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.Generic.getDescription());
            }
        }
        dataSource.setPingOneConnection(dataStore.getPingOneConnectionRef().getId());
        dataSource.setPingOneEnvironment(dataStore.getPingOneEnvironmentId());
        dataSource.setPingOneGateway(dataStore.getPingOneLdapGatewayId());
        dataSource.setDescription(dataStore.getName());
        dataSource.setUseSSL(BooleanUtils.toBooleanDefaultIfNull((Boolean)validator.getUseSSL(), (boolean)false));
        dataSource.setUseStartTLS(BooleanUtils.toBooleanDefaultIfNull((Boolean)validator.getUseStartTLS(), (boolean)false));
        if (StringUtils.isNotBlank((String)dataStore.getName())) {
            dataSource.setDsName(dataStore.getName());
        }
        if (CollectionUtils.isNotEmpty(dataStore.getBinaryAttributes())) {
            dataSource.setBinaryAttributes(dataStore.getBinaryAttributes());
        }
    }

    @Override
    public void domainToApi(LdapDataSource dataSource, PingOneLdapGatewayDataStore dataStore) {
        super.domainToApi(dataSource, dataStore);
        if (dataSource.isActiveDirectoryType()) {
            dataStore.setLdapType(LdapType.ACTIVE_DIRECTORY);
        } else if (dataSource.isSunOneType()) {
            dataStore.setLdapType(LdapType.ORACLE_DIRECTORY_SERVER);
        } else if (dataSource.isOracleUnifiedDirectoryType()) {
            dataStore.setLdapType(LdapType.ORACLE_UNIFIED_DIRECTORY);
        } else if (dataSource.isPingDirectoryType()) {
            dataStore.setLdapType(LdapType.PING_DIRECTORY);
        } else if (dataSource.isPingDSType()) {
            dataStore.setLdapType(LdapType.PING_DS);
        } else {
            dataStore.setLdapType(LdapType.GENERIC);
        }
        dataStore.setPingOneConnectionRef(new ResourceLink(dataSource.getPingOneConnection(), ApiUtil.getResourceUrl("/pingOneConnections", dataSource.getPingOneConnection())));
        dataStore.setPingOneEnvironmentId(dataSource.getPingOneEnvironment());
        dataStore.setPingOneLdapGatewayId(dataSource.getPingOneGateway());
        dataStore.setUseSsl(dataSource.getUseSSL());
        dataStore.setUseStartTLS(dataSource.getUseStartTLS());
        if (StringUtils.isNotBlank((String)dataSource.getDsName())) {
            dataStore.setName(dataSource.getDsName());
        }
        if (CollectionUtils.isNotEmpty((Collection)dataSource.getBinaryAttributes())) {
            dataStore.setBinaryAttributes(dataSource.getBinaryAttributes());
        }
    }
}

