/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.MetadataSigningSettings;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.SignatureAlgorithm;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.pingcommons.crypto.HashAlgorithm;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class MetadataSigningSettingsTranslator {
    public static MetadataSigningSettings domainToApi(LocalSettings localSettings) {
        MetadataSigningSettings settings = new MetadataSigningSettings();
        String keyAlias = localSettings.getMetadataSigningKeyAlias();
        if (StringUtils.isNotBlank((String)keyAlias)) {
            settings.setSigningKeyRef(new ResourceLink());
            settings.getSigningKeyRef().setId(keyAlias);
            settings.getSigningKeyRef().setLocation(ApiUtil.getResourceUrl("/keyPairs/signing", keyAlias));
            settings.setSignatureAlgorithm(SignatureAlgorithms.getInstance().algUriToNameForRuntime(localSettings.getMetadataSigningAlgorithm()));
        }
        return settings;
    }

    public static void apiToDomain(MetadataSigningSettings settings, LocalSettings localSettings, PkCertManager certManager) {
        String keyAlias;
        String string = keyAlias = settings.getSigningKeyRef() != null ? settings.getSigningKeyRef().getId() : null;
        if (keyAlias != null) {
            PkCert pkCert = certManager.getPkCert(keyAlias);
            localSettings.setMetadataSigningKeyAlias(keyAlias);
            localSettings.setMetadataSigningKeyMD5Fingerprint(pkCert.getFingerPrint(HashAlgorithm.MD5));
            SignatureAlgorithms sigAlgUtils = SignatureAlgorithms.getInstance();
            String publicKeyAlgorithm = pkCert.getPublicKeyAlgorithm();
            String signatureAlgorithm = settings.getSignatureAlgorithm();
            if (StringUtils.isBlank((String)signatureAlgorithm)) {
                SignatureAlgorithm defaultAlgorithm = sigAlgUtils.getDefaultSignatureAlgorithmOfType(publicKeyAlgorithm);
                if (defaultAlgorithm != null) {
                    signatureAlgorithm = defaultAlgorithm.getNameForRuntime();
                    localSettings.setMetadataSigningAlgorithm(SignatureAlgorithms.getInstance().algNameToUriForRuntime(signatureAlgorithm));
                }
            } else {
                localSettings.setMetadataSigningAlgorithm(SignatureAlgorithms.getInstance().algNameToUriForRuntime(signatureAlgorithm));
            }
        } else {
            localSettings.setMetadataSigningKeyAlias(null);
            localSettings.setMetadataSigningAlgorithm(null);
            localSettings.setMetadataSigningKeyMD5Fingerprint(null);
        }
    }
}

