/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.CertView;
import com.pingidentity.admin.api.model.MetadataUrl;
import com.pingidentity.admin.api.model.X509File;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.admin.rest.translator.CertTranslator;
import java.security.cert.CertificateEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.MetadataUrlCertPair;

public class MetadataUrlTranslator {
    private static final Log log = LogFactory.getLog(MetadataUrlTranslator.class);
    private final CertTranslator certTranslator = new CertTranslator();

    public MetadataUrlCertPair apiToDomain(MetadataUrl apiMetadataUrl) {
        MetadataUrlCertPair metadataUrlCertPair = new MetadataUrlCertPair();
        metadataUrlCertPair.setId(apiMetadataUrl.getId());
        metadataUrlCertPair.setName(apiMetadataUrl.getName());
        metadataUrlCertPair.setUrl(apiMetadataUrl.getUrl());
        metadataUrlCertPair.setValidateSignature(apiMetadataUrl.getValidateSignature().booleanValue());
        return metadataUrlCertPair;
    }

    public MetadataUrl domainToApi(MetadataUrlCertPair domainMetadataUrl) {
        MetadataUrl metadataUrl = new MetadataUrl();
        metadataUrl.setId(domainMetadataUrl.getId());
        metadataUrl.setName(domainMetadataUrl.getName());
        metadataUrl.setUrl(domainMetadataUrl.getUrl());
        metadataUrl.setValidateSignature(domainMetadataUrl.isValidateSignature());
        Cert domainCert = domainMetadataUrl.getVerificationCert();
        if (domainCert != null) {
            X509File data = this.getCertX509File(domainCert);
            metadataUrl.setX509File(data);
            CertView certView = this.certTranslator.domainToApi(domainCert);
            metadataUrl.setCertView(certView);
        }
        return metadataUrl;
    }

    private X509File getCertX509File(Cert domainCert) {
        X509File data = new X509File();
        try {
            data.setFileData(domainCert.exportCert());
        }
        catch (CertificateEncodingException e) {
            String message = "Error exporting data for certificate with alias " + domainCert.getAlias();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        return data;
    }
}

