/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ContinuePolicyAction;
import com.pingidentity.admin.api.model.DonePolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.RestartPolicyAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicySelectionActionTranslator;

public class NoOpActionTranslator
extends AuthenticationPolicySelectionActionTranslator<PolicyAction, NoOpAction> {
    @Override
    public PolicyAction domainToApi(NoOpAction domainAction) {
        PolicyAction apiAction;
        switch (domainAction.getType()) {
            case CONTINUE: {
                apiAction = new ContinuePolicyAction();
                break;
            }
            case DONE: {
                apiAction = new DonePolicyAction();
                break;
            }
            case RESTART: {
                apiAction = new RestartPolicyAction();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected NoOpAction type: " + domainAction.getType());
            }
        }
        super.domainToApi(apiAction, domainAction);
        return apiAction;
    }

    @Override
    public AuthnSelectionAction apiToDomain(PolicyAction apiAction) {
        NoOpAction domainAction;
        if (apiAction instanceof DonePolicyAction) {
            domainAction = new NoOpAction(NoOpAction.Type.DONE);
        } else if (apiAction instanceof ContinuePolicyAction) {
            domainAction = new NoOpAction(NoOpAction.Type.CONTINUE);
        } else if (apiAction instanceof RestartPolicyAction) {
            domainAction = new NoOpAction(NoOpAction.Type.RESTART);
        } else {
            throw new RuntimeException("Unexpected NoOpAction type: " + apiAction.getType());
        }
        super.apiToDomain(apiAction, domainAction);
        return domainAction;
    }
}

