/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.OAuthOidcKeysSettings;
import com.pingidentity.admin.api.model.OAuthOidcKeysSettingsCertificateInformation;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.RsaAlgKeyId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.JWKSEndpointDynamicKeysSetting;
import org.sourceid.oauth20.domain.JWKSEndpointSetting;

public class OAuthOidcKeysTranslator {
    public static JWKSEndpointSetting apiToDomain(OAuthOidcKeysSettings apiDataObj) {
        JWKSEndpointSetting domainDataObj = new JWKSEndpointSetting();
        if (apiDataObj == null) {
            return domainDataObj;
        }
        if (apiDataObj.isStaticJwksEnabled() != null) {
            domainDataObj.setEnableStaticKeys(apiDataObj.isStaticJwksEnabled().booleanValue());
        }
        if (apiDataObj.getP256ActiveCertRef() != null) {
            domainDataObj.setP256ActiveId(apiDataObj.getP256ActiveCertRef().getId());
        }
        if (apiDataObj.getP256PreviousCertRef() != null) {
            domainDataObj.setP256PreviousId(apiDataObj.getP256PreviousCertRef().getId());
        }
        if (apiDataObj.isP256PublishX5cParameter() != null) {
            domainDataObj.setP256PublishX5cParameter(apiDataObj.isP256PublishX5cParameter().booleanValue());
        }
        domainDataObj.setP256ActiveKeyId(apiDataObj.getP256ActiveKeyId());
        domainDataObj.setP256PreviousKeyId(apiDataObj.getP256PreviousKeyId());
        if (apiDataObj.getP384ActiveCertRef() != null) {
            domainDataObj.setP384ActiveId(apiDataObj.getP384ActiveCertRef().getId());
        }
        if (apiDataObj.getP384PreviousCertRef() != null) {
            domainDataObj.setP384PreviousId(apiDataObj.getP384PreviousCertRef().getId());
        }
        if (apiDataObj.isP384PublishX5cParameter() != null) {
            domainDataObj.setP384PublishX5cParameter(apiDataObj.isP384PublishX5cParameter().booleanValue());
        }
        domainDataObj.setP384ActiveKeyId(apiDataObj.getP384ActiveKeyId());
        domainDataObj.setP384PreviousKeyId(apiDataObj.getP384PreviousKeyId());
        if (apiDataObj.getP521ActiveCertRef() != null) {
            domainDataObj.setP521ActiveId(apiDataObj.getP521ActiveCertRef().getId());
        }
        if (apiDataObj.getP521PreviousCertRef() != null) {
            domainDataObj.setP521PreviousId(apiDataObj.getP521PreviousCertRef().getId());
        }
        if (apiDataObj.isP521PublishX5cParameter() != null) {
            domainDataObj.setP521PublishX5cParameter(apiDataObj.isP521PublishX5cParameter().booleanValue());
        }
        domainDataObj.setP521ActiveKeyId(apiDataObj.getP521ActiveKeyId());
        domainDataObj.setP521PreviousKeyId(apiDataObj.getP521PreviousKeyId());
        if (apiDataObj.getRsaActiveCertRef() != null) {
            domainDataObj.setRsaActiveId(apiDataObj.getRsaActiveCertRef().getId());
        }
        if (apiDataObj.getRsaPreviousCertRef() != null) {
            domainDataObj.setRsaPreviousId(apiDataObj.getRsaPreviousCertRef().getId());
        }
        if (apiDataObj.isRsaPublishX5cParameter() != null) {
            domainDataObj.setRsaPublishX5cParameter(apiDataObj.isRsaPublishX5cParameter().booleanValue());
        }
        domainDataObj.setRsaActiveKeyId(apiDataObj.getRsaActiveKeyId());
        domainDataObj.setRsaPreviousKeyId(apiDataObj.getRsaPreviousKeyId());
        if (apiDataObj.getP256DecryptionActiveCertRef() != null) {
            domainDataObj.setP256DecryptionActiveId(apiDataObj.getP256DecryptionActiveCertRef().getId());
        }
        if (apiDataObj.getP256DecryptionPreviousCertRef() != null) {
            domainDataObj.setP256DecryptionPreviousId(apiDataObj.getP256DecryptionPreviousCertRef().getId());
        }
        if (apiDataObj.isP256DecryptionPublishX5cParameter() != null) {
            domainDataObj.setP256DecryptionPublishX5cParameter(apiDataObj.isP256DecryptionPublishX5cParameter().booleanValue());
        }
        domainDataObj.setP256DecryptionActiveKeyId(apiDataObj.getP256DecryptionActiveKeyId());
        domainDataObj.setP256DecryptionPreviousKeyId(apiDataObj.getP256DecryptionPreviousKeyId());
        if (apiDataObj.getP384DecryptionActiveCertRef() != null) {
            domainDataObj.setP384DecryptionActiveId(apiDataObj.getP384DecryptionActiveCertRef().getId());
        }
        if (apiDataObj.getP384DecryptionPreviousCertRef() != null) {
            domainDataObj.setP384DecryptionPreviousId(apiDataObj.getP384DecryptionPreviousCertRef().getId());
        }
        if (apiDataObj.isP384DecryptionPublishX5cParameter() != null) {
            domainDataObj.setP384DecryptionPublishX5cParameter(apiDataObj.isP384DecryptionPublishX5cParameter().booleanValue());
        }
        domainDataObj.setP384DecryptionActiveKeyId(apiDataObj.getP384DecryptionActiveKeyId());
        domainDataObj.setP384DecryptionPreviousKeyId(apiDataObj.getP384DecryptionPreviousKeyId());
        if (apiDataObj.getP521DecryptionActiveCertRef() != null) {
            domainDataObj.setP521DecryptionActiveId(apiDataObj.getP521DecryptionActiveCertRef().getId());
        }
        if (apiDataObj.getP521DecryptionPreviousCertRef() != null) {
            domainDataObj.setP521DecryptionPreviousId(apiDataObj.getP521DecryptionPreviousCertRef().getId());
        }
        if (apiDataObj.isP521DecryptionPublishX5cParameter() != null) {
            domainDataObj.setP521DecryptionPublishX5cParameter(apiDataObj.isP521DecryptionPublishX5cParameter().booleanValue());
        }
        domainDataObj.setP521DecryptionActiveKeyId(apiDataObj.getP521DecryptionActiveKeyId());
        domainDataObj.setP521DecryptionPreviousKeyId(apiDataObj.getP521DecryptionPreviousKeyId());
        if (apiDataObj.getRsaDecryptionActiveCertRef() != null) {
            domainDataObj.setRsaDecryptionActiveId(apiDataObj.getRsaDecryptionActiveCertRef().getId());
        }
        if (apiDataObj.getRsaDecryptionPreviousCertRef() != null) {
            domainDataObj.setRsaDecryptionPreviousId(apiDataObj.getRsaDecryptionPreviousCertRef().getId());
        }
        if (apiDataObj.isRsaDecryptionPublishX5cParameter() != null) {
            domainDataObj.setRsaDecryptionPublishX5cParameter(apiDataObj.isRsaDecryptionPublishX5cParameter().booleanValue());
        }
        domainDataObj.setRsaDecryptionActiveKeyId(apiDataObj.getRsaDecryptionActiveKeyId());
        domainDataObj.setRsaDecryptionPreviousKeyId(apiDataObj.getRsaDecryptionPreviousKeyId());
        domainDataObj.setRsaAlgTypesActiveCustomKeyIds(OAuthOidcKeysTranslator.populateDomainRsaAlgTypeToKeyIds(apiDataObj.getRsaAlgorithmActiveKeyIds()));
        domainDataObj.setRsaAlgTypesPreviousCustomKeyIds(OAuthOidcKeysTranslator.populateDomainRsaAlgTypeToKeyIds(apiDataObj.getRsaAlgorithmPreviousKeyIds()));
        boolean publishDynamicKeyX5cs = Boolean.TRUE.equals(apiDataObj.getPublishDynamicKeyX5cs());
        OAuthOidcKeysSettingsCertificateInformation dynamicKeyCertificateInformation = apiDataObj.getDynamicKeyCertificateInformation();
        JWKSEndpointDynamicKeysSetting.Builder builder = new JWKSEndpointDynamicKeysSetting.Builder(publishDynamicKeyX5cs);
        if (dynamicKeyCertificateInformation != null) {
            builder = builder.certOrgName(dynamicKeyCertificateInformation.getOrganization()).certOrgUnitName(dynamicKeyCertificateInformation.getOrganizationUnit()).certCountry(dynamicKeyCertificateInformation.getCountry()).certState(dynamicKeyCertificateInformation.getState()).certCity(dynamicKeyCertificateInformation.getCity());
        }
        domainDataObj.setDynamicKeys(builder.build());
        return domainDataObj;
    }

    public static Map<String, String> populateDomainRsaAlgTypeToKeyIds(List<RsaAlgKeyId> rsaAlgKeyIds) {
        HashMap<String, String> domainRSAlgToKeyIdsMap = null;
        if (rsaAlgKeyIds != null && !rsaAlgKeyIds.isEmpty()) {
            domainRSAlgToKeyIdsMap = new HashMap<String, String>();
            for (RsaAlgKeyId apiRSAlgKeyId : rsaAlgKeyIds) {
                domainRSAlgToKeyIdsMap.put(apiRSAlgKeyId.getRsaAlgType(), apiRSAlgKeyId.getKeyId());
            }
        }
        return domainRSAlgToKeyIdsMap;
    }

    public static List<RsaAlgKeyId> populateApiRsAlgTypeToKeyIds(Map<String, String> domainRSAlgToKeyIds) {
        ArrayList<RsaAlgKeyId> apiRSAlgKeyIds = null;
        if (domainRSAlgToKeyIds != null && !domainRSAlgToKeyIds.isEmpty()) {
            apiRSAlgKeyIds = new ArrayList<RsaAlgKeyId>();
            for (Map.Entry<String, String> domainRSAlgToKeyIdEntry : domainRSAlgToKeyIds.entrySet()) {
                RsaAlgKeyId rsaAlgKeyId = new RsaAlgKeyId(domainRSAlgToKeyIdEntry.getKey(), domainRSAlgToKeyIdEntry.getValue());
                apiRSAlgKeyIds.add(rsaAlgKeyId);
            }
        }
        return apiRSAlgKeyIds;
    }

    public static OAuthOidcKeysSettings domainToApi(JWKSEndpointSetting domainDataObj) {
        JWKSEndpointDynamicKeysSetting dynamicKeys;
        OAuthOidcKeysSettings apiDataObj = new OAuthOidcKeysSettings();
        if (domainDataObj == null) {
            return apiDataObj;
        }
        apiDataObj.setStaticJwksEnabled(domainDataObj.isEnableStaticKeys());
        if (domainDataObj.isEnableStaticKeys()) {
            apiDataObj.setP256ActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP256ActiveId()));
            apiDataObj.setP256PreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP256PreviousId()));
            if (apiDataObj.getP256ActiveCertRef() != null || apiDataObj.getP256PreviousCertRef() != null) {
                apiDataObj.setP256PublishX5cParameter(domainDataObj.isP256PublishX5cParameter());
            }
            apiDataObj.setP256ActiveKeyId(domainDataObj.getP256ActiveKeyId());
            apiDataObj.setP256PreviousKeyId(domainDataObj.getP256PreviousKeyId());
            apiDataObj.setP384ActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP384ActiveId()));
            apiDataObj.setP384PreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP384PreviousId()));
            if (apiDataObj.getP384ActiveCertRef() != null || apiDataObj.getP384PreviousCertRef() != null) {
                apiDataObj.setP384PublishX5cParameter(domainDataObj.isP384PublishX5cParameter());
            }
            apiDataObj.setP384ActiveKeyId(domainDataObj.getP384ActiveKeyId());
            apiDataObj.setP384PreviousKeyId(domainDataObj.getP384PreviousKeyId());
            apiDataObj.setP521ActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP521ActiveId()));
            apiDataObj.setP521PreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP521PreviousId()));
            if (apiDataObj.getP521ActiveCertRef() != null || apiDataObj.getP521PreviousCertRef() != null) {
                apiDataObj.setP521PublishX5cParameter(domainDataObj.isP521PublishX5cParameter());
            }
            apiDataObj.setP521ActiveKeyId(domainDataObj.getP521ActiveKeyId());
            apiDataObj.setP521PreviousKeyId(domainDataObj.getP521PreviousKeyId());
            apiDataObj.setRsaActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getRsaActiveId()));
            apiDataObj.setRsaPreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getRsaPreviousId()));
            if (apiDataObj.getRsaActiveCertRef() != null || apiDataObj.getRsaPreviousCertRef() != null) {
                apiDataObj.setRsaPublishX5cParameter(domainDataObj.isRsaPublishX5cParameter());
            }
            apiDataObj.setRsaActiveKeyId(domainDataObj.getRsaActiveKeyId());
            apiDataObj.setRsaPreviousKeyId(domainDataObj.getRsaPreviousKeyId());
            apiDataObj.setP256DecryptionActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP256DecryptionActiveId()));
            apiDataObj.setP256DecryptionPreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP256DecryptionPreviousId()));
            if (apiDataObj.getP256DecryptionActiveCertRef() != null || apiDataObj.getP256DecryptionPreviousCertRef() != null) {
                apiDataObj.setP256DecryptionPublishX5cParameter(domainDataObj.isP256DecryptionPublishX5cParameter());
            }
            apiDataObj.setP256DecryptionActiveKeyId(domainDataObj.getP256DecryptionActiveKeyId());
            apiDataObj.setP256DecryptionPreviousKeyId(domainDataObj.getP256DecryptionPreviousKeyId());
            apiDataObj.setP384DecryptionActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP384DecryptionActiveId()));
            apiDataObj.setP384DecryptionPreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP384DecryptionPreviousId()));
            if (apiDataObj.getP384DecryptionActiveCertRef() != null || apiDataObj.getP384DecryptionPreviousCertRef() != null) {
                apiDataObj.setP384DecryptionPublishX5cParameter(domainDataObj.isP384DecryptionPublishX5cParameter());
            }
            apiDataObj.setP384DecryptionActiveKeyId(domainDataObj.getP384DecryptionActiveKeyId());
            apiDataObj.setP384DecryptionPreviousKeyId(domainDataObj.getP384DecryptionPreviousKeyId());
            apiDataObj.setP521DecryptionActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP521DecryptionActiveId()));
            apiDataObj.setP521DecryptionPreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getP521DecryptionPreviousId()));
            if (apiDataObj.getP521DecryptionActiveCertRef() != null || apiDataObj.getP521DecryptionPreviousCertRef() != null) {
                apiDataObj.setP521DecryptionPublishX5cParameter(domainDataObj.isP521DecryptionPublishX5cParameter());
            }
            apiDataObj.setP521DecryptionActiveKeyId(domainDataObj.getP521DecryptionActiveKeyId());
            apiDataObj.setP521DecryptionPreviousKeyId(domainDataObj.getP521DecryptionPreviousKeyId());
            apiDataObj.setRsaDecryptionActiveCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getRsaDecryptionActiveId()));
            apiDataObj.setRsaDecryptionPreviousCertRef(OAuthOidcKeysTranslator.createResourceLinkForKey(domainDataObj.getRsaDecryptionPreviousId()));
            if (apiDataObj.getRsaDecryptionActiveCertRef() != null || apiDataObj.getRsaDecryptionPreviousCertRef() != null) {
                apiDataObj.setRsaDecryptionPublishX5cParameter(domainDataObj.isRsaDecryptionPublishX5cParameter());
            }
            apiDataObj.setRsaDecryptionActiveKeyId(domainDataObj.getRsaDecryptionActiveKeyId());
            apiDataObj.setRsaDecryptionPreviousKeyId(domainDataObj.getRsaDecryptionPreviousKeyId());
            apiDataObj.setRsaAlgorithmActiveKeyIds(OAuthOidcKeysTranslator.populateApiRsAlgTypeToKeyIds(domainDataObj.getRsaAlgTypesActiveCustomKeyIds()));
            apiDataObj.setRsaAlgorithmPreviousKeyIds(OAuthOidcKeysTranslator.populateApiRsAlgTypeToKeyIds(domainDataObj.getRsaAlgTypesPreviousCustomKeyIds()));
        }
        if ((dynamicKeys = domainDataObj.getDynamicKeys()) != null) {
            apiDataObj.setPublishDynamicKeyX5cs(dynamicKeys.isPublishCertificates());
            OAuthOidcKeysSettingsCertificateInformation certificateInformation = new OAuthOidcKeysSettingsCertificateInformation();
            certificateInformation.setOrganization(dynamicKeys.getCertOrgName());
            certificateInformation.setOrganizationUnit(dynamicKeys.getCertOrgUnitName());
            certificateInformation.setCountry(dynamicKeys.getCertCountry());
            certificateInformation.setState(dynamicKeys.getCertState());
            certificateInformation.setCity(dynamicKeys.getCertCity());
            apiDataObj.setDynamicKeyCertificateInformation(certificateInformation);
        } else {
            apiDataObj.setPublishDynamicKeyX5cs(false);
            apiDataObj.setDynamicKeyCertificateInformation(null);
        }
        return apiDataObj;
    }

    private static ResourceLink createResourceLinkForKey(String keyId) {
        if (StringUtils.isNotEmpty((String)keyId)) {
            ResourceLink resource = new ResourceLink();
            resource.setId(keyId);
            resource.setLocation(ApiUtil.getResourceUrl("/keyPairs/signing", keyId));
            return resource;
        }
        return null;
    }
}

