/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionCredentials;
import com.pingidentity.admin.api.model.OutboundBackChannelAuth;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pf.admin.rest.translator.AbstractBackChannelTranslator;
import java.security.cert.X509Certificate;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class OutboundBackChannelAuthTranslator
extends AbstractBackChannelTranslator {
    public void domainToApi(ConnectionBase domainConn, ConnectionCredentials credentials) {
        if (!domainConn.isBrowserSsoProfileConfigured()) {
            return;
        }
        if (!this.isBackChannelAuthenticationNeeded(domainConn) || !this.isInboundArtifactSelected(domainConn)) {
            return;
        }
        SoapAuthInfo soapAuthOut = domainConn.getSoapAuthOut();
        OutboundBackChannelAuth outboundBackChannelAuth = new OutboundBackChannelAuth();
        if (soapAuthOut.isHasBasicEntry() && this.authMethodExist(domainConn, soapAuthOut)) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials();
            SoapAuthInfo.OutgoingBasicAuthInfo info = (SoapAuthInfo.OutgoingBasicAuthInfo)soapAuthOut.getBasicAuthInfo();
            creds.setUsername(info.getUsername());
            if (!StringUtils.isBlank((String)info.getPassword())) {
                creds.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(info.getPassword()));
            }
            outboundBackChannelAuth.setHttpBasicCredentials(creds);
        }
        if (soapAuthOut.isHasCertEntry() && this.authMethodExist(domainConn, soapAuthOut)) {
            String href = ApiUtil.getResourceUrl("/keyPairs/sslClient", soapAuthOut.getCertAuthInfo().getAlias());
            outboundBackChannelAuth.setSslAuthKeyPairRef(new ResourceLink(soapAuthOut.getCertAuthInfo().getAlias(), href));
        }
        if (!this.isXaspOnly(domainConn)) {
            outboundBackChannelAuth.setDigitalSignature(soapAuthOut.isHasNoneEntry());
        }
        Boolean digitalSignature = this.getDigitalSignature(domainConn, soapAuthOut);
        outboundBackChannelAuth.setDigitalSignature(digitalSignature);
        outboundBackChannelAuth.setValidatePartnerCert(!soapAuthOut.isDisableCertChainValidation());
        credentials.setOutboundBackChannelAuth(outboundBackChannelAuth);
    }

    public void apiToDomain(Connection apiConn, ConnectionBase domainConn) {
        ConnectionCredentials credentials = apiConn.getCredentials();
        if (credentials.getOutboundBackChannelAuth() == null) {
            return;
        }
        SoapAuthInfo soapAuthOut = domainConn.getSoapAuthOut();
        OutboundBackChannelAuth auth = credentials.getOutboundBackChannelAuth();
        UsernamePasswordCredentials basicAuth = auth.getHttpBasicCredentials();
        if (this.isXaspOnly(apiConn) && this.apiNoAuthTypeSelected(apiConn, null)) {
            soapAuthOut.setHasNoneEntry(true);
        } else {
            ResourceLink sslAuth;
            if (basicAuth != null) {
                String password = null;
                if (!StringUtils.isBlank((String)basicAuth.getPassword())) {
                    password = basicAuth.getPassword();
                } else if (!StringUtils.isBlank((String)basicAuth.getEncryptedPassword())) {
                    password = EncryptedFieldValidator.decryptCiphertext(basicAuth.getEncryptedPassword());
                }
                soapAuthOut.setBasicAuthInfo((SoapAuthInfo.BasicAuthInfo)SoapAuthInfo.OutgoingBasicAuthInfo.fromClearPassword((String)basicAuth.getUsername(), (String)password));
            }
            if ((sslAuth = auth.getSslAuthKeyPairRef()) != null) {
                String alias = sslAuth.getId();
                PkCert pkCert = MgmtFactory.getSslAuthPkCertManager().getPkCert(alias);
                X509Certificate x509Cert = pkCert.getX509Certificate();
                soapAuthOut.setCertAuthInfo(new SoapAuthInfo.CertAuthInfo(null, null, x509Cert, alias));
            }
            soapAuthOut.setHasNoneEntry(auth.isDigitalSignature().booleanValue());
        }
        soapAuthOut.setDisableCertChainValidation(!auth.isValidatePartnerCert());
    }

    private boolean isInboundArtifactSelected(ConnectionBase domainConn) {
        if (domainConn.getRoleType() == Role.SP && (domainConn.getProtocol() == Protocol.SAML10 || domainConn.getProtocol() == Protocol.SAML11)) {
            return false;
        }
        boolean selected = false;
        selected = this.isInboundArtifact(domainConn);
        selected |= this.isSoapSlo(domainConn);
        if (Role.IDP == domainConn.getRoleType()) {
            IdpConnection idpConn = (IdpConnection)domainConn;
            selected |= idpConn.getAttributeAuthority() != null;
        }
        return selected;
    }

    private boolean isInboundArtifact(ConnectionBase domainConn) {
        if (Role.IDP == domainConn.getRoleType() || this.isAnySloSelected(domainConn) || !this.isAnySloSelected(domainConn) && this.isSpSSOSelected(domainConn)) {
            return domainConn.getIncomingBindings().getArtifactBinding();
        }
        return false;
    }

    private boolean isAnySloSelected(ConnectionBase domainConn) {
        EnabledProfiles enabledProfiles = domainConn.getEnabledProfiles();
        return enabledProfiles.isIdpInitiatedSLOEnabled() || enabledProfiles.isSpInitiatedSLOEnabled();
    }

    private boolean isSpSSOSelected(ConnectionBase domainConn) {
        return domainConn.getEnabledProfiles().isSpInitiatedSSOEnabled();
    }

    private boolean isSoapSlo(ConnectionBase domainConn) {
        boolean soapSlo = false;
        if (this.isAnySloSelected(domainConn)) {
            soapSlo |= domainConn.isSloBindingUsed("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        }
        return soapSlo;
    }
}

